/*
 * Decompiled with CFR 0.152.
 */
package com.jbidwatcher.util;

import com.jbidwatcher.util.Pair;
import com.jbidwatcher.util.ZoneDate;
import com.jbidwatcher.util.config.JConfig;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.TimeZone;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class StringTools {
    private static final int YEAR_BASE = 1990;
    private static GregorianCalendar sMidpointDate = new GregorianCalendar(1990, 0, 1);
    public static final int HIGHBIT_ASCII = 128;
    private static final ZoneDate sNullZoneDate = new ZoneDate(null, null);

    public static String decodeLatin(String latinString) {
        return StringTools.decode(latinString, "ISO-8859-1");
    }

    public static String decode(String original, String charset) {
        if (charset == null || charset.equalsIgnoreCase("UTF-8")) {
            return original;
        }
        try {
            return new String(original.getBytes(), charset);
        }
        catch (UnsupportedEncodingException ignore) {
            return original;
        }
    }

    public static String stripHigh(String inString, String fmtString) {
        char[] stripOut = new char[inString.length()];
        inString.getChars(0, inString.length(), stripOut, 0);
        char[] format = new char[fmtString.length()];
        fmtString.getChars(0, fmtString.length(), format, 0);
        String legalString = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789-:,";
        for (int i = 0; i < stripOut.length; ++i) {
            if (stripOut[i] > '\u0080') {
                stripOut[i] = 32;
            }
            if (i >= format.length || format[i] != ' ' || legalString.indexOf(stripOut[i]) != -1) continue;
            stripOut[i] = 32;
        }
        return new String(stripOut);
    }

    public static URL getURLFromString(String siteAddress) {
        URL auctionURL = null;
        try {
            auctionURL = JConfig.getURL(siteAddress);
        }
        catch (MalformedURLException e) {
            JConfig.log().handleException("getURLFromString failed on " + siteAddress, e);
        }
        return auctionURL;
    }

    public static boolean isNumberOnly(String checkVal) {
        int strLength = checkVal.length();
        if (strLength == 0) {
            return false;
        }
        for (int i = 0; i < strLength; ++i) {
            if (Character.isDigit(checkVal.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean deleteRange(StringBuffer sb, int desc_start, int desc_end) {
        if (desc_start < desc_end && desc_start != -1 && desc_end != -1) {
            sb.delete(desc_start, desc_end);
            return true;
        }
        return false;
    }

    public static boolean deleteFirstToLast(StringBuffer sb, String startStr, String altStartStr, String endStr, String altEndStr) {
        int desc_end;
        String fullBuff = sb.toString();
        int desc_start = fullBuff.indexOf(startStr);
        if (desc_start == -1) {
            desc_start = fullBuff.indexOf(altStartStr);
        }
        if (desc_start > (desc_end = fullBuff.lastIndexOf(endStr))) {
            desc_end = fullBuff.lastIndexOf(altEndStr);
        }
        return StringTools.deleteRange(sb, desc_start, desc_end);
    }

    public static boolean deleteRegexPairs(StringBuffer sb, String startStr, String endStr) {
        String expr = startStr + ".*?" + endStr;
        Matcher start = Pattern.compile(expr, 2).matcher(sb);
        LinkedList<Pair<Integer, Integer>> startEndPairs = new LinkedList<Pair<Integer, Integer>>();
        while (start.find()) {
            startEndPairs.add(new Pair<Integer, Integer>(start.start(), start.end()));
        }
        Collections.reverse(startEndPairs);
        for (Pair pair : startEndPairs) {
            StringTools.deleteRange(sb, (Integer)pair.getFirst(), (Integer)pair.getLast());
        }
        return !startEndPairs.isEmpty();
    }

    public static ZoneDate figureDate(String rawTime, String siteDateFormat) {
        return StringTools.figureDate(rawTime, siteDateFormat, true, true);
    }

    public static ZoneDate figureDate(String endTime, String siteDateFormat, boolean strip_high, boolean ignore_badformat) {
        if (endTime != null) {
            endTime = endTime.replace("MEZ", "MET");
        }
        String endTimeFmt = endTime;
        SimpleDateFormat sdf = new SimpleDateFormat(siteDateFormat, Locale.US);
        sdf.set2DigitYearStart(sMidpointDate.getTime());
        if (endTime == null) {
            return sNullZoneDate;
        }
        if (strip_high) {
            endTimeFmt = StringTools.stripHigh(endTime, siteDateFormat);
        }
        return StringTools.parseDateZone(sdf, endTimeFmt, ignore_badformat);
    }

    private static ZoneDate parseDateZone(SimpleDateFormat sdf, String endTimeFmt, boolean ignore_badformat) {
        TimeZone tz;
        Date endingDate;
        try {
            endingDate = sdf.parse(endTimeFmt);
            tz = sdf.getCalendar().getTimeZone();
        }
        catch (ParseException e) {
            if (!ignore_badformat) {
                JConfig.log().handleException("Error parsing date (" + endTimeFmt + "), setting to completed.", e);
                endingDate = new Date();
            } else {
                endingDate = null;
            }
            tz = null;
        }
        return new ZoneDate(tz, endingDate);
    }

    public static String cat(URL loadFrom) {
        if (loadFrom == null) {
            return null;
        }
        try {
            InputStream is = loadFrom.openStream();
            return StringTools.cat(is);
        }
        catch (IOException e) {
            JConfig.log().handleException("Failed to load " + loadFrom.toString(), e);
            return null;
        }
    }

    public static String cat(InputStream is) throws IOException {
        int bytes_read;
        byte[] buf = new byte[65536];
        int offset = 0;
        while ((bytes_read = is.read(buf, offset, 8192)) != -1) {
            offset += bytes_read;
        }
        if (bytes_read == buf.length) {
            JConfig.log().logDebug("File to load is exactly 64K or larger than 64K.  This method does not support that.");
            return null;
        }
        return new String(buf, 0, offset);
    }

    public static String cat(String filename) {
        File fp = new File(filename);
        byte[][] buffer = new byte[1][];
        StringTools.cat(fp, buffer);
        return new String(buffer[0]);
    }

    public static void cat(File fp, byte[][] buf) {
        try {
            buf[0] = new byte[(int)fp.length()];
            FileInputStream fis = new FileInputStream(fp);
            int read = fis.read(buf[0], 0, (int)fp.length());
            if ((long)read != fp.length()) {
                JConfig.log().logDebug("Couldn't read any data from " + fp.getName());
            }
            fis.close();
        }
        catch (IOException e) {
            JConfig.log().handleException("Can't read file " + fp.getName(), e);
        }
    }

    public static String nullSafe(String s) {
        return s == null ? "" : s;
    }

    public static String comma(List<?> list) {
        String rval = "";
        if (list == null || list.isEmpty()) {
            return rval;
        }
        boolean first = true;
        for (Object o : list) {
            if (!first) {
                rval = rval + ", ";
            } else {
                first = false;
            }
            rval = rval + o.toString();
        }
        return rval;
    }

    public static boolean startsWithIgnoreCase(String base, String match) {
        return base.regionMatches(true, 0, match, 0, match.length());
    }

    public static String stripHigh(String inString) {
        char[] stripOut = new char[inString.length()];
        inString.getChars(0, inString.length(), stripOut, 0);
        for (int i = 0; i < stripOut.length; ++i) {
            if (stripOut[i] <= '\u0080') continue;
            stripOut[i] = 32;
        }
        return new String(stripOut);
    }
}

