/*
 * Decompiled with CFR 0.152.
 */
package com.jbidwatcher.util.html;

import com.jbidwatcher.util.config.JConfig;
import com.jbidwatcher.util.html.JHTMLListener;
import com.jbidwatcher.util.html.htmlToken;
import com.jbidwatcher.util.xml.XMLElement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class JHTMLParser {
    private List<htmlToken> m_tokens;
    private JHTMLListener m_notify = null;
    private static final boolean do_uber_debug = false;

    public JHTMLParser(StringBuffer sb, JHTMLListener notify) {
        this.m_notify = notify;
        this.setup();
        this.parse(sb);
    }

    public JHTMLParser(JHTMLListener notify) {
        this.m_notify = notify;
        this.setup();
    }

    private void setup() {
        this.m_tokens = Collections.synchronizedList(new ArrayList());
    }

    protected void parse(StringBuffer trueBuffer) {
        boolean inQuote = false;
        boolean inTag = false;
        boolean inComment = false;
        char prev = '\u0000';
        char next = '\u0000';
        trueBuffer = this.fixupTitle(trueBuffer);
        trueBuffer = this.stripNoBR(trueBuffer);
        int bufLen = trueBuffer.length();
        boolean spitNextTag = false;
        int start = 0;
        int firstClose = 0;
        boolean suspicious = false;
        for (int charStep = 0; charStep < bufLen; ++charStep) {
            char ch = trueBuffer.charAt(charStep);
            if (charStep > 1) {
                prev = trueBuffer.charAt(charStep - 1);
            }
            if (charStep < bufLen - 1) {
                next = trueBuffer.charAt(charStep + 1);
            }
            if (inTag) {
                if (!inComment) {
                    if (inQuote && ch == '>') {
                        suspicious = true;
                        this.debugParsing(trueBuffer, bufLen, charStep);
                        firstClose = charStep;
                    }
                    if (ch == '\"') {
                        if (suspicious && inQuote && prev == '=') {
                            charStep = firstClose;
                            if (charStep > 1) {
                                prev = trueBuffer.charAt(charStep - 1);
                            }
                            if (charStep < bufLen - 1) {
                                next = trueBuffer.charAt(charStep + 1);
                            }
                            inQuote = false;
                            suspicious = false;
                            JConfig.log().logDebug("Potential quote error!");
                            spitNextTag = true;
                        }
                        if (this.isEndTag(inQuote, prev, next)) {
                            spitNextTag = true;
                        } else {
                            boolean bl = inQuote = !inQuote;
                        }
                    }
                }
                if (inQuote || ch != '>') continue;
                if (!inComment) {
                    if (suspicious) {
                        suspicious = false;
                    }
                    this.logSubstringWeirdness(trueBuffer, start, charStep);
                    this.addToken(trueBuffer.substring(start, charStep), 1);
                    if (spitNextTag && JConfig.queryConfiguration("show.badhtml", "false").equals("true")) {
                        JConfig.log().logDebug("Added 'bad' tag: <" + trueBuffer.substring(start, charStep) + ">");
                    }
                    spitNextTag = false;
                } else {
                    inComment = prev != '-' || trueBuffer.charAt(charStep - 2) != '-';
                }
                inTag = inComment;
                if (inTag) continue;
                start = charStep + 1;
                continue;
            }
            if (ch != '<') continue;
            this.addContentBlock(trueBuffer, start, charStep);
            inTag = true;
            inComment = charStep + 3 < bufLen && next == '!' && trueBuffer.charAt(charStep + 2) == '-' && trueBuffer.charAt(charStep + 3) == '-';
            start = charStep + 1;
            if (!inComment) continue;
            charStep += 3;
        }
        this.addToken("", 5);
    }

    private boolean isEndTag(boolean inQuote, char prev, char next) {
        boolean endingTag;
        boolean bl = endingTag = !inQuote && prev != '=' && next == '>';
        if (endingTag && JConfig.queryConfiguration("show.badhtml", "false").equals("true")) {
            JConfig.log().logDebug("Quote error!");
        }
        return endingTag;
    }

    private void debugParsing(StringBuffer trueBuffer, int bufLen, int charStep) {
        if (JConfig.debugging) {
            String oddText;
            int i;
            int pre_nl = 0;
            int post_nl = 0;
            for (i = charStep - 1; pre_nl == 0 && i > 0 && i > charStep - 40; --i) {
                if (trueBuffer.charAt(i) != '\n') continue;
                pre_nl = i + 1;
            }
            if (pre_nl == 0) {
                pre_nl = i;
            }
            for (i = charStep + 1; post_nl == 0 && i < bufLen && i < charStep + 20; ++i) {
                if (trueBuffer.charAt(i) != '\n') continue;
                post_nl = i;
            }
            if (post_nl == 0) {
                post_nl = i;
            }
            if ((oddText = trueBuffer.substring(pre_nl, post_nl)).indexOf("type=\"submit\"") == -1 && oddText.indexOf("name=\"Submit\"") == -1 && !oddText.startsWith("<META") && JConfig.queryConfiguration("show.badhtml", "false").equals("true")) {
                JConfig.log().logMessage("Found an unusual tag @ " + charStep + "...  (" + oddText + ")");
            }
        }
    }

    private void logSubstringWeirdness(StringBuffer trueBuffer, int start, int charStep) {
        if (charStep < start) {
            // empty if block
        }
    }

    private StringBuffer fixupTitle(StringBuffer trueBuffer) {
        if (JConfig.queryConfiguration("ebay.titleFix", "true").equals("true")) {
            StringBuffer sb = new StringBuffer(trueBuffer.length());
            Matcher m = Pattern.compile("<title>(.*)</title>").matcher(trueBuffer);
            String quotedTitle = null;
            while (m.find()) {
                if (quotedTitle == null) {
                    quotedTitle = "<title>" + XMLElement.encodeString(m.group(1)) + "</title>";
                }
                m.appendReplacement(sb, Matcher.quoteReplacement(quotedTitle));
            }
            m.appendTail(sb);
            trueBuffer = sb;
        }
        return trueBuffer;
    }

    private void addContentBlock(StringBuffer trueBuffer, int start, int charStep) {
        String whatToAdd;
        String trimmed;
        if (start != charStep && !(trimmed = (whatToAdd = trueBuffer.substring(start, charStep)).trim()).equals("")) {
            this.addToken(whatToAdd, 4);
        }
    }

    private boolean addValidTag(StringBuffer trueBuffer, boolean spitNextTag, int start, int charStep) {
        this.addToken(trueBuffer.substring(start, charStep), 1);
        if (spitNextTag) {
            if (JConfig.queryConfiguration("show.badhtml", "false").equals("true")) {
                JConfig.log().logDebug("Added 'bad' tag: <" + trueBuffer.substring(start, charStep) + ">");
            }
            spitNextTag = false;
        }
        return spitNextTag;
    }

    private void debugUnusualTags(StringBuffer trueBuffer, int bufLen, int charStep) {
        String oddText;
        int i;
        int pre_nl = 0;
        int post_nl = 0;
        for (i = charStep - 1; pre_nl == 0 && i > 0 && i > charStep - 40; --i) {
            if (trueBuffer.charAt(i) != '\n') continue;
            pre_nl = i + 1;
        }
        if (pre_nl == 0) {
            pre_nl = i;
        }
        for (i = charStep + 1; post_nl == 0 && i < bufLen && i < charStep + 20; ++i) {
            if (trueBuffer.charAt(i) != '\n') continue;
            post_nl = i;
        }
        if (post_nl == 0) {
            post_nl = i;
        }
        if ((oddText = trueBuffer.substring(pre_nl, post_nl)).indexOf("type=\"submit\"") == -1 && oddText.indexOf("name=\"Submit\"") == -1 && !oddText.startsWith("<META") && JConfig.queryConfiguration("show.badhtml", "false").equals("true")) {
            JConfig.log().logMessage("Found an unusual tag @ " + charStep + "...  (" + oddText + ")");
        }
    }

    private StringBuffer stripNoBR(StringBuffer trueBuffer) {
        StringBuffer sb = new StringBuffer(trueBuffer.length());
        Matcher m = Pattern.compile("(<nobr>|</nobr>)").matcher(trueBuffer);
        while (m.find()) {
            m.appendReplacement(sb, "");
        }
        m.appendTail(sb);
        trueBuffer = sb;
        return trueBuffer;
    }

    private void addToken(String newToken, int tokType) {
        htmlToken finalToken;
        switch (tokType) {
            case 1: {
                int realTokenType = tokType;
                if (this.isEndTag(newToken)) {
                    realTokenType = 2;
                }
                if (this.isSingletonTag(newToken)) {
                    realTokenType = 3;
                }
                finalToken = new htmlToken(newToken, realTokenType);
                break;
            }
            case 4: {
                String cleanToken = this.stripWhitespace(newToken);
                if (cleanToken.length() == 0) {
                    return;
                }
                finalToken = new htmlToken(cleanToken, tokType);
                break;
            }
            default: {
                finalToken = new htmlToken(newToken, tokType);
            }
        }
        if (this.m_notify != null) {
            this.m_notify.addToken(finalToken, this.m_tokens.size());
        }
        this.m_tokens.add(finalToken);
    }

    private boolean isEndTag(String checkTag) {
        return checkTag.length() != 0 && checkTag.charAt(0) == '/';
    }

    private boolean isSingletonTag(String checkTag) {
        return checkTag.length() != 0 && checkTag.charAt(checkTag.length() - 1) == '/';
    }

    private String stripWhitespace(String cleanupString) {
        String resultString = cleanupString.replaceAll("&nbsp;?", " ");
        if (resultString.length() != 0) {
            resultString = resultString.replace('\u00a0', ' ');
        }
        return resultString.trim();
    }

    public List<htmlToken> getTokens() {
        return this.m_tokens;
    }

    public int getTokenCount() {
        return this.m_tokens.size();
    }

    public htmlToken getTokenAt(int index) {
        if (index < this.getTokenCount()) {
            return this.m_tokens.get(index);
        }
        return null;
    }
}

