/*
 * Decompiled with CFR 0.152.
 */
package com.jbidwatcher.util.queue;

import com.jbidwatcher.util.Currency;
import com.jbidwatcher.util.queue.QObject;
import java.beans.XMLDecoder;
import java.beans.XMLEncoder;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;

public abstract class MessageQueue
implements Runnable {
    protected final LinkedList<Object> _queue = new LinkedList();
    protected List<Listener> _listeners = new ArrayList<Listener>(1);

    protected abstract void handleListener();

    public Listener registerListener(Listener ml) {
        Listener old = this._listeners.isEmpty() ? null : this._listeners.get(0);
        this._listeners.clear();
        this._listeners.add(ml);
        this.handleListener();
        return old;
    }

    public abstract boolean enqueue(String var1);

    public void enqueueBean(QObject xe) {
        ByteArrayOutputStream fos = new ByteArrayOutputStream();
        XMLEncoder xe2 = new XMLEncoder(fos);
        xe2.setPersistenceDelegate(Currency.class, Currency.getDelegate());
        xe2.writeObject(xe);
        xe2.close();
        this.enqueue(fos.toString());
    }

    private Object convertBean(String obj) {
        ByteArrayInputStream fis = new ByteArrayInputStream(obj.getBytes());
        XMLDecoder xd = new XMLDecoder(fis);
        Object rval = xd.readObject();
        xd.close();
        return rval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object dequeue() {
        Object out;
        LinkedList<Object> linkedList = this._queue;
        synchronized (linkedList) {
            out = this._queue.removeFirst();
        }
        if (out instanceof String && ((String)out).contains("java.beans.XMLDecoder")) {
            out = this.convertBean((String)out);
        }
        return out;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        LinkedList<Object> linkedList = this._queue;
        synchronized (linkedList) {
            this._queue.clear();
        }
    }

    public void removeListener(Listener listener) {
        this._listeners.remove(listener);
    }

    public void addListener(Listener listener) {
        this._listeners.add(listener);
    }

    public static interface Listener {
        public void messageAction(Object var1);
    }
}

