/*
 * Decompiled with CFR 0.152.
 */
package com.jbidwatcher.util.queue;

import com.jbidwatcher.util.config.JConfig;
import com.jbidwatcher.util.queue.MessageQueue;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;

public final class PlainMessageQueue
extends MessageQueue {
    List<Object> _postpone = new ArrayList<Object>();
    Thread _myself = new Thread(this);

    @Override
    protected void handleListener() {
        if (this._postpone != null) {
            for (Object data : this._postpone) {
                this.enqueueObject(data);
            }
            this._postpone.clear();
            this._postpone = null;
        }
    }

    public PlainMessageQueue(Object qName) {
        this._myself.setDaemon(true);
        this._myself.setName("MQ_" + qName);
        this._myself.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        while (true) {
            boolean empty;
            Object data = null;
            try {
                LinkedList linkedList = this._queue;
                synchronized (linkedList) {
                    if (this._queue.isEmpty()) {
                        this._queue.wait();
                    }
                    data = this.dequeue();
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (data == null) continue;
            do {
                boolean listeners = !this._listeners.isEmpty();
                boolean heard = false;
                if (listeners) {
                    try {
                        for (MessageQueue.Listener l : this._listeners) {
                            if (l == null) continue;
                            heard = true;
                            l.messageAction(data);
                        }
                    }
                    catch (Exception e) {
                        JConfig.log().handleException("PMQ Caught exception: " + e, e);
                        this.clear();
                    }
                }
                if (!heard) {
                    JConfig.log().logDebug(this._myself.getName() + ": Postponing Message: " + data);
                    if (this._postpone != null) {
                        this._postpone.add(data);
                    }
                }
                LinkedList linkedList = this._queue;
                synchronized (linkedList) {
                    empty = this._queue.isEmpty();
                    if (!empty) {
                        data = this.dequeue();
                    }
                }
            } while (!empty);
        }
    }

    @Override
    public boolean enqueue(String entry) {
        if (JConfig.queryConfiguration("debug.queues", "false").equals("true")) {
            JConfig.log().logMessage(entry);
        }
        return this.enqueueObject(entry);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean enqueueObject(Object objToEnqueue) {
        LinkedList linkedList = this._queue;
        synchronized (linkedList) {
            if (this._queue.isEmpty() || this._queue.getLast() != objToEnqueue) {
                this._queue.addLast(objToEnqueue);
                this._queue.notifyAll();
                return true;
            }
        }
        return false;
    }
}

