/*
 * Decompiled with CFR 0.152.
 */
package com.jbidwatcher.util.services;

import com.jbidwatcher.util.config.JConfig;
import com.jbidwatcher.util.queue.MQFactory;
import com.jbidwatcher.util.queue.MessageQueue;
import com.jbidwatcher.util.queue.SuperQueue;
import java.io.BufferedInputStream;
import java.io.InputStream;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import javazoom.jl.player.advanced.AdvancedPlayer;
import javazoom.jl.player.advanced.PlaybackEvent;
import javazoom.jl.player.advanced.PlaybackListener;

public class AudioPlayer
implements MessageQueue.Listener {
    private final Map<Integer, AdvancedPlayer> lastPlayer = new HashMap<Integer, AdvancedPlayer>();
    private Integer track = 0;
    private static int MAX_AUDIO_CLIP = 10;

    private AudioPlayer() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void messageAction(Object deQ) {
        final String s = (String)deQ;
        if (JConfig.queryConfiguration("sound.max_clip") != null) {
            MAX_AUDIO_CLIP = Integer.parseInt(JConfig.queryConfiguration("sound.max_clip"));
        }
        if (s.startsWith("STOP")) {
            String stopTrackStr = s.substring(5);
            Integer stopTrack = Integer.parseInt(stopTrackStr);
            Map<Integer, AdvancedPlayer> map = this.lastPlayer;
            synchronized (map) {
                if (this.lastPlayer.get(stopTrack) != null) {
                    this.lastPlayer.get(stopTrack).stop();
                }
            }
            return;
        }
        Integer stopTrackStr = this.track;
        Integer stopTrack = this.track = Integer.valueOf(this.track + 1);
        SuperQueue sq = SuperQueue.getInstance();
        long now = System.currentTimeMillis();
        sq.preQueue("STOP " + this.track, "sfx", now + (long)(1000 * MAX_AUDIO_CLIP));
        final Integer current_track = this.track;
        new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                InputStream fin;
                try {
                    URL playme = JConfig.getResource(s);
                    fin = playme.openStream();
                }
                catch (Exception badResource) {
                    fin = JConfig.bestSource(JConfig.class.getClassLoader(), s);
                }
                try {
                    BufferedInputStream bin = new BufferedInputStream(fin);
                    AdvancedPlayer p = new AdvancedPlayer((InputStream)bin);
                    AudioPlayer.this.lastPlayer.put(current_track, p);
                    p.setPlayBackListener(new PlaybackListener(){

                        public void playbackStarted(PlaybackEvent playbackEvent) {
                        }

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        public void playbackFinished(PlaybackEvent playbackEvent) {
                            Map map = AudioPlayer.this.lastPlayer;
                            synchronized (map) {
                                AudioPlayer.this.lastPlayer.remove(current_track);
                            }
                        }
                    });
                    p.play();
                }
                catch (Exception mp3Exception) {
                    JConfig.log().handleException("Failed to play.", mp3Exception);
                    Map map = AudioPlayer.this.lastPlayer;
                    synchronized (map) {
                        AudioPlayer.this.lastPlayer.remove(current_track);
                    }
                }
            }
        }).start();
    }

    public static void start() {
        MQFactory.getConcrete("sfx").registerListener(new AudioPlayer());
    }
}

