/*
 * Decompiled with CFR 0.152.
 */
package org.armedbear.lisp;

import org.armedbear.lisp.AbstractArray;
import org.armedbear.lisp.AbstractVector;
import org.armedbear.lisp.BuiltInClass;
import org.armedbear.lisp.Cons;
import org.armedbear.lisp.Fixnum;
import org.armedbear.lisp.Lisp;
import org.armedbear.lisp.LispError;
import org.armedbear.lisp.LispObject;
import org.armedbear.lisp.LispThread;
import org.armedbear.lisp.SimpleArray_UnsignedByte32;
import org.armedbear.lisp.Symbol;
import org.armedbear.lisp.TypeError;

public final class ComplexArray_UnsignedByte32
extends AbstractArray {
    private final int[] dimv;
    private int totalSize;
    private LispObject[] data;
    private AbstractArray array;
    private int displacement;

    public ComplexArray_UnsignedByte32(int[] dimv) {
        this.dimv = dimv;
        this.totalSize = ComplexArray_UnsignedByte32.computeTotalSize(dimv);
        this.data = new LispObject[this.totalSize];
        int i = this.totalSize;
        while (i-- > 0) {
            this.data[i] = Lisp.NIL;
        }
    }

    public ComplexArray_UnsignedByte32(int[] dimv, LispObject initialContents) {
        this.dimv = dimv;
        int rank = dimv.length;
        LispObject rest = initialContents;
        for (int i = 0; i < rank; ++i) {
            dimv[i] = rest.length();
            rest = rest.elt(0);
        }
        this.totalSize = ComplexArray_UnsignedByte32.computeTotalSize(dimv);
        this.data = new LispObject[this.totalSize];
        this.setInitialContents(0, dimv, initialContents, 0);
    }

    public ComplexArray_UnsignedByte32(int[] dimv, AbstractArray array, int displacement) {
        this.dimv = dimv;
        this.array = array;
        this.displacement = displacement;
        this.totalSize = ComplexArray_UnsignedByte32.computeTotalSize(dimv);
    }

    private int setInitialContents(int axis, int[] dims, LispObject contents, int index) {
        if (dims.length == 0) {
            try {
                this.data[index] = contents;
            }
            catch (ArrayIndexOutOfBoundsException e) {
                Lisp.error(new LispError("Bad initial contents for array."));
                return -1;
            }
            ++index;
        } else {
            int i;
            int dim = dims[0];
            if (dim != contents.length()) {
                Lisp.error(new LispError("Bad initial contents for array."));
                return -1;
            }
            int[] newDims = new int[dims.length - 1];
            for (i = 1; i < dims.length; ++i) {
                newDims[i - 1] = dims[i];
            }
            if (contents.listp()) {
                i = contents.length();
                while (i-- > 0) {
                    LispObject content = contents.car();
                    index = this.setInitialContents(axis + 1, newDims, content, index);
                    contents = contents.cdr();
                }
            } else {
                AbstractVector v = Lisp.checkVector(contents);
                int length = v.length();
                for (int i2 = 0; i2 < length; ++i2) {
                    LispObject content = v.AREF(i2);
                    index = this.setInitialContents(axis + 1, newDims, content, index);
                }
            }
        }
        return index;
    }

    public LispObject typeOf() {
        return Lisp.list(Symbol.ARRAY, Lisp.UNSIGNED_BYTE_32, this.getDimensions());
    }

    public LispObject classOf() {
        return BuiltInClass.ARRAY;
    }

    public int getRank() {
        return this.dimv.length;
    }

    public LispObject getDimensions() {
        LispObject result = Lisp.NIL;
        int i = this.dimv.length;
        while (i-- > 0) {
            result = new Cons(Fixnum.getInstance(this.dimv[i]), result);
        }
        return result;
    }

    public int getDimension(int n) {
        try {
            return this.dimv[n];
        }
        catch (ArrayIndexOutOfBoundsException e) {
            Lisp.error(new TypeError("Bad array dimension " + n + "."));
            return -1;
        }
    }

    public LispObject getElementType() {
        return Lisp.UNSIGNED_BYTE_32;
    }

    public int getTotalSize() {
        return this.totalSize;
    }

    public LispObject arrayDisplacement() {
        Fixnum value2;
        LispObject value1;
        if (this.array != null) {
            value1 = this.array;
            value2 = Fixnum.getInstance(this.displacement);
        } else {
            value1 = Lisp.NIL;
            value2 = Fixnum.ZERO;
        }
        return LispThread.currentThread().setValues(value1, value2);
    }

    public LispObject AREF(int index) {
        if (this.data != null) {
            try {
                return this.data[index];
            }
            catch (ArrayIndexOutOfBoundsException e) {
                return Lisp.error(new TypeError("Bad row major index " + index + "."));
            }
        }
        return this.array.AREF(index + this.displacement);
    }

    public void aset(int index, LispObject newValue) {
        if (this.data != null) {
            try {
                this.data[index] = newValue;
            }
            catch (ArrayIndexOutOfBoundsException e) {
                Lisp.error(new TypeError("Bad row major index " + index + "."));
            }
        } else {
            this.array.aset(index + this.displacement, newValue);
        }
    }

    public void fill(LispObject obj) {
        if (this.data != null) {
            int i = this.data.length;
            while (i-- > 0) {
                this.data[i] = obj;
            }
        } else {
            int i = this.totalSize;
            while (i-- > 0) {
                this.aset(i, obj);
            }
        }
    }

    public String printObject() {
        return this.printObject(this.dimv);
    }

    public AbstractArray adjustArray(int[] dims, LispObject initialElement, LispObject initialContents) {
        if (this.isAdjustable()) {
            if (initialContents != null) {
                this.setInitialContents(0, dims, initialContents, 0);
            } else {
                SimpleArray_UnsignedByte32 tempArray = new SimpleArray_UnsignedByte32(dims);
                if (initialElement != null) {
                    tempArray.fill(initialElement);
                }
                SimpleArray_UnsignedByte32.copyArray(this, tempArray);
                this.data = tempArray.data;
                for (int i = 0; i < dims.length; ++i) {
                    this.dimv[i] = dims[i];
                }
            }
            return this;
        }
        if (initialContents != null) {
            return new ComplexArray_UnsignedByte32(dims, initialContents);
        }
        ComplexArray_UnsignedByte32 newArray = new ComplexArray_UnsignedByte32(dims);
        if (initialElement != null) {
            newArray.fill(initialElement);
        }
        return newArray;
    }

    public AbstractArray adjustArray(int[] dims, AbstractArray displacedTo, int displacement) {
        if (this.isAdjustable()) {
            for (int i = 0; i < dims.length; ++i) {
                this.dimv[i] = dims[i];
            }
            this.data = null;
            this.array = displacedTo;
            this.displacement = displacement;
            this.totalSize = ComplexArray_UnsignedByte32.computeTotalSize(dims);
            return this;
        }
        ComplexArray_UnsignedByte32 a = new ComplexArray_UnsignedByte32(dims, displacedTo, displacement);
        return a;
    }
}

