/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml;

import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.sourceforge.plantuml.BlockUml;
import net.sourceforge.plantuml.StartUtils;
import net.sourceforge.plantuml.preproc.Defines;
import net.sourceforge.plantuml.preproc.Preprocessor;
import net.sourceforge.plantuml.preproc.ReadLineReader;
import net.sourceforge.plantuml.preproc.UncommentReadLine;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class BlockUmlBuilder {
    private final List<BlockUml> blocks = new ArrayList<BlockUml>();
    private final Set<File> usedFiles = new HashSet<File>();
    private final UncommentReadLine reader2;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BlockUmlBuilder(List<String> list, String string, Defines defines, Reader reader, File file) throws IOException {
        Preprocessor preprocessor = null;
        try {
            this.reader2 = new UncommentReadLine(new ReadLineReader(reader));
            preprocessor = new Preprocessor(this.reader2, string, defines, this.usedFiles, file);
            this.init(preprocessor, list);
        }
        finally {
            if (preprocessor != null) {
                preprocessor.close();
            }
        }
    }

    private void init(Preprocessor preprocessor, List<String> list) throws IOException {
        String string = null;
        ArrayList<String> arrayList = null;
        boolean bl = false;
        while ((string = preprocessor.readLine()) != null) {
            String string2;
            if (StartUtils.isArobaseStartDiagram(string)) {
                arrayList = new ArrayList<String>();
                bl = false;
            }
            if (StartUtils.isArobasePauseDiagram(string)) {
                bl = true;
                this.reader2.setPaused(true);
            }
            if (arrayList != null && !bl) {
                arrayList.add(string);
            } else if (bl && (string2 = StartUtils.getPossibleAppend(string)) != null) {
                arrayList.add(string2);
            }
            if (StartUtils.isArobaseUnpauseDiagram(string)) {
                bl = false;
                this.reader2.setPaused(false);
            }
            if (!StartUtils.isArobaseEndDiagram(string) || arrayList == null) continue;
            arrayList.addAll(1, list);
            this.blocks.add(new BlockUml(arrayList));
            arrayList = null;
            this.reader2.setPaused(false);
        }
    }

    public List<BlockUml> getBlockUmls() {
        return Collections.unmodifiableList(this.blocks);
    }

    public final Set<File> getIncludedFiles() {
        return Collections.unmodifiableSet(this.usedFiles);
    }
}

