/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.activitydiagram3.ftile;

import java.awt.geom.Dimension2D;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import net.sourceforge.plantuml.Dimension2DDouble;
import net.sourceforge.plantuml.activitydiagram3.LinkRendering;
import net.sourceforge.plantuml.activitydiagram3.ftile.Connection;
import net.sourceforge.plantuml.activitydiagram3.ftile.Ftile;
import net.sourceforge.plantuml.activitydiagram3.ftile.FtileGeometry;
import net.sourceforge.plantuml.activitydiagram3.ftile.Swimlane;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.UTranslate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FtileAssemblySimple4747
implements Ftile {
    private final Ftile tile1;
    private final Ftile tile2;
    private double left1 = Double.MIN_VALUE;
    private double right1 = Double.MIN_VALUE;
    private double left2 = Double.MIN_VALUE;
    private double right2 = Double.MIN_VALUE;
    private FtileGeometry calculateDimension;
    private Dimension2D calculateDimensionInternal;

    public String toString() {
        return "FtileAssemblySimple " + this.tile1 + " && " + this.tile2;
    }

    public FtileAssemblySimple4747(Ftile ftile, Ftile ftile2) {
        this.tile1 = ftile;
        this.tile2 = ftile2;
    }

    @Override
    public Swimlane getSwimlaneIn() {
        return this.tile1.getSwimlaneIn();
    }

    @Override
    public Swimlane getSwimlaneOut() {
        return this.tile2.getSwimlaneOut();
    }

    @Override
    public UTranslate getTranslateFor(Ftile ftile, StringBounder stringBounder) {
        if (ftile == this.tile1) {
            return this.getTranslated1(stringBounder);
        }
        if (ftile == this.tile2) {
            return this.getTranslated2(stringBounder);
        }
        UTranslate uTranslate = this.tile1.getTranslateFor(ftile, stringBounder);
        if (uTranslate != null) {
            return uTranslate.compose(this.getTranslated1(stringBounder));
        }
        uTranslate = this.tile2.getTranslateFor(ftile, stringBounder);
        if (uTranslate != null) {
            return uTranslate.compose(this.getTranslated2(stringBounder));
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public void drawU(UGraphic uGraphic) {
        StringBounder stringBounder = uGraphic.getStringBounder();
        uGraphic.apply(this.getTranslated1(stringBounder)).draw(this.tile1);
        uGraphic.apply(this.getTranslated2(stringBounder)).draw(this.tile2);
    }

    private double getLeft1(StringBounder stringBounder) {
        if (this.left1 == Double.MIN_VALUE) {
            FtileGeometry ftileGeometry = this.tile1.calculateDimension(stringBounder);
            this.left1 = ftileGeometry.getLeft();
        }
        return this.left1;
    }

    private double getRight1(StringBounder stringBounder) {
        if (this.right1 == Double.MIN_VALUE) {
            FtileGeometry ftileGeometry = this.tile1.calculateDimension(stringBounder);
            this.right1 = ((Dimension2D)ftileGeometry).getWidth() - this.getLeft1(stringBounder);
        }
        return this.right1;
    }

    private double getLeft2(StringBounder stringBounder) {
        if (this.left2 == Double.MIN_VALUE) {
            this.left2 = this.tile2.calculateDimension(stringBounder).getLeft();
        }
        return this.left2;
    }

    private double getRight2(StringBounder stringBounder) {
        if (this.right2 == Double.MIN_VALUE) {
            FtileGeometry ftileGeometry = this.tile2.calculateDimension(stringBounder);
            this.right2 = ((Dimension2D)ftileGeometry).getWidth() - this.getLeft2(stringBounder);
        }
        return this.right2;
    }

    @Override
    public boolean isKilled() {
        return this.tile1.isKilled() || this.tile2.isKilled();
    }

    @Override
    public LinkRendering getInLinkRendering() {
        return this.tile1.getInLinkRendering();
    }

    @Override
    public LinkRendering getOutLinkRendering() {
        return null;
    }

    @Override
    public FtileGeometry calculateDimension(StringBounder stringBounder) {
        if (this.calculateDimension == null) {
            this.calculateDimension = this.calculateDimensionSlow(stringBounder);
        }
        return this.calculateDimension;
    }

    private FtileGeometry calculateDimensionSlow(StringBounder stringBounder) {
        UTranslate uTranslate = this.getTranslated1(stringBounder);
        UTranslate uTranslate2 = this.getTranslated2(stringBounder);
        FtileGeometry ftileGeometry = this.tile1.calculateDimension(stringBounder).translate(uTranslate);
        FtileGeometry ftileGeometry2 = this.tile2.calculateDimension(stringBounder).translate(uTranslate2);
        if (!ftileGeometry2.hasPointOut()) {
            return new FtileGeometry(this.calculateDimensionInternal(stringBounder), ftileGeometry.getLeft(), ftileGeometry.getInY());
        }
        if (ftileGeometry.getLeft() != ftileGeometry2.getLeft()) {
            throw new IllegalStateException();
        }
        return new FtileGeometry(this.calculateDimensionInternal(stringBounder), ftileGeometry.getLeft(), ftileGeometry.getInY(), ftileGeometry2.getOutY());
    }

    private Dimension2D calculateDimensionInternal(StringBounder stringBounder) {
        if (this.calculateDimensionInternal == null) {
            this.calculateDimensionInternal = this.calculateDimensionInternalSlow(stringBounder);
        }
        return this.calculateDimensionInternal;
    }

    private Dimension2D calculateDimensionInternalSlow(StringBounder stringBounder) {
        FtileGeometry ftileGeometry = this.tile1.calculateDimension(stringBounder);
        FtileGeometry ftileGeometry2 = this.tile2.calculateDimension(stringBounder);
        double d = Math.max(this.getLeft1(stringBounder), this.getLeft2(stringBounder)) + Math.max(this.getRight1(stringBounder), this.getRight2(stringBounder));
        double d2 = ((Dimension2D)ftileGeometry).getHeight() + ((Dimension2D)ftileGeometry2).getHeight();
        return new Dimension2DDouble(d, d2);
    }

    private UTranslate getTranslated1(StringBounder stringBounder) {
        double d = this.getLeft1(stringBounder);
        double d2 = this.getLeft2(stringBounder);
        double d3 = Math.max(d, d2);
        return new UTranslate(d3 - d, 0.0);
    }

    private UTranslate getTranslated2(StringBounder stringBounder) {
        FtileGeometry ftileGeometry = this.tile1.calculateDimension(stringBounder);
        double d = this.getLeft1(stringBounder);
        double d2 = this.getLeft2(stringBounder);
        double d3 = Math.max(d, d2);
        return new UTranslate(d3 - d2, ((Dimension2D)ftileGeometry).getHeight());
    }

    @Override
    public Collection<Connection> getInnerConnections() {
        return Collections.emptyList();
    }

    @Override
    public Set<Swimlane> getSwimlanes() {
        HashSet<Swimlane> hashSet = new HashSet<Swimlane>();
        hashSet.addAll(this.tile1.getSwimlanes());
        hashSet.addAll(this.tile2.getSwimlanes());
        return Collections.unmodifiableSet(hashSet);
    }

    @Override
    public boolean shadowing() {
        return this.tile1.shadowing() || this.tile2.shadowing();
    }
}

