/*
 * Decompiled with CFR 0.152.
 */
package com.jbidwatcher.ui.util;

import com.jbidwatcher.ui.util.JMouseAdapter;
import java.awt.event.MouseEvent;
import java.util.TreeMap;
import javax.swing.JButton;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;

public abstract class JContext
extends JMouseAdapter {
    TreeMap<String, JMenuItem> m_menuToText = new TreeMap();

    protected JContext(JPopupMenu inPop) {
        super(inPop);
    }

    protected JContext() {
    }

    @Override
    protected void beforePopup(JPopupMenu inPopup, MouseEvent e) {
        super.beforePopup(inPopup, e);
        this.enableAll();
    }

    protected void enableAll() {
        for (JMenuItem jmi : this.m_menuToText.values()) {
            jmi.setEnabled(true);
        }
    }

    protected void enable(String menuText) {
        this.setEnabled(menuText, true);
    }

    protected void disable(String menuText) {
        this.setEnabled(menuText, false);
    }

    protected void setEnabled(String menuText, boolean enabled) {
        JMenuItem pick = this.m_menuToText.get(menuText);
        if (pick != null) {
            pick.setEnabled(enabled);
        }
    }

    protected void rename(String menuText, String newMenuText) {
        JMenuItem pick = this.m_menuToText.get(menuText);
        if (pick != null) {
            pick.setText(newMenuText);
            this.m_menuToText.remove(menuText);
            this.m_menuToText.put(newMenuText, pick);
        }
    }

    public JButton makeButton(String name) {
        return this.makeButton(name, name);
    }

    public JButton makeButton(String name, String cmd) {
        JButton jb = new JButton(name);
        jb.setActionCommand("NC-" + cmd);
        jb.addActionListener(this);
        return jb;
    }

    protected JMenuItem makeMenuItem(String menuText) {
        return this.makeMenuItem(menuText, menuText);
    }

    protected JMenuItem makeMenuItem(String menuText, String actionCmd) {
        JMenuItem newItem = new JMenuItem();
        newItem.setText(menuText);
        newItem.setActionCommand(actionCmd);
        this.m_menuToText.put(menuText, newItem);
        return newItem;
    }

    public static JMenuItem makeGeneralMenuItem(String menuText, String actionCmd) {
        JMenuItem newItem = new JMenuItem();
        newItem.setText(menuText);
        newItem.setActionCommand(actionCmd);
        return newItem;
    }
}

