/*
 * Decompiled with CFR 0.152.
 */
package com.jbidwatcher.ui.util;

import com.jbidwatcher.util.config.JConfig;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsEnvironment;
import java.awt.Insets;
import java.awt.KeyboardFocusManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import javax.swing.event.MouseInputAdapter;

public class JMouseAdapter
extends MouseInputAdapter
implements ActionListener {
    protected JPopupMenu localPopup;
    private int x = 0;
    private int y = 0;

    public JMouseAdapter(JPopupMenu showPopup) {
        this.localPopup = showPopup;
    }

    public JMouseAdapter() {
        this.localPopup = new JPopupMenu();
    }

    public int getPopupX() {
        return this.x;
    }

    public int getPopupY() {
        return this.y;
    }

    private void evaluatePopup(MouseEvent e) {
        if (e.isPopupTrigger() && this.localPopup != null) {
            this.x = e.getX();
            this.y = e.getY();
            this.beforePopup(this.localPopup, e);
            this.internalPopupMenu(e);
            this.afterPopup(this.localPopup, e);
        }
    }

    @Override
    public void mouseReleased(MouseEvent event) {
        super.mouseReleased(event);
        this.evaluatePopup(event);
    }

    @Override
    public void mousePressed(MouseEvent event) {
        super.mousePressed(event);
        this.evaluatePopup(event);
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        super.mouseClicked(e);
        if (e.isPopupTrigger()) {
            this.evaluatePopup(e);
        } else if (e.getClickCount() == 2) {
            this.beforePopup(this.localPopup, e);
            this.internalDoubleClick(e);
        }
    }

    private static Rectangle ensureRectIsVisible(Rectangle bounds) {
        Rectangle screen = JMouseAdapter.getUsableScreenBounds();
        return new Rectangle(Math.max(screen.x, Math.min(screen.width + screen.x - bounds.width, bounds.x)), Math.max(screen.y, Math.min(screen.height + screen.y - bounds.height, bounds.y)), bounds.width, bounds.height);
    }

    protected void beforePopup(JPopupMenu inPopup, MouseEvent e) {
    }

    protected void afterPopup(JPopupMenu inPopup, MouseEvent e) {
    }

    private void internalPopupMenu(MouseEvent e) {
        Component activeComp = (Component)e.getSource();
        this.localPopup.show(activeComp, this.x, this.y);
        Point point = this.localPopup.getLocationOnScreen();
        Dimension size = this.localPopup.getSize();
        Rectangle oldRect = new Rectangle(point.x, point.y, size.width, size.height);
        Rectangle newRect = JMouseAdapter.ensureRectIsVisible(oldRect);
        if (!oldRect.equals(newRect)) {
            this.localPopup.setLocation(newRect.x, newRect.y);
        }
    }

    protected void internalDoubleClick(MouseEvent e) {
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
    }

    public static GraphicsConfiguration getCurrentGraphicsConfiguration() {
        Window w;
        Component focusOwner = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
        if (focusOwner != null && (w = SwingUtilities.getWindowAncestor(focusOwner)) != null) {
            return w.getGraphicsConfiguration();
        }
        return GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration();
    }

    public static Rectangle getUsableScreenBounds() {
        return JMouseAdapter.getUsableScreenBounds(JMouseAdapter.getCurrentGraphicsConfiguration());
    }

    public static Rectangle getUsableScreenBounds(GraphicsConfiguration gconf) {
        if (gconf == null) {
            gconf = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration();
        }
        Rectangle bounds = new Rectangle(gconf.getBounds());
        try {
            Toolkit toolkit = Toolkit.getDefaultToolkit();
            Insets insets = toolkit.getScreenInsets(gconf);
            bounds.y += insets.top;
            bounds.x += insets.left;
            bounds.height -= insets.top + insets.bottom;
            bounds.width -= insets.left + insets.right;
        }
        catch (Exception ex) {
            JConfig.log().handleException("There was a problem getting screen-related information.", ex);
        }
        return bounds;
    }
}

