/*
 * Decompiled with CFR 0.152.
 */
package com.jbidwatcher.util.services;

import com.jbidwatcher.util.config.JConfig;
import com.orbus.mahalo.Mahalo;
import com.orbus.mahalo.ServiceInfo;
import java.io.IOException;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.util.Enumeration;

public class SyncService {
    private Mahalo mDNS;
    private String hostName;
    private String hostIP;
    private String serviceURL;
    private int servicePort;
    private ServiceInfo mService;

    private static InetAddress getFirstNonLoopbackAddress(boolean preferIpv4, boolean preferIPv6) throws SocketException {
        Enumeration<NetworkInterface> en = NetworkInterface.getNetworkInterfaces();
        while (en.hasMoreElements()) {
            NetworkInterface i = en.nextElement();
            Enumeration<InetAddress> en2 = i.getInetAddresses();
            while (en2.hasMoreElements()) {
                InetAddress addr = en2.nextElement();
                if (addr.isLoopbackAddress()) continue;
                if (addr instanceof Inet4Address) {
                    if (preferIPv6) continue;
                    return addr;
                }
                if (!(addr instanceof Inet6Address) || preferIpv4) continue;
                return addr;
            }
        }
        return null;
    }

    public SyncService(int port) {
        try {
            InetAddress ia = SyncService.getFirstNonLoopbackAddress(true, false);
            this.hostIP = ia.getHostAddress();
            this.hostName = ia.getCanonicalHostName();
            if (this.hostName.matches("([1-9][0-9]*\\.){3}[1-9][0-9]*")) {
                String username = System.getProperty("user.name");
                username = username.replaceAll("[ '\"!@#$%^&*()=+:;\\[\\]{}\\|<>,.?/]", "_");
                this.hostName = username + "_jbidwatcher";
            }
            this.servicePort = port;
            this.serviceURL = "http://" + this.hostIP + ":" + this.servicePort;
            JConfig.setConfiguration("tmp.service.url", this.serviceURL);
            this.mDNS = new Mahalo(null, this.hostName);
            this.mDNS.start();
        }
        catch (Exception ignored) {
            JConfig.log().handleException("Failed to register mDNS", ignored);
        }
    }

    public boolean advertise() {
        if (this.mDNS == null) {
            return false;
        }
        this.mService = new ServiceInfo("_auction._tcp.local.", this.hostName, this.servicePort, this.serviceURL);
        try {
            this.mDNS.registerService(this.mService);
        }
        catch (IOException ioe) {
            return false;
        }
        return true;
    }

    public void stopAdvertising() {
        if (this.mDNS == null) {
            return;
        }
        this.mDNS.unregisterService(this.mService);
    }

    public void stop() {
        this.mDNS.close();
    }
}

