/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.schemaspy;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeSet;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import java.util.logging.Level;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import java.util.zip.ZipInputStream;
import net.sourceforge.schemaspy.TableOrderer;
import net.sourceforge.schemaspy.model.InvalidConfigurationException;
import net.sourceforge.schemaspy.util.DbSpecificConfig;
import net.sourceforge.schemaspy.util.Dot;
import net.sourceforge.schemaspy.view.DefaultSqlFormatter;
import net.sourceforge.schemaspy.view.SqlFormatter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Config {
    private static Config instance;
    private final List<String> options;
    private Map<String, String> dbSpecificOptions;
    private Map<String, String> originalDbSpecificOptions;
    private boolean helpRequired;
    private boolean dbHelpRequired;
    private File outputDir;
    private File graphvizDir;
    private String dbType;
    private String schema;
    private List<String> schemas;
    private String user;
    private Boolean singleSignOn;
    private Boolean noSchema;
    private String password;
    private Boolean promptForPassword;
    private String db;
    private String host;
    private Integer port;
    private String server;
    private String meta;
    private Pattern tableInclusions;
    private Pattern tableExclusions;
    private Pattern columnExclusions;
    private Pattern indirectColumnExclusions;
    private String userConnectionPropertiesFile;
    private Properties userConnectionProperties;
    private Integer maxDbThreads;
    private Integer maxDetailedTables;
    private String driverPath;
    private String css;
    private String charset;
    private String font;
    private Integer fontSize;
    private String description;
    private String dbPropertiesLoadedFrom;
    private Level logLevel;
    private SqlFormatter sqlFormatter;
    private String sqlFormatterClass;
    private Boolean generateHtml;
    private Boolean includeImpliedConstraints;
    private Boolean logoEnabled;
    private Boolean rankDirBugEnabled;
    private Boolean encodeCommentsEnabled;
    private Boolean numRowsEnabled;
    private Boolean viewsEnabled;
    private Boolean meterEnabled;
    private Boolean railsEnabled;
    private Boolean evaluteAll;
    private Boolean highQuality;
    private Boolean lowQuality;
    private Boolean adsEnabled;
    private String schemaSpec;
    private boolean populating = false;
    public static final String DOT_CHARSET = "UTF-8";
    private static final String ESCAPED_EQUALS = "\\=";

    public Config() {
        if (instance == null) {
            Config.setInstance(this);
        }
        this.options = new ArrayList<String>();
    }

    public Config(String[] stringArray) {
        Config.setInstance(this);
        this.options = this.fixupArgs(Arrays.asList(stringArray));
        this.helpRequired = this.options.remove("-?") || this.options.remove("/?") || this.options.remove("?") || this.options.remove("-h") || this.options.remove("-help") || this.options.remove("--help");
        this.dbHelpRequired = this.options.remove("-dbHelp") || this.options.remove("-dbhelp");
    }

    public static Config getInstance() {
        if (instance == null) {
            instance = new Config();
        }
        return instance;
    }

    public static void setInstance(Config config) {
        instance = config;
    }

    public void setHtmlGenerationEnabled(boolean bl) {
        this.generateHtml = bl;
    }

    public boolean isHtmlGenerationEnabled() {
        if (this.generateHtml == null) {
            this.generateHtml = !this.options.remove("-nohtml");
        }
        return this.generateHtml;
    }

    public void setImpliedConstraintsEnabled(boolean bl) {
        this.includeImpliedConstraints = bl;
    }

    public boolean isImpliedConstraintsEnabled() {
        if (this.includeImpliedConstraints == null) {
            this.includeImpliedConstraints = !this.options.remove("-noimplied");
        }
        return this.includeImpliedConstraints;
    }

    public void setOutputDir(String string) {
        if (string.endsWith("\"")) {
            string = string.substring(0, string.length() - 1);
        }
        this.setOutputDir(new File(string));
    }

    public void setOutputDir(File file) {
        this.outputDir = file;
    }

    public File getOutputDir() {
        if (this.outputDir == null) {
            this.setOutputDir(this.pullRequiredParam("-o"));
        }
        return this.outputDir;
    }

    public void setGraphvizDir(String string) {
        if (string.endsWith("\"")) {
            string = string.substring(0, string.length() - 1);
        }
        this.setGraphvizDir(new File(string));
    }

    public void setGraphvizDir(File file) {
        this.graphvizDir = file;
    }

    public File getGraphvizDir() {
        String string;
        if (this.graphvizDir == null && (string = this.pullParam("-gv")) != null) {
            this.setGraphvizDir(string);
        }
        return this.graphvizDir;
    }

    public void setMeta(String string) {
        this.meta = string;
    }

    public String getMeta() {
        if (this.meta == null) {
            this.meta = this.pullParam("-meta");
        }
        return this.meta;
    }

    public void setDbType(String string) {
        this.dbType = string;
    }

    public String getDbType() {
        if (this.dbType == null) {
            this.dbType = this.pullParam("-t");
            if (this.dbType == null) {
                this.dbType = "ora";
            }
        }
        return this.dbType;
    }

    public void setDb(String string) {
        this.db = string;
    }

    public String getDb() {
        if (this.db == null) {
            this.db = this.pullParam("-db");
        }
        return this.db;
    }

    public void setSchema(String string) {
        this.schema = string;
    }

    public String getSchema() {
        if (this.schema == null) {
            this.schema = this.pullParam("-s");
        }
        return this.schema;
    }

    public boolean isSchemaDisabled() {
        if (this.noSchema == null) {
            this.noSchema = this.options.remove("-noschema");
        }
        return this.noSchema;
    }

    public void setHost(String string) {
        this.host = string;
    }

    public String getHost() {
        if (this.host == null) {
            this.host = this.pullParam("-host");
        }
        return this.host;
    }

    public void setPort(Integer n) {
        this.port = n;
    }

    public Integer getPort() {
        if (this.port == null) {
            try {
                this.port = Integer.valueOf(this.pullParam("-port"));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return this.port;
    }

    public void setServer(String string) {
        this.server = string;
    }

    public String getServer() {
        if (this.server == null) {
            this.server = this.pullParam("-server");
        }
        return this.server;
    }

    public void setUser(String string) {
        this.user = string;
    }

    public String getUser() {
        if (this.user == null) {
            this.user = !this.isSingleSignOn() ? this.pullRequiredParam("-u") : this.pullParam("-u");
        }
        return this.user;
    }

    public void setSingleSignOn(boolean bl) {
        this.singleSignOn = bl;
    }

    public boolean isSingleSignOn() {
        if (this.singleSignOn == null) {
            this.singleSignOn = this.options.remove("-sso");
        }
        return this.singleSignOn;
    }

    public void setPassword(String string) {
        this.password = string;
    }

    public String getPassword() {
        if (this.password == null) {
            this.password = this.pullParam("-p");
        }
        return this.password;
    }

    public void setPromptForPasswordEnabled(boolean bl) {
        this.promptForPassword = bl;
    }

    public boolean isPromptForPasswordEnabled() {
        if (this.promptForPassword == null) {
            this.promptForPassword = this.options.remove("-pfp");
        }
        return this.promptForPassword;
    }

    public void setMaxDetailedTabled(int n) {
        this.maxDetailedTables = new Integer(n);
    }

    public int getMaxDetailedTables() {
        if (this.maxDetailedTables == null) {
            int n = 300;
            try {
                n = Integer.parseInt(this.pullParam("-maxdet"));
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.maxDetailedTables = new Integer(n);
        }
        return this.maxDetailedTables;
    }

    public String getConnectionPropertiesFile() {
        return this.userConnectionPropertiesFile;
    }

    public void setConnectionPropertiesFile(String string) throws FileNotFoundException, IOException {
        if (this.userConnectionProperties == null) {
            this.userConnectionProperties = new Properties();
        }
        this.userConnectionProperties.load(new FileInputStream(string));
        this.userConnectionPropertiesFile = string;
    }

    public Properties getConnectionProperties() throws FileNotFoundException, IOException {
        if (this.userConnectionProperties == null) {
            String string = this.pullParam("-connprops");
            if (string != null) {
                if (string.indexOf(ESCAPED_EQUALS) != -1) {
                    this.setConnectionProperties(string);
                } else {
                    this.setConnectionPropertiesFile(string);
                }
            } else {
                this.userConnectionProperties = new Properties();
            }
        }
        return this.userConnectionProperties;
    }

    public void setConnectionProperties(String string) {
        this.userConnectionProperties = new Properties();
        StringTokenizer stringTokenizer = new StringTokenizer(string, ";");
        while (stringTokenizer.hasMoreElements()) {
            String string2 = stringTokenizer.nextToken();
            int n = string2.indexOf(ESCAPED_EQUALS);
            if (n == -1) continue;
            String string3 = string2.substring(0, n);
            String string4 = string2.substring(n + ESCAPED_EQUALS.length());
            this.userConnectionProperties.put(string3, string4);
        }
    }

    public void setDriverPath(String string) {
        this.driverPath = string;
    }

    public String getDriverPath() {
        if (this.driverPath == null) {
            this.driverPath = this.pullParam("-dp");
        }
        if (this.driverPath == null) {
            this.driverPath = this.pullParam("-cp");
        }
        return this.driverPath;
    }

    public void setCss(String string) {
        this.css = string;
    }

    public String getCss() {
        if (this.css == null) {
            this.css = this.pullParam("-css");
            if (this.css == null) {
                this.css = "schemaSpy.css";
            }
        }
        return this.css;
    }

    public void setFont(String string) {
        this.font = string;
    }

    public String getFont() {
        if (this.font == null) {
            this.font = this.pullParam("-font");
            if (this.font == null) {
                this.font = "Helvetica";
            }
        }
        return this.font;
    }

    public void setFontSize(int n) {
        this.fontSize = new Integer(n);
    }

    public int getFontSize() {
        if (this.fontSize == null) {
            int n = 11;
            try {
                n = Integer.parseInt(this.pullParam("-fontsize"));
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.fontSize = new Integer(n);
        }
        return this.fontSize;
    }

    public void setCharset(String string) {
        this.charset = string;
    }

    public String getCharset() {
        if (this.charset == null) {
            this.charset = this.pullParam("-charset");
            if (this.charset == null) {
                this.charset = "ISO-8859-1";
            }
        }
        return this.charset;
    }

    public void setDescription(String string) {
        this.description = string;
    }

    public String getDescription() {
        if (this.description == null) {
            this.description = this.pullParam("-desc");
        }
        return this.description;
    }

    public void setMaxDbThreads(int n) {
        this.maxDbThreads = new Integer(n);
    }

    public int getMaxDbThreads() throws InvalidConfigurationException {
        if (this.maxDbThreads == null) {
            Properties properties;
            try {
                properties = this.getDbProperties(this.getDbType());
            }
            catch (IOException iOException) {
                throw new InvalidConfigurationException("Failed to load properties for " + this.getDbType() + ": " + iOException).setParamName("-type");
            }
            int n = Integer.MAX_VALUE;
            String string = properties.getProperty("dbThreads");
            if (string == null) {
                string = properties.getProperty("dbthreads");
            }
            if (string != null) {
                n = Integer.parseInt(string);
            }
            if ((string = this.pullParam("-dbThreads")) == null) {
                string = this.pullParam("-dbthreads");
            }
            if (string != null) {
                n = Integer.parseInt(string);
            }
            if (n < 0) {
                n = Integer.MAX_VALUE;
            } else if (n == 0) {
                n = 1;
            }
            this.maxDbThreads = new Integer(n);
        }
        return this.maxDbThreads;
    }

    public boolean isLogoEnabled() {
        if (this.logoEnabled == null) {
            this.logoEnabled = !this.options.remove("-nologo");
        }
        return this.logoEnabled;
    }

    public void setRankDirBugEnabled(boolean bl) {
        this.rankDirBugEnabled = bl;
    }

    public boolean isRankDirBugEnabled() {
        if (this.rankDirBugEnabled == null) {
            this.rankDirBugEnabled = this.options.remove("-rankdirbug");
        }
        return this.rankDirBugEnabled;
    }

    public void setRailsEnabled(boolean bl) {
        this.railsEnabled = bl;
    }

    public boolean isRailsEnabled() {
        if (this.railsEnabled == null) {
            this.railsEnabled = this.options.remove("-rails");
        }
        return this.railsEnabled;
    }

    public void setEncodeCommentsEnabled(boolean bl) {
        this.encodeCommentsEnabled = bl;
    }

    public boolean isEncodeCommentsEnabled() {
        if (this.encodeCommentsEnabled == null) {
            this.encodeCommentsEnabled = !this.options.remove("-ahic");
        }
        return this.encodeCommentsEnabled;
    }

    public void setNumRowsEnabled(boolean bl) {
        this.numRowsEnabled = bl;
    }

    public boolean isNumRowsEnabled() {
        if (this.numRowsEnabled == null) {
            this.numRowsEnabled = !this.options.remove("-norows");
        }
        return this.numRowsEnabled;
    }

    public void setViewsEnabled(boolean bl) {
        this.viewsEnabled = bl;
    }

    public boolean isViewsEnabled() {
        if (this.viewsEnabled == null) {
            this.viewsEnabled = !this.options.remove("-noviews");
        }
        return this.viewsEnabled;
    }

    public boolean isMeterEnabled() {
        if (this.meterEnabled == null) {
            this.meterEnabled = this.options.remove("-meter");
        }
        return this.meterEnabled;
    }

    public void setColumnExclusions(String string) {
        this.columnExclusions = Pattern.compile(string);
    }

    public Pattern getColumnExclusions() {
        if (this.columnExclusions == null) {
            String string = this.pullParam("-X");
            if (string == null) {
                string = "[^.]";
            }
            this.columnExclusions = Pattern.compile(string);
        }
        return this.columnExclusions;
    }

    public void setIndirectColumnExclusions(String string) {
        this.indirectColumnExclusions = Pattern.compile(string);
    }

    public Pattern getIndirectColumnExclusions() {
        if (this.indirectColumnExclusions == null) {
            String string = this.pullParam("-x");
            if (string == null) {
                string = "[^.]";
            }
            this.indirectColumnExclusions = Pattern.compile(string);
        }
        return this.indirectColumnExclusions;
    }

    public void setTableInclusions(String string) {
        this.tableInclusions = Pattern.compile(string);
    }

    public Pattern getTableInclusions() {
        if (this.tableInclusions == null) {
            String string = this.pullParam("-i");
            if (string == null) {
                string = ".*";
            }
            try {
                this.tableInclusions = Pattern.compile(string);
            }
            catch (PatternSyntaxException patternSyntaxException) {
                throw new InvalidConfigurationException(patternSyntaxException).setParamName("-i");
            }
        }
        return this.tableInclusions;
    }

    public void setTableExclusions(String string) {
        this.tableExclusions = Pattern.compile(string);
    }

    public Pattern getTableExclusions() {
        if (this.tableExclusions == null) {
            String string = this.pullParam("-I");
            if (string == null) {
                string = "";
            }
            try {
                this.tableExclusions = Pattern.compile(string);
            }
            catch (PatternSyntaxException patternSyntaxException) {
                throw new InvalidConfigurationException(patternSyntaxException).setParamName("-I");
            }
        }
        return this.tableExclusions;
    }

    public List<String> getSchemas() {
        if (this.schemas == null) {
            String string = this.pullParam("-schemas");
            if (string == null) {
                string = this.pullParam("-schemata");
            }
            if (string != null) {
                this.schemas = new ArrayList<String>();
                for (String string2 : string.split("[ ,\"]")) {
                    this.schemas.add(string2);
                }
                if (this.schemas.isEmpty()) {
                    this.schemas = null;
                }
            }
        }
        return this.schemas;
    }

    public void setSqlFormatter(String string) {
        this.sqlFormatterClass = string;
        this.sqlFormatter = null;
    }

    public void setSqlFormatter(SqlFormatter sqlFormatter) {
        this.sqlFormatter = sqlFormatter;
        if (sqlFormatter != null) {
            this.sqlFormatterClass = sqlFormatter.getClass().getName();
        }
    }

    public SqlFormatter getSqlFormatter() throws InvalidConfigurationException {
        if (this.sqlFormatter == null) {
            if (this.sqlFormatterClass == null) {
                this.sqlFormatterClass = this.pullParam("-sqlFormatter");
                if (this.sqlFormatterClass == null) {
                    this.sqlFormatterClass = DefaultSqlFormatter.class.getName();
                }
            }
            try {
                Class<?> clazz = Class.forName(this.sqlFormatterClass);
                this.sqlFormatter = (SqlFormatter)clazz.newInstance();
            }
            catch (Exception exception) {
                throw new InvalidConfigurationException("Failed to initialize instance of SQL formatter: ", exception).setParamName("-sqlFormatter");
            }
        }
        return this.sqlFormatter;
    }

    public void setEvaluateAllEnabled(boolean bl) {
        this.evaluteAll = bl;
    }

    public boolean isEvaluateAllEnabled() {
        if (this.evaluteAll == null) {
            this.evaluteAll = this.options.remove("-all");
        }
        return this.evaluteAll;
    }

    public boolean isOneOfMultipleSchemas() {
        return Boolean.getBoolean("oneofmultipleschemas");
    }

    public void setSchemaSpec(String string) {
        this.schemaSpec = string;
    }

    public String getSchemaSpec() {
        if (this.schemaSpec == null) {
            this.schemaSpec = this.pullParam("-schemaSpec");
        }
        return this.schemaSpec;
    }

    public void setRenderer(String string) {
        Dot.getInstance().setRenderer(string);
    }

    public String getRenderer() {
        String string = this.pullParam("-renderer");
        if (string != null) {
            this.setRenderer(string);
        }
        return Dot.getInstance().getRenderer();
    }

    public void setHighQuality(boolean bl) {
        this.highQuality = bl;
        this.lowQuality = !bl;
        Dot.getInstance().setHighQuality(bl);
    }

    public boolean isHighQuality() {
        if (this.highQuality == null) {
            this.highQuality = this.options.remove("-hq");
            if (this.highQuality.booleanValue()) {
                Dot.getInstance().setHighQuality(this.highQuality);
            }
        }
        this.highQuality = Dot.getInstance().isHighQuality();
        return this.highQuality;
    }

    public boolean isLowQuality() {
        if (this.lowQuality == null) {
            this.lowQuality = this.options.remove("-lq");
            if (this.lowQuality.booleanValue()) {
                Dot.getInstance().setHighQuality(this.lowQuality == false);
            }
        }
        this.lowQuality = !Dot.getInstance().isHighQuality();
        return this.lowQuality;
    }

    public void setAdsEnabled(boolean bl) {
        this.adsEnabled = bl;
    }

    public boolean isAdsEnabled() {
        if (this.adsEnabled == null) {
            this.adsEnabled = !this.options.remove("-noads");
        }
        return this.adsEnabled;
    }

    public void setLogLevel(String string) {
        if (string == null) {
            this.logLevel = Level.WARNING;
            return;
        }
        LinkedHashMap<String, Level> linkedHashMap = new LinkedHashMap<String, Level>();
        linkedHashMap.put("severe", Level.SEVERE);
        linkedHashMap.put("warning", Level.WARNING);
        linkedHashMap.put("info", Level.INFO);
        linkedHashMap.put("config", Level.CONFIG);
        linkedHashMap.put("fine", Level.FINE);
        linkedHashMap.put("finer", Level.FINER);
        linkedHashMap.put("finest", Level.FINEST);
        this.logLevel = (Level)linkedHashMap.get(string.toLowerCase());
        if (this.logLevel == null) {
            throw new InvalidConfigurationException("Invalid logLevel: '" + string + "'. Must be one of: " + linkedHashMap.keySet());
        }
    }

    public Level getLogLevel() {
        if (this.logLevel == null) {
            this.setLogLevel(this.pullParam("-loglevel"));
        }
        return this.logLevel;
    }

    public boolean isHelpRequired() {
        return this.helpRequired;
    }

    public boolean isDbHelpRequired() {
        return this.dbHelpRequired;
    }

    public static String getLoadedFromJar() {
        String string = System.getProperty("java.class.path");
        return new StringTokenizer(string, File.pathSeparator).nextToken();
    }

    public Properties getDbProperties(String string) throws IOException, InvalidConfigurationException {
        Object object;
        Object object2;
        Object object3;
        ResourceBundle resourceBundle = null;
        try {
            object3 = new File(string);
            resourceBundle = new PropertyResourceBundle(new FileInputStream((File)object3));
            this.dbPropertiesLoadedFrom = ((File)object3).getAbsolutePath();
        }
        catch (FileNotFoundException fileNotFoundException) {
            try {
                object2 = new File(string + ".properties");
                resourceBundle = new PropertyResourceBundle(new FileInputStream((File)object2));
                this.dbPropertiesLoadedFrom = ((File)object2).getAbsolutePath();
            }
            catch (FileNotFoundException fileNotFoundException2) {
                try {
                    resourceBundle = ResourceBundle.getBundle(string);
                    this.dbPropertiesLoadedFrom = "[" + Config.getLoadedFromJar() + "]" + File.separator + string + ".properties";
                }
                catch (Exception exception) {
                    try {
                        object = TableOrderer.class.getPackage().getName() + ".dbTypes." + string;
                        object = ((String)object).replace('.', '/');
                        resourceBundle = ResourceBundle.getBundle((String)object);
                        this.dbPropertiesLoadedFrom = "[" + Config.getLoadedFromJar() + "]/" + (String)object + ".properties";
                    }
                    catch (Exception exception2) {
                        exception2.printStackTrace();
                        fileNotFoundException2.printStackTrace();
                        throw fileNotFoundException;
                    }
                }
            }
        }
        object3 = Config.asProperties(resourceBundle);
        resourceBundle = null;
        object2 = this.dbPropertiesLoadedFrom;
        int n = 1;
        while ((object = (String)((Properties)object3).remove("include." + n)) != null) {
            int n2 = ((String)object).indexOf("::");
            if (n2 == -1) {
                throw new InvalidConfigurationException("include directive in " + this.dbPropertiesLoadedFrom + " must have '::' between dbType and key");
            }
            String string2 = ((String)object).substring(0, n2).trim();
            String string3 = ((String)object).substring(n2 + 2).trim();
            Properties properties = this.getDbProperties(string2);
            ((Properties)object3).put(string3, properties.getProperty(string3));
            ++n;
        }
        String string4 = (String)((Properties)object3).remove("extends");
        if (string4 != null) {
            string4 = string4.trim();
            object = this.getDbProperties(string4);
            ((Properties)object).putAll((Map<?, ?>)object3);
            object3 = object;
        }
        this.dbPropertiesLoadedFrom = object2;
        return object3;
    }

    protected String getDbPropertiesLoadedFrom() throws IOException {
        if (this.dbPropertiesLoadedFrom == null) {
            this.getDbProperties(this.getDbType());
        }
        return this.dbPropertiesLoadedFrom;
    }

    public List<String> getRemainingParameters() {
        try {
            this.populate();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new InvalidConfigurationException(illegalArgumentException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new InvalidConfigurationException(illegalAccessException);
        }
        catch (InvocationTargetException invocationTargetException) {
            if (invocationTargetException.getCause() instanceof InvalidConfigurationException) {
                throw (InvalidConfigurationException)invocationTargetException.getCause();
            }
            throw new InvalidConfigurationException(invocationTargetException.getCause());
        }
        catch (IntrospectionException introspectionException) {
            throw new InvalidConfigurationException(introspectionException);
        }
        return this.options;
    }

    public void setDbSpecificOptions(Map<String, String> map) {
        this.dbSpecificOptions = map;
        this.originalDbSpecificOptions = new HashMap<String, String>(map);
    }

    public Map<String, String> getDbSpecificOptions() {
        if (this.dbSpecificOptions == null) {
            this.dbSpecificOptions = new HashMap<String, String>();
        }
        return this.dbSpecificOptions;
    }

    public static Properties asProperties(ResourceBundle resourceBundle) {
        Properties properties = new Properties();
        Enumeration<String> enumeration = resourceBundle.getKeys();
        while (enumeration.hasMoreElements()) {
            String string = enumeration.nextElement();
            properties.put(string, resourceBundle.getObject(string));
        }
        return properties;
    }

    private String pullParam(String string) {
        return this.pullParam(string, false, false);
    }

    private String pullRequiredParam(String string) {
        return this.pullParam(string, true, false);
    }

    private String pullParam(String string, boolean bl, boolean bl2) throws MissingRequiredParameterException {
        int n = this.options.indexOf(string);
        if (n < 0) {
            if (bl) {
                throw new MissingRequiredParameterException(string, bl2);
            }
            return null;
        }
        this.options.remove(n);
        String string2 = this.options.get(n).toString();
        this.options.remove(n);
        return string2;
    }

    /*
     * WARNING - void declaration
     */
    protected List<String> fixupArgs(List<String> list) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String object : list) {
            int string = object.indexOf(61);
            if (string != -1 && string - 1 != object.indexOf(ESCAPED_EQUALS)) {
                arrayList.add(object.substring(0, string));
                arrayList.add(object.substring(string + 1));
                continue;
            }
            arrayList.add(object);
        }
        ArrayList arrayList2 = new ArrayList();
        for (String string : arrayList) {
            void var5_9;
            if (string.startsWith("\"") && string.endsWith("\"")) {
                String string2 = string.substring(1, string.length() - 1);
            }
            arrayList2.add(var5_9);
        }
        return arrayList2;
    }

    private void populate() throws IllegalArgumentException, IllegalAccessException, InvocationTargetException, IntrospectionException {
        if (!this.populating) {
            this.populating = true;
            BeanInfo beanInfo = Introspector.getBeanInfo(Config.class);
            PropertyDescriptor[] propertyDescriptorArray = beanInfo.getPropertyDescriptors();
            for (int i = 0; i < propertyDescriptorArray.length; ++i) {
                Method method = propertyDescriptorArray[i].getReadMethod();
                if (method == null) continue;
                method.invoke((Object)this, (Object[])null);
            }
            this.populating = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Set<String> getBuiltInDatabaseTypes(String string) {
        TreeSet<String> treeSet = new TreeSet<String>();
        ZipInputStream zipInputStream = null;
        try {
            JarEntry jarEntry;
            zipInputStream = new JarInputStream(new FileInputStream(string));
            while ((jarEntry = ((JarInputStream)zipInputStream).getNextJarEntry()) != null) {
                String string2 = jarEntry.getName();
                int n = string2.indexOf(".properties");
                if (n == -1) continue;
                treeSet.add(string2.substring(0, n));
            }
        }
        catch (IOException iOException) {
        }
        finally {
            if (zipInputStream != null) {
                try {
                    zipInputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
        return treeSet;
    }

    protected void dumpUsage(String string, boolean bl) {
        if (string != null) {
            System.out.flush();
            System.err.println("*** " + string + " ***");
        } else {
            System.out.println("SchemaSpy generates an HTML representation of a database schema's relationships.");
        }
        System.err.flush();
        System.out.println();
        if (!bl) {
            System.out.println("Usage:");
            System.out.println(" java -jar " + Config.getLoadedFromJar() + " [options]");
            System.out.println("   -t databaseType       type of database - defaults to ora");
            System.out.println("                           use -dbhelp for a list of built-in types");
            System.out.println("   -u user               connect to the database with this user id");
            System.out.println("   -s schema             defaults to the specified user");
            System.out.println("   -p password           defaults to no password");
            System.out.println("   -o outputDirectory    directory to place the generated output in");
            System.out.println("   -dp pathToDrivers     optional - looks for JDBC drivers here before looking");
            System.out.println("                           in driverPath in [databaseType].properties.");
            System.out.println("Go to http://schemaspy.sourceforge.net for a complete list/description");
            System.out.println(" of additional parameters.");
            System.out.println();
        }
        if (bl) {
            System.out.println("Built-in database types and their required connection parameters:");
            for (String string2 : Config.getBuiltInDatabaseTypes(Config.getLoadedFromJar())) {
                new DbSpecificConfig(string2).dumpUsage();
            }
            System.out.println();
        }
        if (bl) {
            System.out.println("You can use your own database types by specifying the filespec of a .properties file with -t.");
            System.out.println("Grab one out of " + Config.getLoadedFromJar() + " and modify it to suit your needs.");
            System.out.println();
        }
        System.out.println("Sample usage using the default database type (implied -t ora):");
        System.out.println(" java -jar schemaSpy.jar -db mydb -s myschema -u devuser -p password -o output");
        System.out.println();
        System.out.flush();
    }

    public String getParam(String string) {
        try {
            BeanInfo beanInfo = Introspector.getBeanInfo(Config.class);
            PropertyDescriptor[] propertyDescriptorArray = beanInfo.getPropertyDescriptors();
            for (int i = 0; i < propertyDescriptorArray.length; ++i) {
                PropertyDescriptor propertyDescriptor = propertyDescriptorArray[i];
                if (!propertyDescriptor.getName().equalsIgnoreCase(string)) continue;
                Object object = propertyDescriptor.getReadMethod().invoke((Object)this, (Object[])null);
                return object == null ? null : object.toString();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return null;
    }

    public List<String> asList() throws IOException {
        CharSequence charSequence;
        Object object;
        Object object2;
        ArrayList<String> arrayList = new ArrayList<String>();
        if (this.originalDbSpecificOptions != null) {
            object2 = this.originalDbSpecificOptions.keySet().iterator();
            while (object2.hasNext()) {
                object = object2.next();
                charSequence = this.originalDbSpecificOptions.get(object);
                if (!((String)object).startsWith("-")) {
                    object = "-" + (String)object;
                }
                arrayList.add((String)object);
                arrayList.add((String)charSequence);
            }
        }
        if (this.isEncodeCommentsEnabled()) {
            arrayList.add("-ahic");
        }
        if (this.isEvaluateAllEnabled()) {
            arrayList.add("-all");
        }
        if (!this.isHtmlGenerationEnabled()) {
            arrayList.add("-nohtml");
        }
        if (!this.isImpliedConstraintsEnabled()) {
            arrayList.add("-noimplied");
        }
        if (!this.isLogoEnabled()) {
            arrayList.add("-nologo");
        }
        if (this.isMeterEnabled()) {
            arrayList.add("-meter");
        }
        if (!this.isNumRowsEnabled()) {
            arrayList.add("-norows");
        }
        if (!this.isViewsEnabled()) {
            arrayList.add("-noviews");
        }
        if (this.isRankDirBugEnabled()) {
            arrayList.add("-rankdirbug");
        }
        if (this.isRailsEnabled()) {
            arrayList.add("-rails");
        }
        if (this.isSingleSignOn()) {
            arrayList.add("-sso");
        }
        if (!this.isAdsEnabled()) {
            arrayList.add("-noads");
        }
        if (this.isSchemaDisabled()) {
            arrayList.add("-noschema");
        }
        if ((object2 = this.getDriverPath()) != null) {
            arrayList.add("-dp");
            arrayList.add((String)object2);
        }
        arrayList.add("-css");
        arrayList.add(this.getCss());
        arrayList.add("-charset");
        arrayList.add(this.getCharset());
        arrayList.add("-font");
        arrayList.add(this.getFont());
        arrayList.add("-fontsize");
        arrayList.add(String.valueOf(this.getFontSize()));
        arrayList.add("-t");
        arrayList.add(this.getDbType());
        arrayList.add("-renderer");
        arrayList.add(this.getRenderer());
        object2 = this.getDescription();
        if (object2 != null) {
            arrayList.add("-desc");
            arrayList.add((String)object2);
        }
        if ((object2 = this.getPassword()) != null) {
            arrayList.add("-p");
            arrayList.add((String)object2);
        }
        if (this.isPromptForPasswordEnabled()) {
            arrayList.add("-pfp");
        }
        if ((object2 = this.getSchema()) != null) {
            arrayList.add("-s");
            arrayList.add((String)object2);
        }
        if ((object2 = this.getUser()) != null) {
            arrayList.add("-u");
            arrayList.add((String)object2);
        }
        if ((object2 = this.getConnectionPropertiesFile()) != null) {
            arrayList.add("-connprops");
            arrayList.add((String)object2);
        } else {
            object = this.getConnectionProperties();
            if (!((Properties)object).isEmpty()) {
                arrayList.add("-connprops");
                charSequence = new StringBuilder();
                for (Map.Entry<Object, Object> entry : ((Properties)object).entrySet()) {
                    ((StringBuilder)charSequence).append(entry.getKey());
                    ((StringBuilder)charSequence).append(ESCAPED_EQUALS);
                    ((StringBuilder)charSequence).append(entry.getValue());
                    ((StringBuilder)charSequence).append(';');
                }
                arrayList.add(((StringBuilder)charSequence).toString());
            }
        }
        object2 = this.getDb();
        if (object2 != null) {
            arrayList.add("-db");
            arrayList.add((String)object2);
        }
        if ((object2 = this.getHost()) != null) {
            arrayList.add("-host");
            arrayList.add((String)object2);
        }
        if (this.getPort() != null) {
            arrayList.add("-port");
            arrayList.add(this.getPort().toString());
        }
        if ((object2 = this.getServer()) != null) {
            arrayList.add("-server");
            arrayList.add((String)object2);
        }
        if ((object2 = this.getMeta()) != null) {
            arrayList.add("-meta");
            arrayList.add((String)object2);
        }
        if (this.getGraphvizDir() != null) {
            arrayList.add("-gv");
            arrayList.add(this.getGraphvizDir().toString());
        }
        arrayList.add("-loglevel");
        arrayList.add(this.getLogLevel().toString().toLowerCase());
        arrayList.add("-sqlFormatter");
        arrayList.add(this.getSqlFormatter().getClass().getName());
        arrayList.add("-i");
        arrayList.add(this.getTableInclusions().pattern());
        arrayList.add("-I");
        arrayList.add(this.getTableExclusions().pattern());
        arrayList.add("-x");
        arrayList.add(this.getColumnExclusions().pattern());
        arrayList.add("-X");
        arrayList.add(this.getIndirectColumnExclusions().pattern());
        arrayList.add("-dbthreads");
        arrayList.add(String.valueOf(this.getMaxDbThreads()));
        arrayList.add("-maxdet");
        arrayList.add(String.valueOf(this.getMaxDetailedTables()));
        arrayList.add("-o");
        arrayList.add(this.getOutputDir().toString());
        return arrayList;
    }

    public static class MissingRequiredParameterException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;
        private final boolean dbTypeSpecific;

        public MissingRequiredParameterException(String string, boolean bl) {
            this(string, null, bl);
        }

        public MissingRequiredParameterException(String string, String string2, boolean bl) {
            super("Required parameter '" + string + "' " + (string2 == null ? "" : "(" + string2 + ") ") + "was not specified." + (bl ? "  It is required for this database type." : ""));
            this.dbTypeSpecific = bl;
        }

        public boolean isDbTypeSpecific() {
            return this.dbTypeSpecific;
        }
    }
}

