/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml;

import java.io.File;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum FileFormat {
    PNG,
    SVG,
    EPS,
    EPS_TEXT,
    ATXT,
    UTXT,
    XMI_STANDARD,
    XMI_STAR,
    XMI_ARGO,
    PDF,
    MJPEG,
    HTML,
    HTML5,
    VDX;


    public String getFileSuffix() {
        if (this.name().startsWith("XMI")) {
            return ".xmi";
        }
        if (this == EPS_TEXT) {
            return EPS.getFileSuffix();
        }
        return "." + this.name().toLowerCase();
    }

    public boolean isEps() {
        if (this == EPS) {
            return true;
        }
        return this == EPS_TEXT;
    }

    public String changeName(String string, int n) {
        if (n == 0) {
            return this.changeName(string, this.getFileSuffix());
        }
        return this.changeName(string, "_" + String.format("%03d", n) + this.getFileSuffix());
    }

    private String changeName(String string, String string2) {
        String string3 = string.replaceAll("\\.\\w+$", string2);
        if (string3.equals(string)) {
            string3 = string + string2;
        }
        return string3;
    }

    public File computeFilename(File file, int n) {
        if (n == 0) {
            return file;
        }
        File file2 = file.getParentFile();
        return new File(file2, this.computeFilename(file.getName(), n));
    }

    public String computeFilename(String string, int n) {
        if (n == 0) {
            return string;
        }
        return string.replaceAll("\\" + this.getFileSuffix() + "$", "_" + String.format("%03d", n) + this.getFileSuffix());
    }
}

