/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.svek;

import java.awt.geom.Point2D;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sourceforge.plantuml.Log;
import net.sourceforge.plantuml.StringUtils;
import net.sourceforge.plantuml.UmlDiagramType;
import net.sourceforge.plantuml.cucadiagram.IGroup;
import net.sourceforge.plantuml.cucadiagram.Rankdir;
import net.sourceforge.plantuml.cucadiagram.dot.DotData;
import net.sourceforge.plantuml.cucadiagram.dot.Graphviz;
import net.sourceforge.plantuml.cucadiagram.dot.GraphvizUtils;
import net.sourceforge.plantuml.cucadiagram.dot.GraphvizVersion;
import net.sourceforge.plantuml.cucadiagram.dot.GraphvizVersions;
import net.sourceforge.plantuml.cucadiagram.dot.ProcessState;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.posimo.Moveable;
import net.sourceforge.plantuml.svek.Bibliotekon;
import net.sourceforge.plantuml.svek.Cluster;
import net.sourceforge.plantuml.svek.ClusterPosition;
import net.sourceforge.plantuml.svek.ColorSequence;
import net.sourceforge.plantuml.svek.EmptySvgException;
import net.sourceforge.plantuml.svek.Line;
import net.sourceforge.plantuml.svek.MinFinder;
import net.sourceforge.plantuml.svek.Shape;
import net.sourceforge.plantuml.svek.ShapeType;
import net.sourceforge.plantuml.svek.SvekUtils;

public class DotStringFactory
implements Moveable {
    private final Bibliotekon bibliotekon = new Bibliotekon();
    private final Set<String> rankMin = new HashSet<String>();
    private final ColorSequence colorSequence;
    private final Cluster root;
    private Cluster current;
    private final DotData dotData;
    private final StringBounder stringBounder;

    public DotStringFactory(ColorSequence colorSequence, StringBounder stringBounder, DotData dotData) {
        this.colorSequence = colorSequence;
        this.dotData = dotData;
        this.stringBounder = stringBounder;
        this.current = this.root = new Cluster(colorSequence, dotData.getSkinParam(), dotData.getRootGroup());
    }

    public void addShape(Shape shape) {
        this.current.addShape(shape);
    }

    private void printMinRanking(StringBuilder stringBuilder) {
        if (this.rankMin.size() == 0) {
            return;
        }
        stringBuilder.append("{ rank = min;");
        for (String string : this.rankMin) {
            stringBuilder.append(string);
            stringBuilder.append(";");
        }
        stringBuilder.append("}");
    }

    private double getHorizontalDzeta() {
        double d = 0.0;
        for (Line line : this.bibliotekon.allLines()) {
            double d2 = line.getHorizontalDzeta(this.stringBounder);
            if (!(d2 > d)) continue;
            d = d2;
        }
        return d / 10.0;
    }

    private double getVerticalDzeta() {
        double d = 0.0;
        for (Line line : this.bibliotekon.allLines()) {
            double d2 = line.getVerticalDzeta(this.stringBounder);
            if (!(d2 > d)) continue;
            d = d2;
        }
        return d / 10.0;
    }

    String createDotString(String ... stringArray) {
        StringBuilder stringBuilder = new StringBuilder();
        double d = this.getHorizontalDzeta();
        if (d < (double)this.getMinNodeSep()) {
            d = this.getMinNodeSep();
        }
        if (this.dotData.getSkinParam().getNodesep() != 0.0) {
            d = this.dotData.getSkinParam().getNodesep();
        }
        String string = SvekUtils.pixelToInches(d);
        double d2 = this.getVerticalDzeta();
        if (d2 < (double)this.getMinRankSep()) {
            d2 = this.getMinRankSep();
        }
        if (this.dotData.getSkinParam().getRanksep() != 0.0) {
            d2 = this.dotData.getSkinParam().getRanksep();
        }
        String string2 = SvekUtils.pixelToInches(d2);
        stringBuilder.append("digraph unix {");
        SvekUtils.println(stringBuilder);
        for (String string3 : stringArray) {
            if (string3.startsWith("ranksep")) {
                stringBuilder.append("ranksep=" + string2 + ";");
            } else if (string3.startsWith("nodesep")) {
                stringBuilder.append("nodesep=" + string + ";");
            } else {
                stringBuilder.append(string3);
            }
            SvekUtils.println(stringBuilder);
        }
        stringBuilder.append("remincross=true;");
        SvekUtils.println(stringBuilder);
        stringBuilder.append("searchsize=500;");
        SvekUtils.println(stringBuilder);
        stringBuilder.append("compound=true;");
        SvekUtils.println(stringBuilder);
        if (this.dotData.getSkinParam().getRankdir() == Rankdir.LEFT_TO_RIGHT) {
            stringBuilder.append("rankdir=LR;");
            SvekUtils.println(stringBuilder);
        }
        this.manageMinMaxCluster(stringBuilder);
        this.root.printCluster1(stringBuilder, this.bibliotekon.allLines());
        for (Line line : this.bibliotekon.lines0()) {
            line.appendLine(stringBuilder);
        }
        this.root.fillRankMin(this.rankMin);
        this.root.printCluster2(stringBuilder, this.bibliotekon.allLines(), this.stringBounder, this.dotData.getDotMode());
        this.printMinRanking(stringBuilder);
        for (Line line : this.bibliotekon.lines1()) {
            line.appendLine(stringBuilder);
        }
        SvekUtils.println(stringBuilder);
        stringBuilder.append("}");
        return stringBuilder.toString();
    }

    private void manageMinMaxCluster(StringBuilder stringBuilder) {
        ArrayList<String> arrayList = new ArrayList<String>();
        ArrayList<String> arrayList2 = new ArrayList<String>();
        for (Cluster object : this.bibliotekon.allCluster()) {
            String string;
            String string2 = object.getMinPoint();
            if (string2 != null) {
                arrayList.add(string2);
            }
            if ((string = object.getMaxPoint()) == null) continue;
            arrayList2.add(string);
        }
        if (arrayList.size() > 0) {
            stringBuilder.append("{rank=min;");
            for (String string : arrayList) {
                stringBuilder.append(string);
                stringBuilder.append(" [shape=point,width=.01,label=\"\"]");
                stringBuilder.append(";");
            }
            stringBuilder.append("}");
            SvekUtils.println(stringBuilder);
        }
        if (arrayList2.size() > 0) {
            stringBuilder.append("{rank=max;");
            for (String string : arrayList2) {
                stringBuilder.append(string);
                stringBuilder.append(" [shape=point,width=.01,label=\"\"]");
                stringBuilder.append(";");
            }
            stringBuilder.append("}");
            SvekUtils.println(stringBuilder);
        }
    }

    private int getMinRankSep() {
        if (this.dotData.getUmlDiagramType() == UmlDiagramType.ACTIVITY) {
            return 40;
        }
        return 60;
    }

    private int getMinNodeSep() {
        if (this.dotData.getUmlDiagramType() == UmlDiagramType.ACTIVITY) {
            return 20;
        }
        return 35;
    }

    public GraphvizVersion getGraphvizVersion() {
        Graphviz graphviz = GraphvizUtils.create("foo;", "svg");
        File file = graphviz.getDotExe();
        return GraphvizVersions.getInstance().getVersion(file);
    }

    public String getSvg(boolean bl, String ... stringArray) throws IOException {
        String string = this.createDotString(stringArray);
        if (bl) {
            Log.info("Creating temporary file svek.dot");
            SvekUtils.traceDotString(string);
        }
        Graphviz graphviz = GraphvizUtils.create(string, "svg");
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        ProcessState processState = graphviz.createFile3(byteArrayOutputStream);
        byteArrayOutputStream.close();
        if (processState != ProcessState.TERMINATED_OK) {
            throw new IllegalStateException("Timeout4 " + (Object)((Object)processState));
        }
        byte[] byArray = byteArrayOutputStream.toByteArray();
        String string2 = new String(byArray, "UTF-8");
        if (bl) {
            Log.info("Creating temporary file svek.svg");
            SvekUtils.traceSvgString(string2);
        }
        return string2;
    }

    public boolean illegalDotExe() {
        Graphviz graphviz = GraphvizUtils.create(null, "svg");
        File file = graphviz.getDotExe();
        return file == null || !file.isFile() || !file.canRead();
    }

    public File getDotExe() {
        Graphviz graphviz = GraphvizUtils.create(null, "svg");
        return graphviz.getDotExe();
    }

    public ClusterPosition solve(String string) throws IOException, InterruptedException {
        double d;
        double d2;
        List<Point2D.Double> list;
        int n;
        if (string.length() == 0) {
            throw new EmptySvgException();
        }
        Pattern pattern = Pattern.compile("(?m)\\<svg\\s+width=\"(\\d+)pt\"\\s+height=\"(\\d+)pt\"");
        Matcher matcher = pattern.matcher(string);
        if (!matcher.find()) {
            throw new IllegalStateException();
        }
        int n2 = Integer.parseInt(matcher.group(1));
        int n3 = Integer.parseInt(matcher.group(2));
        MinFinder minFinder = new MinFinder();
        for (Shape moveable : this.bibliotekon.allShapes()) {
            double d3;
            double d4;
            n = string.indexOf("<title>" + moveable.getUid() + "</title>");
            if (moveable.getType() == ShapeType.RECTANGLE || moveable.getType() == ShapeType.DIAMOND) {
                list = SvekUtils.extractPointsList(string, n, n3);
                d2 = SvekUtils.getMinX(list);
                d = SvekUtils.getMinY(list);
                minFinder.manage(d2, d);
                moveable.moveSvek(d2, d);
                continue;
            }
            if (moveable.getType() == ShapeType.ROUND_RECTANGLE) {
                List<Point2D.Double> list2;
                int n4 = string.indexOf("d=\"", n + 1);
                n = string.indexOf("points=\"", n + 1);
                if (n4 != -1 && n4 < n) {
                    list2 = SvekUtils.extractD(string, n4, n3);
                } else {
                    list2 = SvekUtils.extractPointsList(string, n, n3);
                    for (int i = 0; i < 3; ++i) {
                        n = string.indexOf("points=\"", n + 1);
                        list2.addAll(SvekUtils.extractPointsList(string, n, n3));
                    }
                }
                d4 = SvekUtils.getMinX(list2);
                d3 = SvekUtils.getMinY(list2);
                minFinder.manage(d4, d3);
                moveable.moveSvek(d4, d3);
                continue;
            }
            if (moveable.getType() == ShapeType.CIRCLE || moveable.getType() == ShapeType.CIRCLE_IN_RECT || moveable.getType() == ShapeType.OVAL) {
                double d5 = SvekUtils.getValue(string, n, "cx");
                d4 = SvekUtils.getValue(string, n, "cy") + (double)n3;
                d3 = SvekUtils.getValue(string, n, "rx");
                double d6 = SvekUtils.getValue(string, n, "ry");
                moveable.moveSvek(d5 - d3, d4 - d6);
                continue;
            }
            throw new IllegalStateException(moveable.getType().toString() + " " + moveable.getUid());
        }
        for (Cluster cluster : this.bibliotekon.allCluster()) {
            n = this.getClusterIndex(string, cluster.getColor());
            list = SvekUtils.extractPointsList(string, n, n3);
            d2 = SvekUtils.getMinX(list);
            d = SvekUtils.getMinY(list);
            double d7 = SvekUtils.getMaxX(list);
            double d8 = SvekUtils.getMaxY(list);
            cluster.setPosition(d2, d, d7, d8);
            minFinder.manage(d2, d);
            if (cluster.getTitleAndAttributeWidth() == 0 || cluster.getTitleAndAttributeHeight() == 0) continue;
            n = this.getClusterIndex(string, cluster.getTitleColor());
            List<Point2D.Double> list3 = SvekUtils.extractPointsList(string, n, n3);
            double d9 = SvekUtils.getMinX(list3);
            double d10 = SvekUtils.getMinY(list3);
            cluster.setTitlePosition(d9, d10);
        }
        for (Line line : this.bibliotekon.allLines()) {
            line.solveLine(string, n3, minFinder);
        }
        for (Line line : this.bibliotekon.allLines()) {
            line.manageCollision(this.bibliotekon.allShapes());
        }
        minFinder.manage(0.0, 0.0);
        return new ClusterPosition(minFinder.getMinX(), minFinder.getMinY(), n2, n3);
    }

    private int getClusterIndex(String string, int n) {
        String string2 = StringUtils.getAsHtml(n).toLowerCase();
        String string3 = "=\"" + string2 + "\"";
        int n2 = string.indexOf(string3);
        if (n2 == -1) {
            String string4 = "stroke:" + string2 + ";";
            n2 = string.indexOf(string4);
        }
        if (n2 == -1) {
            throw new IllegalStateException("Cannot find color " + string2);
        }
        return n2;
    }

    public void openCluster(IGroup iGroup, int n, int n2, TextBlock textBlock, TextBlock textBlock2) {
        this.current = this.current.createChild(iGroup, n, n2, textBlock, textBlock2, this.colorSequence, this.dotData.getSkinParam());
        this.bibliotekon.addCluster(this.current);
    }

    public void closeCluster() {
        if (this.current.getParent() == null) {
            throw new IllegalStateException();
        }
        this.current = this.current.getParent();
    }

    public void moveSvek(double d, double d2) {
        for (Shape moveable : this.bibliotekon.allShapes()) {
            moveable.moveSvek(d, d2);
        }
        for (Line line : this.bibliotekon.allLines()) {
            line.moveSvek(d, d2);
        }
        for (Cluster cluster : this.bibliotekon.allCluster()) {
            cluster.moveSvek(d, d2);
        }
    }

    public final Bibliotekon getBibliotekon() {
        return this.bibliotekon;
    }
}

