/*
 * Decompiled with CFR 0.152.
 */
package com.jbidwatcher.auction;

import com.jbidwatcher.auction.AuctionAction;
import com.jbidwatcher.auction.AuctionEntry;
import com.jbidwatcher.auction.EntryCorral;
import com.jbidwatcher.util.Currency;
import com.jbidwatcher.util.config.JConfig;

public abstract class AuctionActionImpl
implements AuctionAction {
    protected String mIdentifier;
    protected String mAmount;
    protected int mQuantity;
    int mResult = -1;

    protected AuctionActionImpl(String id, Currency amount, int quantity) {
        this(id, amount.fullCurrency(), quantity);
    }

    protected AuctionActionImpl(String id, String amount, int quantity) {
        this.mIdentifier = id;
        this.mAmount = amount;
        this.mQuantity = quantity;
    }

    public AuctionActionImpl() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String activate(EntryCorral corral) {
        Currency amount = Currency.getCurrency(this.mAmount);
        AuctionEntry entry = (AuctionEntry)corral.takeForWrite(this.mIdentifier);
        try {
            boolean success;
            if (entry == null) {
                this.mResult = 14;
                String string = this.getBidResult(amount, this.mResult);
                return string;
            }
            JConfig.increment("stats.bid");
            this.mResult = this.execute(entry, amount, this.mQuantity);
            boolean bl = success = this.mResult == 4 || this.mResult == 16 || this.mResult == 5;
            if (!success) {
                JConfig.getMetrics().trackEventValue("bid", "fail", Integer.toString(this.mResult));
            } else {
                JConfig.getMetrics().trackEvent("bid", "success");
            }
            String bidResultString = this.getBidResult(amount, this.mResult);
            entry.setLastStatus(bidResultString);
            entry.update();
            String string = bidResultString;
            return string;
        }
        finally {
            corral.release(this.mIdentifier);
        }
    }

    protected abstract int execute(AuctionEntry var1, Currency var2, int var3);

    public void setIdentifier(String identifier) {
        this.mIdentifier = identifier;
    }

    public void setAmount(String amount) {
        this.mAmount = amount;
    }

    public void setQuantity(int quantity) {
        this.mQuantity = quantity;
    }

    public String getIdentifier() {
        return this.mIdentifier;
    }

    @Override
    public String getAmount() {
        return this.mAmount;
    }

    @Override
    public int getQuantity() {
        return this.mQuantity;
    }

    @Override
    public int getResult() {
        return this.mResult;
    }

    @Override
    public boolean isSuccessful() {
        return this.mResult == 4 || this.mResult == 5;
    }

    @Override
    public String getBidResult(Currency bidAmount, int bidResult) {
        String bidResultString;
        switch (bidResult) {
            case -1: {
                bidResultString = "Bidding " + bidAmount + " apparently failed for an unknown reason.  Check the auction in the browser, to see if the bid went through anyway.";
                JConfig.increment("stats.bid.unknown_error");
                break;
            }
            case 1: 
            case 9: {
                bidResultString = "Bidding apparently failed, as the auction cannot be bid on anymore (probably ended)!";
                JConfig.increment("stats.bid.too_late");
                break;
            }
            case 10: {
                bidResultString = "Your bid failed, as you are disallowed from bidding on this seller's items.";
                JConfig.increment("stats.bid.banned");
                break;
            }
            case 8: {
                bidResultString = "Your bid was too low, and was not accepted.";
                JConfig.increment("stats.bid.too_low");
                break;
            }
            case 13: {
                bidResultString = "Your bid was below or equal to your previous high bid, and was not accepted.";
                JConfig.increment("stats.bid.too_low");
                break;
            }
            case 11: {
                bidResultString = "Your bid was successful, but it did not meet the reserve price.";
                JConfig.increment("stats.bid.too_low");
                break;
            }
            case 2: {
                bidResultString = "Bidding apparently failed, because of an an invalid amount (" + bidAmount + ").";
                JConfig.increment("stats.bid.too_low");
                break;
            }
            case 3: {
                bidResultString = "Your bid for " + bidAmount + " was submitted, but someone else's bid is still higher.";
                JConfig.increment("stats.bid.outbid");
                break;
            }
            case 12: {
                bidResultString = "Bid failed due to connection problem.  Probably a timeout trying to reach eBay.";
                JConfig.increment("stats.bid.connection_error");
                break;
            }
            case 14: {
                bidResultString = "Your bid failed because the item was removed from JBidwatcher before the bid executed.";
                JConfig.increment("stats.bid.removed");
                break;
            }
            case 4: 
            case 5: {
                bidResultString = "Congratulations!  You have the high bid with " + bidAmount + '.';
                JConfig.increment("stats.bid.success");
                break;
            }
            case 17: {
                bidResultString = "You cannot interact with any auctions, your account has been suspended.";
                JConfig.increment("stats.bid.suspended");
                break;
            }
            case 18: {
                bidResultString = "Sign in failed repeatedly during bid.  Check your username and password information in the Configuration Manager.";
                JConfig.increment("stats.bid.sign_in");
                break;
            }
            case 19: {
                bidResultString = "You are registered in a country to which the seller doesn't ship.";
                JConfig.increment("stats.bid.wont_ship");
                break;
            }
            case 20: {
                bidResultString = "You don't meet some requirement the seller has set for the item.  Check the item details for more information.";
                JConfig.increment("stats.bid.requirement_not_met");
                break;
            }
            case 21: {
                bidResultString = "Sellers are not allowed to bid on their own items.";
                break;
            }
            default: {
                bidResultString = "Something VERY wrong has happened, and I don't know what it is.  Check the auction to see if your bid went through.";
                JConfig.increment("stats.bid.really_bad");
            }
        }
        return bidResultString;
    }
}

