/*
 * Decompiled with CFR 0.152.
 */
package com.jbidwatcher.auction.server.ebay;

import com.jbidwatcher.auction.AuctionEntry;
import com.jbidwatcher.util.Currency;
import com.jbidwatcher.util.Externalized;
import com.jbidwatcher.util.Pair;
import com.jbidwatcher.util.Record;
import com.jbidwatcher.util.StringTools;
import com.jbidwatcher.util.TT;
import com.jbidwatcher.util.ZoneDate;
import com.jbidwatcher.util.html.JHTML;
import java.util.Date;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jsoup.nodes.Document;
import org.jsoup.select.Elements;

public class DeprecatedEbayAuction {
    private String mBidCountScript = null;
    private String mStartComment = null;
    private static Currency zeroDollars = new Currency("$0.00");
    protected TT T;
    private Pattern amountPat = Pattern.compile("([0-9]+\\.[0-9]+|(?i)free)");
    private Pattern digits = Pattern.compile("([0-9]+)");

    public DeprecatedEbayAuction(TT t) {
        this.T = t;
    }

    private static String getResult(JHTML doc, String regex, int match) {
        String rval = doc.grep(regex);
        if (rval != null) {
            if (match == 0) {
                return rval;
            }
            Pattern searcher = Pattern.compile(regex);
            Matcher matcher = searcher.matcher(rval);
            if (matcher.matches()) {
                return matcher.group(match);
            }
        }
        return null;
    }

    protected boolean parsePaypal(JHTML doc) {
        String payments;
        boolean usePaypal;
        String pbp = DeprecatedEbayAuction.getResult(doc, this.T.s("ebayServer.paypalMatcherRegex"), 0);
        boolean bl = usePaypal = pbp != null;
        if (!usePaypal) {
            String preferred = doc.getNextContentAfterRegex("PayPal.?");
            if (preferred != null) {
                if (preferred.contains("preferred")) {
                    usePaypal = true;
                }
                if (preferred.contains("accepted")) {
                    usePaypal = true;
                }
            }
            String methods = doc.getNextContentAfterRegex("Payment methods:?");
            for (int i = 0; i < 3 && !usePaypal; ++i) {
                if (methods != null && methods.equalsIgnoreCase("paypal")) {
                    usePaypal = true;
                    continue;
                }
                methods = doc.getNextContent();
            }
        }
        if ((payments = doc.getNextContentAfterContent("Payments:")) != null && payments.matches("(?si).*paypal.*")) {
            usePaypal = true;
        }
        return usePaypal;
    }

    protected Record parseFeedback(JHTML doc) {
        Matcher percentMatched;
        Record feedback = new Record();
        String score = doc.getContentBeforeContent(this.T.s("ebayServer.feedback"));
        String newPercent = null;
        if (score != null && StringTools.isNumberOnly(score)) {
            feedback.put("feedback", score);
        } else {
            JHTML.SequenceResult result;
            score = doc.getNextContentAfterRegex(this.T.s("ebayServer.sellerInfoPrequel"));
            if (score != null && score.equals("Seller:")) {
                score = doc.getNextContent();
            }
            if (score != null) {
                score = doc.getNextContent();
            }
            if (score == null || !StringTools.isNumberOnly(score)) {
                score = doc.getNextContentAfterRegex("(?i)Feedback score of");
            }
            if (score != null && StringTools.isNumberOnly(score)) {
                feedback.put("feedback", score);
                score = doc.getNextContent();
                if (score != null) {
                    score = doc.getNextContent();
                }
                if (score != null && score.matches("[0-9]+(\\.[0-9])?%")) {
                    newPercent = score;
                }
            }
            if (score == null && (result = doc.findSequence("Seller:", ".*", "\\d+")) != null) {
                score = (String)result.get(2);
                feedback.put("feedback", score);
            }
        }
        if (newPercent == null && (percentMatched = doc.realGrep("(?i)([0-9]+(\\.[0-9])?%)(.|&#160;)positive.feedback")) != null) {
            newPercent = percentMatched.group(1);
        }
        if (newPercent == null) {
            newPercent = doc.getContentBeforeContent("&#160;Positive feedback");
        }
        if (newPercent != null && newPercent.matches("[0-9]+(\\.[0-9])?%")) {
            feedback.put("percentage", newPercent);
        } else {
            String percentage = doc.getNextContentAfterContent(this.T.s("ebayServer.feedback"));
            if (percentage != null) {
                feedback.put("percentage", percentage);
            } else {
                feedback.put("percentage", "100");
            }
        }
        return feedback;
    }

    public Record parseShippingInsurance(JHTML doc) {
        Record shipping = new Record();
        String shipString = doc.getNextContentAfterRegexIgnoring(this.T.s("ebayServer.shipping"), "(?i)approximately");
        Matcher amount = null;
        boolean amountFound = false;
        if (shipString != null && !(amountFound = (amount = this.amountPat.matcher(shipString)).find())) {
            shipString = doc.getNextContent();
            amount = this.amountPat.matcher(shipString);
            if (shipString != null) {
                amountFound = amount.find();
            }
        }
        if (shipString != null && amountFound) {
            shipString = amount.group();
        }
        String shipStringCheck = doc.getPrevContent(2);
        String insureString = doc.getNextContentAfterRegex(this.T.s("ebayServer.shippingInsurance"));
        String insuranceOptionalCheck = doc.getNextContent();
        shipping.put("optional_insurance", Boolean.toString(insuranceOptionalCheck == null || !insuranceOptionalCheck.toLowerCase().contains(this.T.s("ebayServer.requiredInsurance"))));
        insureString = DeprecatedEbayAuction.sanitizeOptionalPrices(insureString);
        shipString = shipStringCheck != null && !shipStringCheck.equals(this.T.s("ebayServer.paymentInstructions")) ? DeprecatedEbayAuction.sanitizeOptionalPrices(shipString) : null;
        if (shipString != null) {
            if (shipString.equalsIgnoreCase("free")) {
                shipping.put("shipping", "0.0");
            } else {
                try {
                    shipping.put("shipping", shipString);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        }
        try {
            shipping.put("insurance", Currency.getCurrency(insureString).toString());
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return shipping;
    }

    private static String sanitizeOptionalPrices(String insureString) {
        if (insureString != null) {
            insureString = insureString.equals("-") || insureString.equals("--") ? null : insureString.trim();
        }
        return insureString;
    }

    public String parseSeller(JHTML doc) {
        String sellerName = null;
        JHTML.SequenceResult sellerInfo = doc.findSequence("(?i)top.rated.seller", ".*", ".*", "\\d+");
        if (sellerInfo != null) {
            sellerName = (String)sellerInfo.get(2);
        } else {
            sellerInfo = doc.findSequence(this.T.s("ebayServer.sellerInfoPrequel"), this.T.s("ebayServer.seller"), ".*");
            if (sellerInfo != null) {
                sellerName = (String)sellerInfo.get(2);
            } else {
                sellerInfo = doc.findSequence(this.T.s("ebayServer.sellerInfoPrequel"), ".*", "\\d+");
                if (sellerInfo != null) {
                    sellerName = (String)sellerInfo.get(1);
                }
            }
        }
        if (sellerName == null) {
            sellerName = doc.getNextContentAfterRegex(this.T.s("ebayServer.seller"));
        }
        if (sellerName == null && (sellerInfo = doc.findSequence("Seller:", ".*", "\\d+")) != null) {
            sellerName = (String)sellerInfo.get(1);
        }
        if (sellerName == null) {
            sellerName = doc.getNextContentAfterRegex(this.T.s("ebayServer.sellerInfoPrequel"));
        }
        if (sellerName == null && doc.grep(this.T.s("ebayServer.sellerAwayRegex")) == null) {
            sellerName = "";
        }
        return sellerName;
    }

    public Record parsePrices(JHTML doc) {
        String maxBid;
        String firstBid;
        String foundBid;
        Record record = new Record();
        record.put("minimum", "false");
        JHTML.SequenceResult curBidSequence = doc.findSequence(this.T.s("ebayServer.currentBid"), "(USD|GBP|JPY|CHF|FRF|EUR|CAD|AUD|NTD|TWD|HKD|MYR|SGD|INR|US)", "^(\\s?\\$)?[0-9]+([,.0-9]*)$");
        if (curBidSequence != null) {
            String currency = (String)curBidSequence.get(1);
            String value = (String)curBidSequence.get(2);
            foundBid = currency.trim() + " " + value.trim();
        } else {
            foundBid = doc.getNextContentAfterRegex(this.T.s("ebayServer.currentBid"));
        }
        if (foundBid != null && foundBid.length() != 0) {
            record.put("current", foundBid);
            record.put("current_us", DeprecatedEbayAuction.getUSCurrency(Currency.getCurrency(foundBid), doc).toString());
        }
        if ((firstBid = doc.getNextContentAfterContent(this.T.s("ebayServer.firstBid"))) != null) {
            record.put("current", firstBid);
            record.put("minimum", "true");
        }
        if ((maxBid = doc.getNextContentAfterContent(this.T.s("ebayServer.yourMaxBid"))) != null && maxBid.length() != 0) {
            record.put("max", maxBid);
        }
        return record;
    }

    private static Currency getUSCurrency(Currency val, JHTML htmlDoc) {
        Currency newCur = zeroDollars;
        if (val != null && !val.isNull()) {
            newCur = val.getCurrencyType() == 1 ? val : DeprecatedEbayAuction.walkForUSCurrency(htmlDoc);
        }
        return newCur;
    }

    private static Currency walkForUSCurrency(JHTML html) {
        Currency newCur = zeroDollars;
        int count = 0;
        String usdPattern = Externalized.getString("ebayServer.USD");
        do {
            String approxAmount = html.getNextContent();
            approxAmount = StringTools.stripHigh(approxAmount, "");
            int matchAtIndex = (approxAmount = approxAmount.replaceAll("\\s+", " ")).indexOf(usdPattern);
            if (matchAtIndex == -1 || (newCur = Currency.getCurrency(approxAmount = approxAmount.substring(matchAtIndex))).getCurrencyType() == 1) continue;
            newCur = zeroDollars;
        } while (count++ < 6 && newCur == zeroDollars);
        return newCur;
    }

    public void setPage(StringBuffer sb) {
        String skimOver = sb.toString();
        Matcher startCommentSearch = Pattern.compile(Externalized.getString("ebayServer.startedRegex")).matcher(skimOver);
        this.mStartComment = startCommentSearch.find() ? startCommentSearch.group(1) : "";
        Matcher bidCountSearch = Pattern.compile(this.T.s("ebayServer.bidCountRegex")).matcher(skimOver);
        this.mBidCountScript = bidCountSearch.find() ? bidCountSearch.group(1) : "";
    }

    private Pair<String, Boolean> getRawBidCount(JHTML doc) {
        Boolean fixed = null;
        String[][] SEQUENCES = new String[][]{{this.T.s("ebayServer.currentBid"), ".*", ".*", ".*", "[0-9]+", "bids?"}, {this.T.s("ebayServer.currentBid"), ".*", ".*", "[0-9]+", "bids?"}, {this.T.s("ebayServer.currentBid"), ".*", "[0-9]+", "bids?"}, {this.T.s("ebayServer.currentBid"), ".*", "[0-9]+ bids?"}, {"[0-9]+", "bids?"}};
        int[] SEQUENCE_GROUPS = new int[]{4, 3, 2, 2, 0};
        String rawBidCount = null;
        for (int i = 0; i < SEQUENCES.length; ++i) {
            JHTML.SequenceResult bidSequence = doc.findSequence(SEQUENCES[i]);
            if (bidSequence == null) continue;
            int index = SEQUENCE_GROUPS[i];
            rawBidCount = (String)bidSequence.get(index);
            if (i != 3) continue;
            rawBidCount = rawBidCount.substring(0, rawBidCount.indexOf(32));
        }
        if (rawBidCount == null) {
            rawBidCount = doc.getNextContentAfterRegex(this.T.s("ebayServer.bidCount"));
        }
        if (rawBidCount == null) {
            rawBidCount = doc.getContentBeforeContent("See history");
            if (rawBidCount != null && rawBidCount.matches("^(Purchased|Bid).*")) {
                if (rawBidCount.matches("^Purchased.*")) {
                    fixed = true;
                }
                rawBidCount = doc.getPrevContent();
            }
            if (rawBidCount != null && !StringTools.isNumberOnly(rawBidCount)) {
                rawBidCount = null;
            }
        }
        return new Pair<String, Object>(rawBidCount, fixed);
    }

    int getDigits(String digitsStarting) {
        String rawCount;
        Matcher m = this.digits.matcher(digitsStarting);
        if (m.find() && (rawCount = m.group()) != null) {
            return Integer.parseInt(rawCount);
        }
        return -1;
    }

    public Record getBidCount(JHTML doc, int quantity) {
        Record result = new Record();
        Pair<String, Boolean> rawBidCountResult = this.getRawBidCount(doc);
        String rawBidCount = rawBidCountResult.getFirst();
        if (rawBidCountResult.getLast() != null) {
            result.put("fixed", rawBidCountResult.getLast().toString());
        }
        int bidCount = 0;
        if (rawBidCount != null) {
            if (rawBidCount.equals(this.T.s("ebayServer.purchasesBidCount")) || rawBidCount.matches(this.T.s("ebayServer.offerRecognition"))) {
                result.put("fixed", "true");
                bidCount = -1;
            } else if (rawBidCount.matches(this.T.s("ebayServer.bidderListCount"))) {
                bidCount = Integer.parseInt(this.mBidCountScript);
                this.mBidCountScript = null;
            } else {
                bidCount = this.getDigits(rawBidCount);
            }
        }
        if (rawBidCount == null || bidCount == -1) {
            result.put("high_bidder", this.T.s("ebayServer.fixedPrice"));
            result.put("fixed", "true");
            if (doc.lookup(this.T.s("ebayServer.hasBeenPurchased"), false) != null || doc.lookup(this.T.s("ebayServer.endedEarly"), false) != null) {
                bidCount = quantity;
                Date now = new Date();
                result.put("ended_at", "now");
                result.put("started_at", "now");
            } else {
                bidCount = 0;
            }
        }
        result.put("bid_count", Integer.toString(bidCount));
        return result;
    }

    private Date extractEndDate(Document doc) {
        ZoneDate endDate;
        String endTime = "";
        Elements parents = doc.select("span.endedDate").parents();
        if (parents.isEmpty() && (parents = doc.select(":matchesOwn((?i)ended:)").parents()).isEmpty()) {
            endTime = doc.select(":matchesOwn((?i)time.left:)").parents().first().select(":matchesOwn((^\\()|(\\)$))").text();
        }
        if (endTime.length() == 0) {
            if (parents.isEmpty()) {
                return null;
            }
            endTime = parents.first().text();
        }
        if ((endDate = StringTools.figureDate(endTime = endTime.replaceAll("([\\(\\s\\)])+", " ").trim(), this.T.s("ebayServer.itemDateFormat"), true, true)) != null && !endDate.isNull()) {
            return endDate.getDate();
        }
        return null;
    }

    private boolean checkSeller(JHTML doc, AuctionEntry ae) {
        String sellerName = null;
        String feedbackCount = null;
        JHTML.SequenceResult sellerInfo = doc.findSequence("(?i)top.rated.seller", ".*", ".*", "\\d+");
        if (sellerInfo != null) {
            sellerName = (String)sellerInfo.get(2);
            feedbackCount = (String)sellerInfo.get(3);
        } else {
            sellerInfo = doc.findSequence(this.T.s("ebayServer.sellerInfoPrequel"), this.T.s("ebayServer.seller"), ".*");
            if (sellerInfo != null) {
                sellerName = (String)sellerInfo.get(2);
            }
        }
        if (sellerName == null) {
            sellerName = doc.getNextContentAfterRegex(this.T.s("ebayServer.seller"));
        }
        if (sellerName == null) {
            sellerName = doc.getNextContentAfterRegex(this.T.s("ebayServer.sellerInfoPrequel"));
        }
        if (sellerName == null) {
            if (doc.grep(this.T.s("ebayServer.sellerAwayRegex")) != null) {
                if (ae != null) {
                    ae.setLastStatus("Seller away - item unavailable.");
                }
                return true;
            }
            sellerName = ae == null ? "(unknown)" : ae.getSellerName();
        }
        Record r = new Record();
        r.put("seller_name", sellerName);
        if (feedbackCount != null) {
            r.put("feedback_count", Integer.toString(Integer.parseInt(feedbackCount)));
        }
        return false;
    }
}

