/*
 * Decompiled with CFR 0.152.
 */
package com.jbidwatcher.ui;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.jbidwatcher.auction.AuctionEntry;
import com.jbidwatcher.auction.Category;
import com.jbidwatcher.auction.EntryCorral;
import com.jbidwatcher.ui.AuctionListHolder;
import com.jbidwatcher.ui.AuctionListHolderFactory;
import com.jbidwatcher.ui.AuctionsUIModel;
import com.jbidwatcher.ui.FilterInterface;
import com.jbidwatcher.ui.JTabManager;
import com.jbidwatcher.ui.ListManager;
import com.jbidwatcher.ui.table.auctionTableModel;
import com.jbidwatcher.util.StringTools;
import com.jbidwatcher.util.config.JConfig;
import com.jbidwatcher.util.queue.MQFactory;
import com.jbidwatcher.util.queue.MessageQueue;
import java.awt.Color;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.swing.event.TableModelEvent;

@Singleton
public class FilterManager
implements MessageQueue.Listener,
FilterInterface {
    private final ListManager mList;
    private final JTabManager tabs;
    private final EntryCorral corral;
    @Inject
    private AuctionListHolderFactory alhFactory;
    private Map<String, AuctionListHolder> mIdentifierToList;
    private AuctionListHolder mMainTab = null;
    private AuctionListHolder mDefaultCompleteTab = null;
    private AuctionListHolder mDefaultSellingTab = null;

    @Inject
    protected FilterManager(ListManager listManager, JTabManager tabManager, EntryCorral entryCorral) {
        this.mList = listManager;
        this.tabs = tabManager;
        this.corral = entryCorral;
        this.mIdentifierToList = new HashMap<String, AuctionListHolder>();
        MQFactory.getConcrete("redraw").registerListener(this);
        MQFactory.getConcrete("delete").registerListener(new MessageQueue.Listener(){

            @Override
            public void messageAction(Object deQ) {
                AuctionEntry ae = (AuctionEntry)FilterManager.this.corral.takeForRead(deQ.toString());
                FilterManager.this.deleteAuction(ae);
                ae = (AuctionEntry)FilterManager.this.corral.takeForWrite(deQ.toString());
                FilterManager.this.corral.erase(ae.getIdentifier());
            }
        });
        this.tabs.setFilterManager(this);
    }

    public void loadFilters() {
        String tabName;
        this.mMainTab = this.mList.add(this.alhFactory.create("current", false, false));
        this.mDefaultCompleteTab = this.mList.add(this.alhFactory.create("complete", true, false));
        this.mDefaultSellingTab = this.mList.add(this.alhFactory.create("selling", false, false));
        int i = 0;
        do {
            if ((tabName = JConfig.queryDisplayProperty("tabs.name." + i++)) == null || this.mList.findCategory(tabName) != null) continue;
            this.mList.add(this.alhFactory.create(tabName, false, true));
        } while (i < 3 || tabName != null);
    }

    AuctionListHolder addTab(String newTab) {
        Color mainBackground = this.mMainTab.getUI().getBackground();
        Properties dispProps = JConfig.multiMatchDisplay(newTab + ".");
        if (dispProps.isEmpty()) {
            this.mMainTab.getUI().getColumnWidthsToProperties(dispProps, newTab);
            JConfig.addAllToDisplay(dispProps);
        }
        AuctionListHolder newList = this.alhFactory.create(newTab, false, true);
        newList.setBackground(mainBackground);
        this.mList.add(newList);
        Category.findOrCreateByName(newTab);
        return newList;
    }

    @Override
    public void messageAction(Object deQ) {
        AuctionEntry ae;
        String cmd = deQ.toString();
        if (StringTools.isNumberOnly(cmd) && (ae = (AuctionEntry)this.corral.takeForRead(cmd)) != null) {
            AuctionListHolder old = this.mIdentifierToList.get(ae.getIdentifier());
            AuctionListHolder newAuction = this.refilterAuction(ae);
            if (newAuction != null) {
                MQFactory.getConcrete("Swing").enqueue("Moved to " + newAuction.getList().getName() + " " + ae.getTitleAndComment());
                if (old != null) {
                    old.getUI().redrawAll();
                }
                newAuction.getUI().redrawAll();
            } else {
                auctionTableModel model = (auctionTableModel)this.tabs.getCurrentTable().getModel();
                int row = model.findRow(ae);
                if (row != -1) {
                    row = this.tabs.getCurrentTable().convertRowIndexToView(row);
                    this.tabs.getCurrentTable().tableChanged(new TableModelEvent(model, row));
                }
            }
            return;
        }
        if (cmd.startsWith("#") && cmd.length() == 7) {
            this.mList.setBackground(Color.decode(cmd));
        } else if (cmd.startsWith("#font")) {
            this.mList.adjustHeights();
        } else {
            AuctionListHolder toSort = this.mList.findCategory(cmd);
            if (toSort != null) {
                toSort.getUI().sort();
            }
        }
    }

    @Override
    public void deleteAuction(AuctionEntry ae) {
        AuctionEntry deleteEntry = (AuctionEntry)this.corral.takeForRead(ae.getIdentifier());
        AuctionListHolder which = this.mIdentifierToList.get(deleteEntry.getIdentifier());
        if (which != null) {
            which.getUI().delEntry(ae);
        }
        this.mIdentifierToList.remove(ae.getIdentifier());
    }

    @Override
    public void addAuction(AuctionEntry ae) {
        AuctionEntry newEntry = (AuctionEntry)this.corral.takeForRead(ae.getIdentifier());
        AuctionListHolder which = this.mIdentifierToList.get(newEntry.getIdentifier());
        if (which != null) {
            if (which.getList().allowAddEntry(newEntry)) {
                which.getUI().addEntry(newEntry);
            }
        } else {
            AuctionListHolder sendTo = this.matchAuction(newEntry);
            if (sendTo != null && sendTo.getList().allowAddEntry(newEntry)) {
                sendTo.getUI().addEntry(newEntry);
                this.mIdentifierToList.put(newEntry.getIdentifier(), sendTo);
            }
        }
    }

    private AuctionListHolder matchAuction(AuctionEntry ae) {
        String category;
        AuctionListHolder rval;
        if (!ae.isSticky() || ae.getCategory() == null) {
            if (ae.isSeller()) {
                return this.mDefaultSellingTab;
            }
            if (ae.isComplete()) {
                return this.mDefaultCompleteTab;
            }
        }
        if ((rval = this.mList.findCategory(category = ae.getCategory())) != null) {
            return rval;
        }
        if (category != null && !category.startsWith("New Search")) {
            return this.addTab(category);
        }
        return this.mMainTab;
    }

    private AuctionListHolder refilterAuction(AuctionEntry ae) {
        AuctionListHolder sendTo = this.matchAuction(ae);
        AuctionListHolder old = this.mIdentifierToList.get(ae.getIdentifier());
        if (old == null && ae.getCategory() != null && (old = this.mList.findCategory(ae.getCategory())) != null) {
            this.mIdentifierToList.put(ae.getIdentifier(), old);
        }
        if (old != null) {
            String tabName = old.getList().getName();
            if (sendTo.getList().isCompleted()) {
                String destination = ae.isBidOn() || ae.isSniped() ? (ae.isHighBidder() ? JConfig.queryConfiguration(tabName + ".won_target") : JConfig.queryConfiguration(tabName + ".lost_target")) : JConfig.queryConfiguration(tabName + ".other_target");
                if (destination != null) {
                    if (destination.equals("<delete>")) {
                        this.deleteAuction(ae);
                        return null;
                    }
                    ae.setSticky(true);
                    sendTo = this.mList.findCategory(destination);
                    if (sendTo == null) {
                        sendTo = this.addTab(destination);
                    }
                }
            }
        }
        if (old == sendTo || old == null) {
            if (old == null) {
                JConfig.log().logMessage("For some reason oldAuctions is null, and nobody acknowledges owning it, for auction entry " + ae.getTitle());
            }
            return null;
        }
        AuctionsUIModel oldUI = old.getUI();
        AuctionsUIModel newUI = sendTo.getUI();
        if (oldUI != null) {
            oldUI.delEntry(ae);
        }
        if (newUI != null) {
            ae.setCategory(sendTo.getList().getName());
            newUI.addEntry(ae);
        }
        this.mIdentifierToList.put(ae.getIdentifier(), sendTo);
        return sendTo;
    }
}

