/*
 * Decompiled with CFR 0.152.
 */
package com.jbidwatcher.util;

import com.jbidwatcher.util.config.JConfig;
import java.beans.DefaultPersistenceDelegate;
import java.beans.PersistenceDelegate;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class Currency
implements Comparable {
    public static final String VALUE_REGEX = "^(\\s?\\$)?[0-9]+([,.0-9]*)$";
    public static final String NAME_REGEX = "(USD|GBP|JPY|CHF|FRF|EUR|CAD|AUD|NTD|TWD|HKD|MYR|SGD|INR|US)";
    private static NumberFormat df = NumberFormat.getNumberInstance(Locale.US);
    public static final int NONE = 0;
    public static final int US_DOLLAR = 1;
    public static final int UK_POUND = 2;
    public static final int JP_YEN = 3;
    public static final int GER_MARK = 4;
    public static final int FR_FRANC = 5;
    public static final int CAN_DOLLAR = 6;
    public static final int EURO = 7;
    public static final int AU_DOLLAR = 8;
    public static final int CH_FRANC = 9;
    public static final int NT_DOLLAR = 10;
    public static final int TW_DOLLAR = 10;
    public static final int HK_DOLLAR = 11;
    public static final int MY_REAL = 12;
    public static final int SG_DOLLAR = 13;
    public static final int IND_RUPEE = 14;
    private static Currency _noValue = null;
    protected int mCurrencyType;
    protected double mValue;
    private static final char pound = '\u00a3';
    private static final Character objPound = Character.valueOf('\u00a3');
    private static Map<Integer, Double> sCurrencyMap = new HashMap<Integer, Double>();
    private static final Integer CurDollar = 1;
    private static final Integer CurPound = 2;
    private static final Integer CurYen = 3;
    private static final Integer CurMark = 4;
    private static final Integer CurFranc = 5;
    private static final Integer CurSwiss = 9;
    private static final Integer CurCan = 6;
    private static final Integer CurEuro = 7;
    private static final Integer CurAu = 8;
    private static final Integer CurTaiwan = 10;
    private static final Integer CurHK = 11;
    private static final Integer CurMyr = 12;
    private static final Integer CurSGD = 13;
    private static final Integer CurRupee = 14;
    private static final Object[][] xlateTable = new Object[][]{{"USD", CurDollar}, {"US $", CurDollar}, {"AU $", CurAu}, {"au$", CurAu}, {"AU", CurAu}, {"AUD", CurAu}, {"US", CurDollar}, {"USD $", CurDollar}, {"$", CurDollar}, {"C", CurCan}, {"C $", CurCan}, {"CAD", CurCan}, {"c$", CurCan}, {"GBP", CurPound}, {objPound.toString(), CurPound}, {"pound", CurPound}, {"\u00a3", CurPound}, {"&pound", CurPound}, {"Y", CurYen}, {"JPY", CurYen}, {"&yen", CurYen}, {"\u00a5", CurYen}, {"DM", CurMark}, {"FRF", CurFranc}, {"fr", CurFranc}, {"CHF", CurSwiss}, {"chf", CurSwiss}, {"dm", CurMark}, {"\u20ac", CurEuro}, {"eur", CurEuro}, {"EUR", CurEuro}, {"Eur", CurEuro}, {"NT$", CurTaiwan}, {"nt$", CurTaiwan}, {"NTD", CurTaiwan}, {"HK$", CurHK}, {"hk$", CurHK}, {"HKD", CurHK}, {"MYR", CurMyr}, {"myr", CurMyr}, {"SGD", CurSGD}, {"sgd", CurSGD}, {"INR", CurRupee}, {"inr", CurRupee}};

    public static Currency NoValue() {
        if (_noValue == null) {
            _noValue = new Currency(0, 0.0);
        }
        return _noValue;
    }

    public static Currency convertToUSD(Currency usd, Currency nonusd, Currency cvt) {
        if (cvt != null && !cvt.isNull() && cvt.getCurrencyType() != 1) {
            double multiple;
            if (usd == null || usd.isNull() || usd.getValue() == 0.0 || nonusd == null || nonusd.isNull() || nonusd.getValue() == 0.0) {
                multiple = sCurrencyMap.containsKey(cvt.getCurrencyType()) ? sCurrencyMap.get(cvt.getCurrencyType()) : 1.0;
            } else {
                multiple = usd.getValue() / nonusd.getValue();
                if (multiple != 0.0) {
                    sCurrencyMap.put(nonusd.getCurrencyType(), multiple);
                }
            }
            return Currency.getCurrency(1, multiple * cvt.getValue());
        }
        return cvt;
    }

    private int xlateSymbolToType(String symbol) {
        for (Object[] aXlateTable : xlateTable) {
            if (!symbol.equals(aXlateTable[0])) continue;
            return (Integer)aXlateTable[1];
        }
        return 0;
    }

    private boolean isDigit(char ch) {
        return ch >= '0' && ch <= '9';
    }

    public static boolean isCurrency(String test) {
        return !Currency.getCurrency(test).isNull();
    }

    @NotNull
    public static Currency getCurrency(String wholeValue) {
        if (wholeValue == null || wholeValue.length() == 0 || wholeValue.startsWith("UNK")) {
            return Currency.NoValue();
        }
        return new Currency(wholeValue);
    }

    public static Currency getCurrency(int whatType, double startValue) {
        if (whatType == 0) {
            return Currency.NoValue();
        }
        return new Currency(whatType, startValue);
    }

    public static Currency getCurrency(String symbol, double startValue) {
        if (symbol == null || symbol.equalsIgnoreCase("UNK")) {
            return Currency.NoValue();
        }
        return new Currency(symbol, startValue);
    }

    public static Currency getCurrency(String symbol, String startValue) {
        if (symbol == null || symbol.equalsIgnoreCase("UNK")) {
            return Currency.NoValue();
        }
        return new Currency(symbol, startValue);
    }

    public Currency(String wholeValue) {
        this.setValues(wholeValue);
    }

    public Currency(int whatType, double startValue) {
        this.setValues(whatType, startValue);
    }

    public Currency(String symbol, double startValue) {
        this.setValues(symbol, startValue);
    }

    public Currency(String symbol, String startValue) {
        this.setValues(symbol, Double.parseDouble(Currency.cleanCommas(startValue)));
    }

    private static String cleanCommas(String startValue) {
        int decimalPos = startValue.length() - 3;
        if (decimalPos > 0) {
            if (startValue.charAt(decimalPos) == '.') {
                startValue = startValue.replaceAll(",", "");
            } else if (startValue.charAt(decimalPos) == ',') {
                startValue = startValue.replaceAll("\\.", "").replaceAll(",", ".");
            }
        }
        return startValue;
    }

    private int checkLengthMatchStart(String value, String currencyName) {
        String curNam;
        String lowVal = value.toLowerCase();
        if (lowVal.startsWith((curNam = currencyName.toLowerCase()) + " ")) {
            return currencyName.length() + 1;
        }
        if (lowVal.startsWith(curNam)) {
            int len;
            for (len = currencyName.length(); len < value.length() && !Character.isDigit(value.charAt(len)); ++len) {
            }
            return len;
        }
        return 0;
    }

    private void setValues(String wholeValue) {
        if (wholeValue == null || wholeValue.equals("null")) {
            this.setValues(0, 0.0);
        } else {
            String valuePortion;
            String parseCurrency;
            char firstChar = wholeValue.charAt(0);
            int eurLen = this.checkLengthMatchStart(wholeValue, "EUR");
            int gbpLen = this.checkLengthMatchStart(wholeValue, "GBP");
            int frfLen = this.checkLengthMatchStart(wholeValue, "FRF");
            int chfLen = this.checkLengthMatchStart(wholeValue, "CHF");
            int cdnLen = this.checkLengthMatchStart(wholeValue, "CAD");
            int ntdLen = this.checkLengthMatchStart(wholeValue, "NTD");
            int audLen = this.checkLengthMatchStart(wholeValue, "AUD");
            int usdLen = this.checkLengthMatchStart(wholeValue, "USD");
            if (wholeValue.startsWith("US $")) {
                parseCurrency = "US $";
                valuePortion = wholeValue.substring(4);
            } else if (wholeValue.startsWith("USD $")) {
                parseCurrency = "USD $";
                valuePortion = wholeValue.substring(5);
            } else if (wholeValue.startsWith("AU $")) {
                parseCurrency = "AU $";
                valuePortion = wholeValue.substring(4);
            } else if (usdLen != 0) {
                parseCurrency = "USD";
                valuePortion = wholeValue.substring(usdLen);
            } else if (eurLen != 0) {
                parseCurrency = "EUR";
                valuePortion = wholeValue.substring(eurLen);
            } else if (gbpLen != 0) {
                parseCurrency = "GBP";
                valuePortion = wholeValue.substring(gbpLen);
            } else if (frfLen != 0) {
                parseCurrency = "FRF";
                valuePortion = wholeValue.substring(frfLen);
            } else if (chfLen != 0) {
                parseCurrency = "CHF";
                valuePortion = wholeValue.substring(chfLen);
            } else if (cdnLen != 0) {
                parseCurrency = "CAD";
                valuePortion = wholeValue.substring(cdnLen);
            } else if (ntdLen != 0) {
                parseCurrency = "NTD";
                valuePortion = wholeValue.substring(ntdLen);
            } else if (audLen != 0) {
                parseCurrency = "AUD";
                valuePortion = wholeValue.substring(audLen);
            } else if (wholeValue.startsWith("NT$")) {
                parseCurrency = "NTD";
                valuePortion = wholeValue.substring(3);
            } else if (wholeValue.startsWith("SGD")) {
                parseCurrency = "SGD";
                valuePortion = wholeValue.substring(3);
            } else if (wholeValue.startsWith("sgd")) {
                parseCurrency = "SGD";
                valuePortion = wholeValue.substring(3);
            } else if (wholeValue.startsWith("INR")) {
                parseCurrency = "INR";
                valuePortion = wholeValue.substring(3);
            } else if (wholeValue.startsWith("inr")) {
                parseCurrency = "INR";
                valuePortion = wholeValue.substring(3);
            } else if (wholeValue.startsWith("nt$")) {
                parseCurrency = "NTD";
                valuePortion = wholeValue.substring(3);
            } else if (wholeValue.startsWith("au$")) {
                parseCurrency = "AUD";
                valuePortion = wholeValue.substring(3);
            } else if (wholeValue.startsWith("C $")) {
                parseCurrency = "C $";
                valuePortion = wholeValue.substring(3);
            } else if (wholeValue.charAt(0) == '\u00a3') {
                parseCurrency = "GBP";
                valuePortion = wholeValue.substring(1);
            } else if (!this.isDigit(firstChar) && firstChar != '$') {
                int semiIndex = wholeValue.indexOf(";");
                if (semiIndex == -1) {
                    semiIndex = wholeValue.indexOf(" ");
                }
                if (semiIndex != -1) {
                    parseCurrency = wholeValue.substring(0, semiIndex);
                    valuePortion = wholeValue.substring(parseCurrency.length() + 1);
                } else {
                    parseCurrency = "$";
                    valuePortion = wholeValue;
                }
            } else {
                parseCurrency = "$";
                valuePortion = this.isDigit(firstChar) ? wholeValue : wholeValue.substring(1);
            }
            while (valuePortion.length() != 0 && !Character.isDigit(valuePortion.charAt(0))) {
                valuePortion = valuePortion.substring(1);
            }
            if (valuePortion.length() != 0) {
                double actualValue;
                try {
                    String cvt = Currency.cleanCommas(valuePortion);
                    actualValue = df.parse(cvt).doubleValue();
                }
                catch (ParseException e) {
                    JConfig.log().handleException("currency parse!", e);
                    actualValue = 0.0;
                }
                this.setValues(parseCurrency, actualValue);
            } else {
                this.setValues(null);
            }
        }
    }

    private void setValues(String symbol, double startValue) {
        this.setValues(this.xlateSymbolToType(symbol), startValue);
    }

    private void setValues(int whatType, double startValue) {
        this.mCurrencyType = whatType;
        this.mValue = startValue;
        df.setMinimumFractionDigits(2);
        df.setMaximumFractionDigits(2);
    }

    public String fullCurrencyName() {
        switch (this.mCurrencyType) {
            case 1: {
                return "USD";
            }
            case 8: {
                return "AUD";
            }
            case 10: {
                return "NTD";
            }
            case 11: {
                return "HKD";
            }
            case 12: {
                return "MYR";
            }
            case 13: {
                return "SGD";
            }
            case 14: {
                return "INR";
            }
            case 2: {
                return "GBP";
            }
            case 3: {
                return "JPY";
            }
            case 4: {
                return "DM";
            }
            case 5: {
                return "FRF";
            }
            case 9: {
                return "CHF";
            }
            case 6: {
                return "CAD";
            }
            case 7: {
                return "EUR";
            }
        }
        return "UNK";
    }

    public double getValue() {
        return this.mValue;
    }

    public String fullCurrency() {
        return this.fullCurrencyName() + " " + this.getValueString();
    }

    public Currency add(Currency addValue) throws CurrencyTypeException {
        if (addValue == null) {
            throw new CurrencyTypeException("Cannot add null Currency.");
        }
        if (addValue.getCurrencyType() == this.mCurrencyType) {
            return new Currency(this.mCurrencyType, this.mValue + addValue.getValue());
        }
        if (this.mCurrencyType == 0) {
            return new Currency(addValue.getCurrencyType(), this.mValue + addValue.getValue());
        }
        if (addValue.getCurrencyType() == 0) {
            return new Currency(this.mCurrencyType, this.mValue + addValue.getValue());
        }
        throw new CurrencyTypeException("Cannot add " + this.fullCurrencyName() + " to " + addValue.fullCurrencyName() + ".");
    }

    public Currency subtract(Currency subValue) throws CurrencyTypeException {
        if (subValue == null) {
            throw new CurrencyTypeException("Cannot subtract null Currency.");
        }
        if (subValue.getCurrencyType() == this.mCurrencyType) {
            return new Currency(this.mCurrencyType, this.mValue - subValue.getValue());
        }
        if (this.mCurrencyType == 0) {
            return new Currency(subValue.getCurrencyType(), this.mValue - subValue.getValue());
        }
        if (subValue.getCurrencyType() == 0) {
            return new Currency(this.mCurrencyType, this.mValue - subValue.getValue());
        }
        throw new CurrencyTypeException("Cannot subtract " + this.fullCurrencyName() + " from " + subValue.fullCurrencyName() + ".");
    }

    public int getCurrencyType() {
        return this.mCurrencyType;
    }

    public String getCurrencySymbol() {
        switch (this.mCurrencyType) {
            case 1: {
                return "$";
            }
            case 10: {
                return "nt$";
            }
            case 11: {
                return "hk$";
            }
            case 12: {
                return "myr";
            }
            case 13: {
                return "sgd";
            }
            case 14: {
                return "Rs.";
            }
            case 2: {
                return objPound.toString();
            }
            case 3: {
                return "\u00a5";
            }
            case 5: {
                return "fr";
            }
            case 9: {
                return "chf";
            }
            case 4: {
                return "dm";
            }
            case 6: {
                return "c$";
            }
            case 8: {
                return "au$";
            }
            case 7: {
                return "\u20ac";
            }
        }
        return "unk";
    }

    public String toString() {
        if (this.isNull()) {
            return "null";
        }
        String cvtToString = this.getCurrencySymbol();
        cvtToString = cvtToString + df.format(this.mValue);
        return cvtToString;
    }

    public String getValueString() {
        if (this.isNull()) {
            return "null";
        }
        return df.format(this.mValue);
    }

    public int hashCode() {
        if (this.isNull()) {
            return 0;
        }
        String tmp = this.fullCurrencyName() + this.getValueString();
        return tmp.hashCode();
    }

    public boolean equals(Object inValue) {
        if (inValue == null) {
            return false;
        }
        if (inValue == this) {
            return true;
        }
        if (!(inValue instanceof Currency)) {
            return false;
        }
        Currency otherValue = (Currency)inValue;
        boolean sameCurrency = otherValue.getCurrencyType() == this.mCurrencyType;
        boolean sameValue = (int)(otherValue.getValue() * 1000.0) == (int)(this.mValue * 1000.0);
        return sameCurrency && sameValue;
    }

    public boolean less(Currency otherValue) throws CurrencyTypeException {
        boolean sameCurrency;
        if (otherValue == null) {
            return false;
        }
        if (otherValue == this) {
            return false;
        }
        boolean bl = sameCurrency = otherValue.getCurrencyType() == this.mCurrencyType;
        if (!sameCurrency) {
            throw new CurrencyTypeException("Cannot compare different currencies.");
        }
        boolean lowerValue = Double.compare((int)(otherValue.getValue() * 1000.0), (int)(this.mValue * 1000.0)) == 1;
        return lowerValue;
    }

    public boolean isNull() {
        return this.mValue == 0.0 && this.mCurrencyType == 0;
    }

    public int compareTo(Object o) {
        if (o == null) {
            return 1;
        }
        if (o == this) {
            return 0;
        }
        if (!(o instanceof Currency)) {
            throw new ClassCastException("Currency cannot compareTo different classes!");
        }
        Currency otherValue = (Currency)o;
        if (otherValue.isNull()) {
            return 1;
        }
        if (this.isNull()) {
            return -1;
        }
        try {
            if (this.less(otherValue)) {
                return -1;
            }
        }
        catch (ClassCastException e) {
            throw new ClassCastException("Currency cannot compareTo different classes!\n" + e);
        }
        catch (CurrencyTypeException e) {
            throw new ClassCastException("Currency cannot compareTo different currencies!\n" + e);
        }
        if (this.equals(otherValue)) {
            return 0;
        }
        return 1;
    }

    public static PersistenceDelegate getDelegate() {
        return new DefaultPersistenceDelegate(new String[]{"mCurrencyType", "mValue"});
    }

    public static class CurrencyTypeException
    extends Exception {
        String _associatedString;

        public CurrencyTypeException(String inString) {
            this._associatedString = inString;
        }

        @Override
        public String toString() {
            return this._associatedString;
        }
    }
}

