/*
 * Decompiled with CFR 0.152.
 */
package com.jbidwatcher.util.xml;

import com.jbidwatcher.util.xml.XMLInterface;
import com.jbidwatcher.util.xml.XMLParseException;
import com.jbidwatcher.util.xml.XMLSerialize;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class XMLElement
implements XMLSerialize,
XMLInterface {
    public static final int NANOXML_MAJOR_VERSION = 1;
    public static final int NANOXML_MINOR_VERSION = 7;
    private static boolean mRejectBadHTML = false;
    protected HashMap<String, String> _attributes;
    protected List<XMLInterface> mChildren;
    protected String _tagName;
    protected boolean _empty;
    protected String _contents;
    protected static HashMap<String, String> _conversionTable = new HashMap(10);
    protected boolean _skipLeadingWhitespace;
    protected int _lineNr;
    private static final int INITIAL_BLOCKSIZE = 20480;
    static Map<Character, String> sEncodeMap;

    public static void rejectBadHTML(boolean rejectBadHtml) {
        mRejectBadHTML = rejectBadHtml;
    }

    public static boolean rejectingBadHTML() {
        return mRejectBadHTML;
    }

    public XMLElement() {
        this(false);
    }

    public XMLElement(boolean skipLeadingWhitespace) {
        this._skipLeadingWhitespace = skipLeadingWhitespace;
        this._tagName = null;
        this._contents = null;
        this._attributes = new HashMap(10);
        this.mChildren = new ArrayList<XMLInterface>(10);
        this._lineNr = 0;
    }

    public XMLElement(String elementName) {
        this(false);
        this._tagName = elementName;
    }

    public int countChildren() {
        return this.mChildren.size();
    }

    public Iterator<String> getAttributes() {
        return this._attributes.keySet().iterator();
    }

    @Override
    public Iterator<XMLInterface> getChildren() {
        return this.mChildren.iterator();
    }

    public XMLElement getChild(String tagName) {
        Iterator<XMLInterface> step = this.getChildren();
        while (step.hasNext()) {
            XMLElement child = (XMLElement)step.next();
            if (!child.getTagName().equals(tagName)) continue;
            return child;
        }
        return null;
    }

    @Override
    public String getContents() {
        return this._contents;
    }

    public int getLineNr() {
        return this._lineNr;
    }

    @Override
    public String getProperty(String key) {
        return this._attributes.get(key.toLowerCase());
    }

    @Override
    public String getProperty(String key, String defaultValue) {
        String result = this._attributes.get(key.toLowerCase());
        if (result == null) {
            result = defaultValue;
        }
        return result;
    }

    @Override
    public void setProperty(String key, String newValue) {
        String lowerKey = key.toLowerCase();
        this._attributes.put(lowerKey, newValue);
    }

    @Override
    public String getTagName() {
        return this._tagName;
    }

    public void setEmpty() {
        this._empty = true;
    }

    public void setNonEmpty() {
        this._empty = false;
    }

    public void setTagName(String newName) {
        this._tagName = newName;
    }

    public void setContents(String newContents) {
        if (this.mChildren.size() != 0) {
            throw new XMLParseException(this._tagName, this._lineNr, "Cannot add contents to an XML element that already has children.");
        }
        this._contents = newContents;
    }

    public void addChild(XMLInterface newChild) {
        if (this._contents != null) {
            throw new XMLParseException(this._tagName, this._lineNr, "Cannot add children to an XML element that already has contents.");
        }
        this.mChildren.add(newChild);
    }

    private StringBuffer allAttribs(StringBuffer attrList) {
        Iterator<String> attrStep = this.getAttributes();
        while (attrStep.hasNext()) {
            String attrName = attrStep.next();
            attrList.append(' ');
            attrList.append(attrName);
            attrList.append("=\"");
            String prop = this.getProperty(attrName);
            if (prop != null) {
                attrList.append(XMLElement.encodeString(prop));
            }
            attrList.append('\"');
        }
        return attrList;
    }

    public String toString() {
        return this.toStringBuffer().toString();
    }

    @Override
    public String toString(int depth) {
        return this.toStringBuffer(new StringBuffer(), depth).toString();
    }

    @Override
    public StringBuffer toStringBuffer() {
        return this.toStringBuffer(new StringBuffer(), 0);
    }

    public StringBuffer toStringBuffer(StringBuffer wholeXML) {
        return this.toStringBuffer(wholeXML, 0);
    }

    @Override
    public StringBuffer toStringBuffer(StringBuffer wholeXML, int depth) {
        XMLElement.prependSpaces(wholeXML, depth);
        wholeXML.append('<').append(this._tagName);
        this.allAttribs(wholeXML);
        if (this._empty) {
            wholeXML.append("/>");
        } else {
            wholeXML.append('>');
            if (this._contents == null) {
                Iterator<XMLInterface> xmlStep = this.getChildren();
                wholeXML.append('\n');
                while (xmlStep.hasNext()) {
                    xmlStep.next().toStringBuffer(wholeXML, depth + 1);
                }
                XMLElement.prependSpaces(wholeXML, depth);
            } else {
                wholeXML.append(XMLElement.encodeString(this._contents));
            }
            wholeXML.append("</").append(this._tagName).append('>');
        }
        wholeXML.append('\n');
        return wholeXML;
    }

    private static void prependSpaces(StringBuffer wholeXML, int depth) {
        for (int i = 0; i < depth; ++i) {
            wholeXML.append("  ");
        }
    }

    protected static boolean isIdentifierChar(char ch) {
        return ch >= 'A' && ch <= 'Z' || ch >= 'a' && ch <= 'z' || ch >= '0' && ch <= '9' || "?.-_:".indexOf(ch) >= 0;
    }

    public void parseFromReader(Reader reader) throws IOException, XMLParseException {
        this.parseFromReader(reader, 1);
    }

    public void parseFromReader(Reader reader, int startingLineNr) throws IOException, XMLParseException {
        int blockSize = 20480;
        char[] input = null;
        int size = 0;
        while (reader.ready()) {
            if (input == null) {
                input = new char[blockSize];
            } else {
                char[] oldInput = input;
                input = new char[input.length * 3];
                blockSize = oldInput.length * 2;
                System.arraycopy(oldInput, 0, input, 0, oldInput.length);
            }
            int charsRead = reader.read(input, size, blockSize);
            if (charsRead < 0) break;
            size += charsRead;
        }
        this.parseCharArray(input, 0, size, startingLineNr);
    }

    public void parseString(String string) throws XMLParseException {
        this.parseCharArray(string.toCharArray(), 0, string.length(), 1);
    }

    public int parseString(String string, int offset) throws XMLParseException {
        return this.parseCharArray(string.toCharArray(), offset, string.length(), 1);
    }

    public int parseString(String string, int offset, int end) throws XMLParseException {
        return this.parseCharArray(string.toCharArray(), offset, end, 1);
    }

    public int parseString(String string, int offset, int end, int startingLineNr) throws XMLParseException {
        return this.parseCharArray(string.toCharArray(), offset, end, startingLineNr);
    }

    public int parseCharArray(char[] input, int offset, int end) throws XMLParseException {
        return this.parseCharArray(input, offset, end, 1);
    }

    public int parseCharArray(char[] input, int offset, int end, int startingLineNr) throws XMLParseException {
        int[] lineNr = new int[]{startingLineNr};
        return this.parseCharArray(input, offset, end, lineNr);
    }

    protected int parseCharArray(char[] input, int startLoc, int end, int[] currentLineNr) throws XMLParseException {
        int offset = startLoc;
        offset = this.skipWhitespace(input, offset, end, currentLineNr);
        offset = this.skipPreamble(input, offset, end, currentLineNr);
        offset = this.scanTagName(input, offset, end, currentLineNr);
        this._lineNr = currentLineNr[0];
        offset = this.scanAttributes(input, offset, end, currentLineNr);
        int[] contentOffset = new int[1];
        int[] contentSize = new int[1];
        int contentLineNr = currentLineNr[0];
        offset = this.scanContent(input, offset, end, contentOffset, contentSize, currentLineNr);
        if (contentSize[0] > 0) {
            this.scanChildren(input, contentOffset[0], contentSize[0], contentLineNr);
            if (this.mChildren.size() > 0) {
                this._contents = null;
            } else {
                this.processContents(input, contentOffset[0], contentSize[0], contentLineNr);
            }
        }
        return offset;
    }

    protected void processContents(char[] input, int contentOffset, int contentSize, int contentLineNr) throws XMLParseException {
        int[] lineNr = new int[]{contentLineNr};
        if (!this._skipLeadingWhitespace) {
            String str = new String(input, contentOffset, contentSize);
            this.handleCData(str);
            return;
        }
        StringBuffer result = new StringBuffer(contentSize);
        int end = contentSize + contentOffset;
        for (int i = contentOffset; i < end; ++i) {
            char ch = input[i];
            while (ch == '\r' || ch == '\n') {
                lineNr[0] = lineNr[0] + 1;
                result.append(ch);
                ch = input[++i];
                if (ch != '\n') {
                    result.append(ch);
                }
                while ((ch = input[++i]) == ' ' || ch == '\t') {
                }
            }
            if (i >= end) continue;
            result.append(ch);
        }
        this.handleCData(result.toString());
    }

    private void handleCData(String content) {
        this._contents = content.startsWith("<![CDATA[") ? content.substring(9, content.length() - 3) : XMLElement.decodeString(content);
    }

    protected int scanAttributes(char[] input, int startLoc, int end, int[] lineNr) throws XMLParseException {
        int offset = startLoc;
        boolean done = false;
        while (!done) {
            offset = this.skipWhitespace(input, offset, end, lineNr);
            char ch = input[offset];
            if (offset + 1 < end && ch == '/' && input[offset + 1] == '>' || ch == '>') {
                done = true;
                continue;
            }
            offset = this.scanOneAttribute(input, offset, end, lineNr);
        }
        return offset;
    }

    protected void scanChildren(char[] input, int contentOffset, int contentSize, int contentLineNr) throws XMLParseException {
        int end = contentOffset + contentSize;
        int offset = contentOffset;
        int[] lineNr = new int[]{contentLineNr};
        if (contentSize > 11 && input[offset + 0] == '<' && input[offset + 1] == '!' && input[offset + 2] == '[' && input[offset + 3] == 'C' && input[offset + 4] == 'D' && input[offset + 5] == 'A' && input[offset + 6] == 'T' && input[offset + 7] == 'A' && input[offset + 8] == '[' && input[offset + contentSize - 3] == ']' && input[offset + contentSize - 2] == ']' && input[offset + contentSize - 1] == '>') {
            return;
        }
        while (offset < end) {
            try {
                offset = this.skipWhitespace(input, offset, end, lineNr);
            }
            catch (XMLParseException e) {
                return;
            }
            if (input[offset] != '<') {
                return;
            }
            XMLElement child = new XMLElement(this._skipLeadingWhitespace);
            offset = child.parseCharArray(input, offset, end, lineNr);
            this.mChildren.add(child);
        }
    }

    protected int scanContent(char[] input, int startLoc, int expectedEnd, int[] contentOffset, int[] contentSize, int[] lineNr) throws XMLParseException {
        int offset = startLoc;
        int end = expectedEnd;
        char ch = input[offset];
        if (ch == '/') {
            this._empty = true;
            contentSize[0] = 0;
            if (input[offset + 1] != '>') {
                throw this.expectedInput("'>'", lineNr[0]);
            }
            return offset + 2;
        }
        if (ch != '>') {
            throw this.expectedInput("'>'", lineNr[0]);
        }
        if (this._skipLeadingWhitespace) {
            offset = this.skipWhitespace(input, offset + 1, end, lineNr);
        }
        contentOffset[0] = ++offset;
        char[] tag = this._tagName.toCharArray();
        end -= tag.length + 2;
        int level = 0;
        while (offset < end && level >= 0) {
            ch = input[offset];
            if (ch == '<') {
                int i;
                boolean ok = true;
                for (i = 0; ok && i < tag.length; ok &= input[offset + (i + 1)] == tag[i], ++i) {
                }
                if (ok) {
                    int off2 = offset + tag.length + 1;
                    ch = input[offset = this.skipWhitespace(input, off2, end, lineNr)];
                    if (ch != '>' && (off2 == offset || ch == '/')) continue;
                    ++level;
                    continue;
                }
                if (input[offset + 1] == '/') {
                    ok = true;
                    for (i = 0; ok && i < tag.length; ok &= input[offset + (i + 2)] == tag[i], ++i) {
                    }
                    if (ok) {
                        contentSize[0] = offset - contentOffset[0];
                        offset += tag.length + 2;
                        if (input[offset = this.skipWhitespace(input, offset, end, lineNr)] != '>') continue;
                        --level;
                        ++offset;
                        continue;
                    }
                    ++offset;
                    continue;
                }
            }
            if (ch == '\r') {
                lineNr[0] = lineNr[0] + 1;
                if (offset != end && input[offset + 1] == '\n') {
                    ++offset;
                }
            } else if (ch == '\n') {
                lineNr[0] = lineNr[0] + 1;
            }
            ++offset;
        }
        if (level >= 0) {
            throw this.unexpectedEndOfData(lineNr[0]);
        }
        if (this._skipLeadingWhitespace) {
            int i = contentOffset[0] + contentSize[0] - 1;
            while (contentSize[0] >= 0 && input[i] <= ' ') {
                --i;
                contentSize[0] = contentSize[0] - 1;
            }
        }
        return offset;
    }

    protected String scanIdentifier(char[] input, int offset, int end) {
        int begin = offset;
        while (offset < end && (XMLElement.isIdentifierChar(input[offset]) || input[offset] == '/' && input[offset + 1] != '>')) {
            ++offset;
        }
        return offset == begin ? null : new String(input, begin, offset - begin);
    }

    protected int scanOneAttribute(char[] input, int startLoc, int end, int[] lineNr) throws XMLParseException {
        int offset = startLoc;
        String key = this.scanIdentifier(input, offset, end);
        if (key == null) {
            throw this.syntaxError("an attribute key (" + new String(input) + ")", lineNr[0]);
        }
        offset = this.skipWhitespace(input, offset + key.length(), end, lineNr);
        key = key.toLowerCase();
        Scanner scanner = new Scanner(input, end, lineNr, offset, key).invoke();
        String value = scanner.getValue();
        offset = scanner.getOffset();
        if (!key.equals("/")) {
            this._attributes.put(key, XMLElement.decodeString(value));
        }
        return offset + value.length();
    }

    protected String scanString(char[] input, int startLoc, int end, int[] lineNr) throws XMLParseException {
        int offset = startLoc;
        char delim = input[offset];
        if (delim == '\"' || delim == '\'') {
            int begin = offset++;
            while (offset < end && input[offset] != delim) {
                offset += XMLElement.nextCharCountSkipEOL(input, offset, end, lineNr);
            }
            if (offset == end) {
                return null;
            }
            return new String(input, begin, offset - begin + 1);
        }
        return this.scanIdentifier(input, offset, end);
    }

    protected int scanTagName(char[] input, int offset, int end, int[] lineNr) throws XMLParseException {
        this._tagName = this.scanIdentifier(input, offset, end);
        if (this._tagName == null) {
            throw this.syntaxError("a tag name", lineNr[0]);
        }
        return offset + this._tagName.length();
    }

    protected int skipBogusTag(char[] input, int startLoc, int end, int[] lineNr) {
        if (this.isComment(input, startLoc)) {
            return this.skipComment(input, end, lineNr, startLoc);
        }
        return this.findTagEnd(input, end, lineNr, startLoc);
    }

    private int findTagEnd(char[] input, int end, int[] lineNr, int offset) {
        int level = 1;
        while (offset < end) {
            char ch = input[offset++];
            switch (ch) {
                case '\r': {
                    if (offset < end && input[offset] == '\n') {
                        ++offset;
                    }
                    lineNr[0] = lineNr[0] + 1;
                    break;
                }
                case '\n': {
                    lineNr[0] = lineNr[0] + 1;
                    break;
                }
                case '<': {
                    ++level;
                    break;
                }
                case '>': {
                    if (--level != 0) break;
                    return offset;
                }
            }
        }
        throw this.unexpectedEndOfData(lineNr[0]);
    }

    private boolean isComment(char[] input, int offset) {
        return input[offset + 1] == '-' && input[offset + 2] == '-';
    }

    private int skipComment(char[] input, int end, int[] lineNr, int offset) {
        while (offset < end && (input[offset] != '-' || input[offset + 1] != '-' || input[offset + 2] != '>')) {
            offset += XMLElement.nextCharCountSkipEOL(input, offset, end, lineNr);
        }
        if (offset == end) {
            throw this.unexpectedEndOfData(lineNr[0]);
        }
        return offset + 3;
    }

    protected int skipPreamble(char[] input, int startLoc, int end, int[] lineNr) throws XMLParseException {
        char ch;
        int offset = startLoc;
        do {
            if (input[offset = this.skipWhitespace(input, offset, end, lineNr)] != '<') {
                this.expectedInput("'<'", lineNr[0]);
            }
            if (++offset >= end) {
                throw this.unexpectedEndOfData(lineNr[0]);
            }
            ch = input[offset];
            if (ch != '!' && ch != '?') continue;
            offset = this.skipBogusTag(input, offset, end, lineNr);
        } while (ch == '?' || !XMLElement.isIdentifierChar(ch));
        return offset;
    }

    protected static int nextCharCountSkipEOL(char[] input, int offset, int end, int[] lineNr) {
        int initial_offset = offset;
        if (input[offset] == '\r') {
            lineNr[0] = lineNr[0] + 1;
            if (offset != end && input[offset + 1] == '\n') {
                ++offset;
            }
        } else if (input[offset] == '\n') {
            lineNr[0] = lineNr[0] + 1;
        }
        if (offset == initial_offset) {
            return 1;
        }
        return offset - initial_offset;
    }

    protected int skipWhitespace(char[] input, int startLoc, int end, int[] lineNr) {
        int offset;
        for (offset = startLoc; offset < end && input[offset] <= ' '; offset += XMLElement.nextCharCountSkipEOL(input, offset, end, lineNr)) {
        }
        if (offset == end) {
            throw this.unexpectedEndOfData(lineNr[0]);
        }
        return offset;
    }

    public static String encodeString(String s) {
        char[] raw = new char[s.length()];
        s.getChars(0, s.length(), raw, 0);
        int lastIndex = 0;
        String insertString = null;
        StringBuffer outBuffer = null;
        for (int i = 0; i < raw.length; ++i) {
            char ch = raw[i];
            insertString = null;
            if (ch == '#') {
                if (i == 0 || i > 0 && raw[i - 1] != '&') {
                    insertString = "&pound;";
                }
            } else {
                insertString = sEncodeMap.get(Character.valueOf(ch));
            }
            if (ch > '\u0080') {
                insertString = "&#" + ch + ";";
            }
            if (insertString == null) continue;
            if (outBuffer == null) {
                outBuffer = new StringBuffer();
            }
            outBuffer.append(s.substring(lastIndex, i));
            outBuffer.append(insertString);
            lastIndex = i + 1;
        }
        if (insertString == null && lastIndex != 0) {
            outBuffer.append(s.substring(lastIndex));
        }
        return lastIndex == 0 ? s : outBuffer.toString();
    }

    public static String decodeString(String s) {
        if (s == null) {
            return "";
        }
        StringBuffer result = new StringBuffer(s.length());
        int index = 0;
        while (true) {
            int index2 = (s + '&').indexOf(38, index);
            result.append(s.substring(index, index2));
            if (index2 == s.length()) break;
            index = s.indexOf(59, index2);
            int space = s.indexOf(32, index2);
            int amp = s.indexOf(38, index2 + 1);
            if (space == -1) {
                space = s.length();
            }
            if (amp == -1) {
                amp = s.length();
            }
            if (index < 0) {
                result.append(s.substring(index2));
                break;
            }
            if (index > space || index > amp) {
                result.append(s.substring(index2, Math.min(space, amp)));
                index = index2 + 1;
                continue;
            }
            String key = s.substring(index2 + 1, index);
            if (key.charAt(0) == '#') {
                if (key.charAt(1) == 'x') {
                    result.append((char)Integer.parseInt(key.substring(2), 16));
                } else {
                    result.append((char)Integer.parseInt(key.substring(1), 10));
                }
            } else {
                String cvt = _conversionTable.get(key);
                if (cvt == null) {
                    result.append('&').append(key).append(';');
                } else {
                    result.append(cvt);
                }
            }
            ++index;
        }
        return result.toString();
    }

    protected XMLParseException invalidValueSet(String key) {
        String msg = "Invalid value set (key = \"" + key + "\")";
        return new XMLParseException(this.getTagName(), msg);
    }

    protected XMLParseException invalidValue(String key, String value, int lineNr) {
        String msg = "Attribute \"" + key + "\" does not contain a valid " + "value (\"" + value + "\")";
        return new XMLParseException(this.getTagName(), lineNr, msg);
    }

    protected XMLParseException unexpectedEndOfData(int lineNr) {
        String msg = "Unexpected end of data reached";
        return new XMLParseException(this.getTagName(), lineNr, msg);
    }

    protected XMLParseException syntaxError(String context, int lineNr) {
        String msg = "Syntax error while parsing " + context;
        return new XMLParseException(this.getTagName(), lineNr, msg);
    }

    protected XMLParseException expectedInput(String charSet, int lineNr) {
        String msg = "Expected: " + charSet;
        return new XMLParseException(this.getTagName(), lineNr, msg);
    }

    protected XMLParseException valueMissingForAttribute(String key, int lineNr) {
        String msg = "Value missing for attribute with key \"" + key + '\"';
        return new XMLParseException(this.getTagName(), lineNr, msg);
    }

    @Override
    public XMLElement toXML() {
        return this;
    }

    @Override
    public void fromXML(XMLInterface inXMLIFace) {
        XMLElement inXML = (XMLElement)inXMLIFace;
        this._attributes = inXML._attributes;
        this.mChildren = inXML.mChildren;
        this._tagName = inXML._tagName;
        this._empty = inXML._empty;
        this._contents = inXML._contents;
    }

    public void reset() {
        this._tagName = null;
        this._contents = null;
        this._attributes.clear();
        this.mChildren.clear();
        this._lineNr = 0;
    }

    static {
        _conversionTable.put("lt", "<");
        _conversionTable.put("gt", ">");
        _conversionTable.put("quot", "\"");
        _conversionTable.put("apos", "'");
        _conversionTable.put("amp", "&");
        _conversionTable.put("pound", "#");
        sEncodeMap = new HashMap<Character, String>(4);
        sEncodeMap.put(Character.valueOf('<'), "&lt;");
        sEncodeMap.put(Character.valueOf('>'), "&gt;");
        sEncodeMap.put(Character.valueOf('\"'), "&quot;");
        sEncodeMap.put(Character.valueOf('&'), "&amp;");
    }

    private class Scanner {
        private char[] mInput;
        private int mEnd;
        private int[] mLineNr;
        private int mOffset;
        private String mKey;
        private String mValue;

        public Scanner(char[] input, int end, int[] lineNr, int offset, String key) {
            this.mInput = input;
            this.mEnd = end;
            this.mLineNr = lineNr;
            this.mOffset = offset;
            this.mKey = key;
        }

        public int getOffset() {
            return this.mOffset;
        }

        public String getValue() {
            return this.mValue;
        }

        public Scanner invoke() {
            if (this.mInput[this.mOffset] == '=') {
                this.mOffset = XMLElement.this.skipWhitespace(this.mInput, this.mOffset + 1, this.mEnd, this.mLineNr);
                this.mValue = XMLElement.this.scanString(this.mInput, this.mOffset, this.mEnd, this.mLineNr);
                if (this.mValue == null) {
                    throw XMLElement.this.syntaxError("an attribute value (" + new String(this.mInput) + ")", this.mLineNr[0]);
                }
                if (this.mInput[this.mOffset + this.mValue.length()] == '=') {
                    Scanner scanner = new Scanner(this.mInput, this.mEnd, this.mLineNr, this.mOffset + this.mValue.length(), this.mKey).invoke();
                    this.mValue = this.mValue + "=" + scanner.getValue();
                }
                if (this.mValue.charAt(0) == '\"') {
                    this.mValue = this.mValue.substring(1, this.mValue.length() - 1);
                    this.mOffset += 2;
                }
            } else {
                this.mValue = "";
                if (!this.mKey.equals("disabled") && !this.mKey.equals("checked") && !this.mKey.equals("/") && mRejectBadHTML) {
                    throw XMLElement.this.valueMissingForAttribute(this.mKey, this.mLineNr[0]);
                }
            }
            return this;
        }
    }
}

