/*
 * Decompiled with CFR 0.152.
 */
package com.orbus.mahalo.dns;

import com.orbus.mahalo.dns.DNSEntry;
import com.orbus.mahalo.dns.DNSRecord;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DNSCache {
    private Map<String, List<DNSRecord>> _Cache;

    public DNSCache(int aiSize) {
        this._Cache = new HashMap<String, List<DNSRecord>>(aiSize);
    }

    public synchronized void clear() {
        this._Cache.clear();
    }

    public synchronized DNSRecord handleRecord(DNSRecord aRecord) {
        long now = System.currentTimeMillis();
        DNSRecord cacheRecord = this.get(aRecord);
        boolean bisExpired = aRecord.isExpired(now);
        if (cacheRecord != null) {
            if (bisExpired) {
                this.remove(aRecord);
            } else {
                cacheRecord.resetTTL(aRecord);
            }
        } else if (!bisExpired) {
            this.add(aRecord);
        }
        return cacheRecord;
    }

    public synchronized void reap() {
        long now = System.currentTimeMillis();
        LinkedList<String> mapRemovalList = new LinkedList<String>();
        for (List<DNSRecord> list : this._Cache.values()) {
            LinkedList<DNSRecord> removalList = new LinkedList<DNSRecord>();
            String key = list.get(0).getName();
            for (DNSRecord rec : list) {
                if (!rec.isExpired(now)) continue;
                removalList.add(rec);
            }
            for (DNSRecord rec : removalList) {
                list.remove(rec);
            }
            if (list.size() != 0) continue;
            mapRemovalList.add(key);
        }
        for (String key : mapRemovalList) {
            this._Cache.remove(key);
        }
    }

    public synchronized void add(DNSRecord aRecord) {
        List<DNSRecord> list = this._Cache.get(aRecord.getName());
        if (list == null) {
            list = new LinkedList<DNSRecord>();
            list.add(aRecord);
            this._Cache.put(aRecord.getName(), list);
        } else {
            boolean baddRecord = true;
            for (DNSRecord rec : list) {
                if (!rec.equals(aRecord)) continue;
                baddRecord = false;
                break;
            }
            if (baddRecord) {
                list.add(aRecord);
            }
        }
    }

    public synchronized boolean remove(DNSRecord aRecord) {
        List<DNSRecord> list = this._Cache.get(aRecord.getName());
        if (list != null) {
            for (DNSRecord rec : list) {
                if (!rec.equals(aRecord)) continue;
                list.remove(rec);
                if (list.size() == 0) {
                    this._Cache.remove(aRecord.getName());
                }
                return true;
            }
        }
        return false;
    }

    public synchronized DNSRecord get(DNSRecord aRecord) {
        List<DNSRecord> list = this._Cache.get(aRecord.getName());
        if (list != null) {
            for (DNSRecord rec : list) {
                if (!rec.equals(aRecord)) continue;
                return rec;
            }
        }
        return null;
    }

    public synchronized List<DNSRecord> get(String asName, DNSEntry.EntryType aeType, DNSEntry.EntryClass aeClass) {
        LinkedList<DNSRecord> retList = null;
        List<DNSRecord> list = this._Cache.get(asName);
        if (list != null) {
            for (DNSRecord rec : list) {
                if (rec.getType() != aeType || rec.getDNSClass() != aeClass) continue;
                if (retList == null) {
                    retList = new LinkedList<DNSRecord>();
                }
                retList.add(rec);
            }
        }
        return retList;
    }

    public synchronized DNSRecord.Service getAssociatedService(DNSRecord.Pointer aPtrRecord) {
        DNSRecord.Service retService = null;
        List<DNSRecord> list = this.get(aPtrRecord.getAlias(), DNSEntry.EntryType.SRV, DNSEntry.EntryClass.IN);
        if (list != null) {
            assert (list.size() == 1);
            retService = (DNSRecord.Service)list.get(0);
        }
        return retService;
    }

    public synchronized DNSRecord.Address getAssociatedAddress(DNSRecord.Service aSrvRecord) {
        DNSRecord.Address retAddress = null;
        List<DNSRecord> list = this.get(aSrvRecord.getServer(), DNSEntry.EntryType.A, DNSEntry.EntryClass.IN);
        if (list != null) {
            assert (list.size() == 1);
            retAddress = (DNSRecord.Address)list.get(0);
        }
        return retAddress;
    }

    public synchronized DNSRecord.Text getAssociatedText(DNSRecord.Service aSrvRecord) {
        DNSRecord.Text retText = null;
        List<DNSRecord> list = this.get(aSrvRecord.getName(), DNSEntry.EntryType.TXT, DNSEntry.EntryClass.IN);
        if (list != null) {
            retText = (DNSRecord.Text)list.get(0);
        }
        return retText;
    }
}

