/*
 * Decompiled with CFR 0.152.
 */
package com.orbus.mahalo.tasks;

import com.orbus.mahalo.HostInfo;
import com.orbus.mahalo.MahaloSocket;
import com.orbus.mahalo.ServiceInfo;
import com.orbus.mahalo.dns.DNSEntry;
import com.orbus.mahalo.dns.DNSPacket;
import com.orbus.mahalo.dns.DNSQuestion;
import com.orbus.mahalo.dns.DNSRecord;
import java.net.InetAddress;
import java.util.Map;
import java.util.Random;
import java.util.TimerTask;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Responder
extends TimerTask {
    private static final int INTERVAL_MIN = 20;
    private static final int INTERVAL_MAX = 115;
    private static final Random s_Random = new Random();
    MahaloSocket _Socket;
    HostInfo _LocalInfo;
    Map<String, ServiceInfo> _LocalServices;
    DNSPacket _InPacket;
    InetAddress _Address;
    int _iPort;

    public Responder(MahaloSocket aSocket, HostInfo aLocalInfo, Map<String, ServiceInfo> aLocalServices, DNSPacket aInPacket, InetAddress aAddress, int aiPort) {
        this._Socket = aSocket;
        this._LocalServices = aLocalServices;
        this._LocalInfo = aLocalInfo;
        this._InPacket = aInPacket;
        this._Address = aAddress;
        this._iPort = aiPort;
    }

    @Override
    public void run() {
        DNSPacket outPacket = this._InPacket.createResponce(true);
        boolean bRecievedUnicast = this._iPort != 5353;
        Boolean bsendUnicast = null;
        for (DNSQuestion question : this._InPacket.getQuestions()) {
            DNSRecord.Address answer;
            ServiceInfo info;
            if (bsendUnicast == null) {
                bsendUnicast = question.wantsUnicastResponce();
            } else if (bsendUnicast.booleanValue() != question.wantsUnicastResponce()) {
                System.err.println("Query from " + this._Address + " is inconsistent.  Sending response unicast.");
            }
            bsendUnicast = bsendUnicast | question.wantsUnicastResponce();
            String squery = question.getName().toLowerCase();
            DNSEntry.EntryType questionType = question.getType();
            if (questionType == DNSEntry.EntryType.PTR) {
                for (ServiceInfo info2 : this._LocalServices.values()) {
                    if (!info2.getType().endsWith(squery) || !info2.getState().isAnnounced()) continue;
                    outPacket.addAnswer(new DNSRecord.Pointer(info2.getType(), DNSEntry.EntryType.PTR, DNSEntry.EntryClass.IN, 3600, info2.getQualifiedName()));
                }
                continue;
            }
            if (!this._LocalServices.containsKey(squery) || !(info = this._LocalServices.get(squery)).getState().isAnnounced()) continue;
            if ((questionType == DNSEntry.EntryType.A || questionType == DNSEntry.EntryType.ANY) && (answer = this._LocalInfo.getDNSAddressRecord(DNSEntry.EntryType.A)) != null) {
                outPacket.addAnswer(answer);
            }
            if (questionType == DNSEntry.EntryType.SRV || questionType == DNSEntry.EntryType.ANY) {
                outPacket.addAnswer(new DNSRecord.Service(info.getQualifiedName(), DNSEntry.EntryClass.IN, true, 3600, info.getPriority(), info.getWeight(), info.getPort(), this._LocalInfo.getName()));
            }
            if (questionType == DNSEntry.EntryType.TXT || questionType == DNSEntry.EntryType.ANY) {
                outPacket.addAnswer(new DNSRecord.Text(info.getQualifiedName(), DNSEntry.EntryClass.IN, true, 3600, info.getTextBytes()));
            }
            if (questionType != DNSEntry.EntryType.SRV || (answer = this._LocalInfo.getDNSAddressRecord(DNSEntry.EntryType.A)) == null) continue;
            outPacket.addAnswer(answer);
        }
        for (DNSRecord knownAnswer : this._InPacket.getAnswers()) {
            if (knownAnswer.getTTL() <= 1800) continue;
            outPacket.getAnswers().remove(knownAnswer);
        }
        if (outPacket.getAnswers().size() != 0) {
            if ((bRecievedUnicast || bsendUnicast.booleanValue()) && this._Address != null) {
                outPacket.getQuestions().clear();
                this._Socket.send(outPacket, this._Address, this._iPort);
            } else {
                this._Socket.send(outPacket);
            }
        }
    }

    public static int GetDelay(boolean abDelay, int aiElapsed) {
        if (!abDelay) {
            return 0;
        }
        int iret = 20 + s_Random.nextInt(96) - aiElapsed;
        return iret > 0 ? iret : 0;
    }
}

