/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.tessboxeditor;

import java.awt.Cursor;
import java.awt.Font;
import java.awt.HeadlessException;
import java.awt.dnd.DropTarget;
import java.awt.event.ActionEvent;
import java.awt.font.TextAttribute;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.text.BadLocationException;
import net.sourceforge.tessboxeditor.FileDropTargetListener;
import net.sourceforge.tessboxeditor.GuiWithTools;
import net.sourceforge.tessboxeditor.TiffBoxGenerator;
import net.sourceforge.vietpad.components.FontDialog;
import net.sourceforge.vietpad.components.SimpleFilter;

public class GuiWithGenerator
extends GuiWithTools {
    private File inputTextFile;
    private String trainDirectory;
    private Font fontGen;
    private final Map<TextAttribute, Object> attributes = new HashMap<TextAttribute, Object>();
    private JFileChooser jFileChooserInputText;
    private JFileChooser jFileChooserOutputDir;
    private static final Logger logger = Logger.getLogger(GuiWithGenerator.class.getName());

    public GuiWithGenerator() {
        this.initComponents();
        new DropTarget(this.jTextAreaInput, new FileDropTargetListener(this, this.jTextAreaInput));
    }

    private void initComponents() {
        this.fontGen = new Font(prefs.get("trainfontName", this.jTextAreaInput.getFont().getName()), prefs.getInt("trainfontStyle", 0), prefs.getInt("trainfontSize", 36));
        this.attributes.put(TextAttribute.TRACKING, this.jSpinnerTracking.getValue());
        this.fontGen = this.fontGen.deriveFont(this.attributes);
        this.jTextAreaInput.setFont(this.fontGen);
        this.jButtonFont.setText(this.fontDesc(this.fontGen));
        this.jTextFieldFileName.setText(this.createFileName(this.fontGen) + ".exp0.tif");
        this.trainDirectory = prefs.get("trainDirectory", System.getProperty("user.home"));
        this.jTextFieldOuputDir.setText(this.trainDirectory);
        this.jFileChooserInputText = new JFileChooser();
        SimpleFilter simpleFilter = new SimpleFilter("txt", "Text Files");
        this.jFileChooserInputText.addChoosableFileFilter(simpleFilter);
        this.jFileChooserInputText.setAcceptAllFileFilterUsed(false);
        this.jFileChooserInputText.setCurrentDirectory(new File(this.trainDirectory));
        this.jFileChooserOutputDir = new JFileChooser();
        this.jFileChooserOutputDir.setApproveButtonText("Set");
        this.jFileChooserOutputDir.setDialogTitle("Set Output Directory");
        this.jFileChooserOutputDir.setAcceptAllFileFilterUsed(false);
        this.jFileChooserOutputDir.setCurrentDirectory(new File(this.trainDirectory));
        this.jFileChooserOutputDir.setFileSelectionMode(1);
    }

    @Override
    void jButtonInputActionPerformed(ActionEvent actionEvent) {
        if (this.jFileChooserInputText.showOpenDialog(this) == 0) {
            this.getGlassPane().setCursor(Cursor.getPredefinedCursor(3));
            this.getGlassPane().setVisible(true);
            try {
                this.inputTextFile = this.jFileChooserInputText.getSelectedFile();
                this.openTextFile(this.inputTextFile);
            }
            catch (Exception exception) {
                try {
                    logger.log(Level.WARNING, exception.getMessage(), exception);
                }
                catch (Throwable throwable) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            GuiWithGenerator.this.getGlassPane().setCursor(Cursor.getPredefinedCursor(0));
                            GuiWithGenerator.this.getGlassPane().setVisible(false);
                        }
                    });
                    throw throwable;
                }
                SwingUtilities.invokeLater(new /* invalid duplicate definition of identical inner class */);
            }
            SwingUtilities.invokeLater(new /* invalid duplicate definition of identical inner class */);
        }
    }

    void openTextFile(File file) {
        if (!file.getName().toLowerCase().endsWith(".txt")) {
            return;
        }
        try {
            try (Object object = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), "UTF8"));){
                this.jTextAreaInput.read((Reader)object, null);
            }
            object = this.jTextAreaInput.getDocument();
            if (object.getText(0, 1).equals("\ufeff")) {
                object.remove(0, 1);
            }
        }
        catch (IOException | BadLocationException exception) {
            logger.log(Level.WARNING, exception.getMessage(), exception);
        }
    }

    @Override
    void jButtonBrowseOutputDirActionPerformed(ActionEvent actionEvent) {
        if (this.jFileChooserOutputDir.showOpenDialog(this) == 0) {
            this.trainDirectory = this.jFileChooserOutputDir.getSelectedFile().getPath();
            this.jTextFieldOuputDir.setText(this.trainDirectory);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void jButtonFontActionPerformed(ActionEvent actionEvent) {
        FontDialog fontDialog = new FontDialog(this);
        fontDialog.setAttributes(this.fontGen);
        fontDialog.setVisible(true);
        if (fontDialog.succeeded()) {
            block5: {
                this.getGlassPane().setCursor(Cursor.getPredefinedCursor(3));
                this.getGlassPane().setVisible(true);
                try {
                    this.fontGen = fontDialog.getFont().deriveFont(this.attributes);
                    this.jTextAreaInput.setFont(this.fontGen);
                    this.jTextAreaInput.validate();
                    this.jButtonFont.setText(this.fontDesc(this.fontGen));
                    String string = this.jTextFieldFileName.getText();
                    String string2 = string.substring(string.lastIndexOf(".exp"));
                    String string3 = this.createFileName(this.fontGen) + string2;
                    this.jTextFieldFileName.setText(string3);
                    if (string3.length() <= string.length()) break block5;
                    this.pack();
                }
                catch (Exception exception) {
                    try {
                        logger.log(Level.WARNING, exception.getMessage(), exception);
                    }
                    catch (Throwable throwable) {
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                GuiWithGenerator.this.getGlassPane().setCursor(Cursor.getPredefinedCursor(0));
                                GuiWithGenerator.this.getGlassPane().setVisible(false);
                            }
                        });
                        throw throwable;
                    }
                    SwingUtilities.invokeLater(new /* invalid duplicate definition of identical inner class */);
                }
            }
            SwingUtilities.invokeLater(new /* invalid duplicate definition of identical inner class */);
        }
    }

    @Override
    void jSpinnerTrackingStateChanged(ChangeEvent changeEvent) {
        this.attributes.put(TextAttribute.TRACKING, this.jSpinnerTracking.getValue());
        this.jTextAreaInput.setFont(this.jTextAreaInput.getFont().deriveFont(this.attributes));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void jButtonGenerateActionPerformed(ActionEvent actionEvent) {
        if (this.jTextAreaInput.getText().trim().length() == 0) {
            JOptionPane.showMessageDialog(this, "Please load some text.");
            return;
        }
        TiffBoxGenerator tiffBoxGenerator = new TiffBoxGenerator(this.jTextAreaInput.getText(), this.jTextAreaInput.getFont(), (Integer)this.jSpinnerW1.getValue(), (Integer)this.jSpinnerH1.getValue());
        tiffBoxGenerator.setOutputFolder(new File(this.trainDirectory));
        String string = this.jTextFieldPrefix.getText();
        if (string.trim().length() > 0) {
            string = string + ".";
        }
        tiffBoxGenerator.setFileName(string + this.jTextFieldFileName.getText());
        tiffBoxGenerator.setTracking(((Float)this.jSpinnerTracking.getValue()).floatValue());
        tiffBoxGenerator.setNoiseAmount((Integer)this.jSpinnerNoise.getValue());
        tiffBoxGenerator.setAntiAliasing(this.jCheckBoxAntiAliasing.isSelected());
        this.jButtonGenerate.setEnabled(false);
        this.getGlassPane().setCursor(Cursor.getPredefinedCursor(3));
        this.getGlassPane().setVisible(true);
        try {
            tiffBoxGenerator.create();
            JOptionPane.showMessageDialog(this, String.format("TIFF/Box files have been generated and saved in %s folder.\nBe sure to check the entries in font_properties file for accuracy.", this.trainDirectory));
        }
        catch (OutOfMemoryError outOfMemoryError) {
            JOptionPane.showMessageDialog(this, "The input text was probably too large. Please reduce it to a more manageable amount.", "Out-Of-Memory Exception", 0);
        }
        catch (HeadlessException headlessException) {
            JOptionPane.showMessageDialog(this, headlessException.getMessage());
        }
        finally {
            this.jButtonGenerate.setEnabled(true);
            this.getGlassPane().setCursor(Cursor.getPredefinedCursor(0));
            this.getGlassPane().setVisible(false);
        }
    }

    @Override
    void jButtonClearActionPerformed(ActionEvent actionEvent) {
        this.jTextAreaInput.setText(null);
    }

    @Override
    void quit() {
        if (this.trainDirectory != null) {
            prefs.put("trainDirectory", this.trainDirectory);
        }
        prefs.put("trainLanguage", this.jTextFieldPrefix.getText());
        prefs.put("trainfontName", this.fontGen.getName());
        prefs.putInt("trainfontSize", this.fontGen.getSize());
        prefs.putInt("trainfontStyle", this.fontGen.getStyle());
        super.quit();
    }

    String fontDesc(Font font) {
        return font.getName() + (font.isBold() ? " Bold" : "") + (font.isItalic() ? " Italic" : "") + " " + font.getSize() + "pt";
    }

    String createFileName(Font font) {
        return font.getName().replace(" ", "").toLowerCase() + (font.isBold() ? "b" : "") + (font.isItalic() ? "i" : "");
    }
}

