/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.tessboxeditor;

import java.awt.Cursor;
import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.io.File;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.SwingWorker;
import javax.swing.filechooser.FileFilter;
import net.sourceforge.tess4j.util.ImageIOHelper;
import net.sourceforge.tessboxeditor.GuiWithLaF;
import net.sourceforge.vietocr.util.Utils;
import net.sourceforge.vietpad.components.SimpleFilter;

public class GuiWithTools
extends GuiWithLaF {
    File imageFolder = new File(prefs.get("ImageFolder", System.getProperty("user.home")));
    FileFilter selectedFilter;
    private static final Logger logger = Logger.getLogger(GuiWithTools.class.getName());

    @Override
    void jMenuItemMergeTiffActionPerformed(ActionEvent actionEvent) {
        JFileChooser jFileChooser = new JFileChooser();
        jFileChooser.setDialogTitle(this.bundle.getString("Select_Input_Images"));
        jFileChooser.setCurrentDirectory(this.imageFolder);
        jFileChooser.setMultiSelectionEnabled(true);
        SimpleFilter simpleFilter = new SimpleFilter("tif;tiff", "TIFF");
        SimpleFilter simpleFilter2 = new SimpleFilter("jpg;jpeg", "JPEG");
        SimpleFilter simpleFilter3 = new SimpleFilter("gif", "GIF");
        SimpleFilter simpleFilter4 = new SimpleFilter("png", "PNG");
        SimpleFilter simpleFilter5 = new SimpleFilter("bmp", "Bitmap");
        SimpleFilter simpleFilter6 = new SimpleFilter("tif;tiff;jpg;jpeg;gif;png;bmp", this.bundle.getString("All_Image_Files"));
        jFileChooser.addChoosableFileFilter(simpleFilter);
        jFileChooser.addChoosableFileFilter(simpleFilter2);
        jFileChooser.addChoosableFileFilter(simpleFilter3);
        jFileChooser.addChoosableFileFilter(simpleFilter4);
        jFileChooser.addChoosableFileFilter(simpleFilter5);
        jFileChooser.addChoosableFileFilter(simpleFilter6);
        if (this.selectedFilter != null) {
            jFileChooser.setFileFilter(this.selectedFilter);
        }
        jFileChooser.setAcceptAllFileFilterUsed(false);
        if (jFileChooser.showOpenDialog(this) == 0) {
            this.selectedFilter = jFileChooser.getFileFilter();
            final File[] fileArray = jFileChooser.getSelectedFiles();
            this.imageFolder = jFileChooser.getCurrentDirectory();
            jFileChooser = new JFileChooser();
            jFileChooser.setDialogTitle(this.bundle.getString("Save_Multi-page_TIFF_Image"));
            jFileChooser.setCurrentDirectory(this.imageFolder);
            jFileChooser.setFileFilter(simpleFilter);
            jFileChooser.setAcceptAllFileFilterUsed(false);
            if (jFileChooser.showSaveDialog(this) == 0) {
                File file;
                File file2 = jFileChooser.getSelectedFile();
                if (!file2.getName().endsWith(".tif") && !file2.getName().endsWith(".tiff")) {
                    file2 = new File(file2.getParent(), file2.getName() + ".tif");
                }
                if ((file = file2).exists()) {
                    file.delete();
                }
                this.jLabelStatus.setText(this.bundle.getString("MergeTIFF_running..."));
                this.getGlassPane().setCursor(Cursor.getPredefinedCursor(3));
                this.getGlassPane().setVisible(true);
                SwingWorker<File, Void> swingWorker = new SwingWorker<File, Void>(){

                    @Override
                    protected File doInBackground() throws Exception {
                        ImageIOHelper.mergeTiff(fileArray, file);
                        return file;
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    protected void done() {
                        GuiWithTools.this.jLabelStatus.setText(GuiWithTools.this.bundle.getString("MergeTIFFcompleted"));
                        try {
                            File file2 = (File)this.get();
                            JOptionPane.showMessageDialog(GuiWithTools.this, GuiWithTools.this.bundle.getString("MergeTIFFcompleted") + file2.getName() + GuiWithTools.this.bundle.getString("created"), "jTessBoxEditor", 1);
                        }
                        catch (InterruptedException interruptedException) {
                            logger.log(Level.WARNING, interruptedException.getMessage(), interruptedException);
                        }
                        catch (ExecutionException executionException) {
                            Throwable throwable = executionException.getCause();
                            String string = throwable != null ? (throwable instanceof OutOfMemoryError ? GuiWithTools.this.bundle.getString("OutOfMemoryError") : throwable.getMessage()) : executionException.getMessage();
                            logger.log(Level.SEVERE, executionException.getMessage(), executionException);
                            JOptionPane.showMessageDialog(GuiWithTools.this, string, "jTessBoxEditor", 0);
                        }
                        finally {
                            GuiWithTools.this.getGlassPane().setCursor(Cursor.getPredefinedCursor(0));
                            GuiWithTools.this.getGlassPane().setVisible(false);
                            GuiWithTools.this.jLabelStatus.setText(null);
                        }
                    }
                };
                swingWorker.execute();
            }
        }
    }

    @Override
    void jMenuItemSplitTiffActionPerformed(ActionEvent actionEvent) {
        JFileChooser jFileChooser = new JFileChooser();
        jFileChooser.setDialogTitle(this.bundle.getString("Select_Input_TIFF"));
        jFileChooser.setApproveButtonText("Split");
        jFileChooser.setCurrentDirectory(this.imageFolder);
        SimpleFilter simpleFilter = new SimpleFilter("tif;tiff", "TIFF");
        jFileChooser.addChoosableFileFilter(simpleFilter);
        if (this.selectedFilter != null) {
            jFileChooser.setFileFilter(this.selectedFilter);
        }
        jFileChooser.setAcceptAllFileFilterUsed(false);
        if (jFileChooser.showOpenDialog(this) == 0) {
            this.selectedFilter = jFileChooser.getFileFilter();
            final File file = jFileChooser.getSelectedFile();
            this.imageFolder = jFileChooser.getCurrentDirectory();
            this.jLabelStatus.setText(this.bundle.getString("SplitTIFF_running..."));
            this.jProgressBar1.setIndeterminate(true);
            this.jProgressBar1.setString(this.bundle.getString("SplitTIFF_running..."));
            this.jProgressBar1.setVisible(true);
            this.getGlassPane().setCursor(Cursor.getPredefinedCursor(3));
            this.getGlassPane().setVisible(true);
            SwingWorker<Void, Void> swingWorker = new SwingWorker<Void, Void>(){

                @Override
                protected Void doInBackground() throws Exception {
                    String string = Utils.stripExtension(file.getPath());
                    List<File> list = ImageIOHelper.createTiffFiles(file, -1, true);
                    for (int i = 0; i < list.size(); ++i) {
                        String string2 = String.format("%s-%03d.tif", string, i + 1);
                        File file2 = new File(string2);
                        file2.delete();
                        list.get(i).renameTo(file2);
                    }
                    return null;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                protected void done() {
                    GuiWithTools.this.jLabelStatus.setText(GuiWithTools.this.bundle.getString("SplitTIFFcompleted"));
                    GuiWithTools.this.jProgressBar1.setIndeterminate(false);
                    GuiWithTools.this.jProgressBar1.setString(GuiWithTools.this.bundle.getString("SplitTIFFcompleted"));
                    try {
                        this.get();
                        JOptionPane.showMessageDialog(GuiWithTools.this, GuiWithTools.this.bundle.getString("SplitTIFFcompleted"), "jTessBoxEditor", 1);
                    }
                    catch (InterruptedException interruptedException) {
                        logger.log(Level.WARNING, interruptedException.getMessage(), interruptedException);
                    }
                    catch (ExecutionException executionException) {
                        Throwable throwable = executionException.getCause();
                        String string = throwable != null ? (throwable instanceof OutOfMemoryError ? GuiWithTools.this.bundle.getString("OutOfMemoryError") : throwable.getMessage()) : executionException.getMessage();
                        logger.log(Level.SEVERE, executionException.getMessage(), executionException);
                        JOptionPane.showMessageDialog(GuiWithTools.this, string, "jTessBoxEditor", 0);
                    }
                    finally {
                        GuiWithTools.this.jProgressBar1.setVisible(false);
                        GuiWithTools.this.getGlassPane().setCursor(Cursor.getPredefinedCursor(0));
                        GuiWithTools.this.getGlassPane().setVisible(false);
                    }
                }
            };
            swingWorker.execute();
        }
    }

    @Override
    void quit() {
        prefs.put("ImageFolder", this.imageFolder.getPath());
        super.quit();
    }

    public static void main(String[] stringArray) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                new GuiWithTools().setVisible(true);
            }
        });
    }
}

