/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.tessboxeditor;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.sourceforge.tessboxeditor.StreamGobbler;
import net.sourceforge.tessboxeditor.TrainingMode;
import net.sourceforge.vietocr.util.Utils;
import net.sourceforge.vietpad.utilities.TextUtilities;

public class TessTrainer {
    private static final String cmdmake_box = "tesseract imageFile boxFile -l bootstrapLang batch.nochop makebox";
    private static final String cmdtess_train = "tesseract imageFile boxFile box.train";
    private static final String cmdunicharset_extractor = "unicharset_extractor";
    private static final String cmdshapeclustering = "shapeclustering -F %s.font_properties -U unicharset";
    private static final String cmdmftraining = "mftraining -F %1$s.font_properties -U unicharset -O %1$s.unicharset";
    private static final String cmdcntraining = "cntraining";
    private static final String cmdwordlist2dawg = "wordlist2dawg %2$s %1$s.frequent_words_list %1$s.freq-dawg %1$s.unicharset";
    private static final String cmdwordlist2dawg2 = "wordlist2dawg %2$s %1$s.words_list %1$s.word-dawg %1$s.unicharset";
    private static final String cmdcombine_tessdata = "combine_tessdata %s.";
    ProcessBuilder pb;
    String tessDir;
    String inputDataDir;
    String lang;
    String bootstrapLang;
    boolean rtl;
    private final PropertyChangeSupport pcs = new PropertyChangeSupport(this);
    private static final Logger logger = Logger.getLogger(TessTrainer.class.getName());

    public TessTrainer(String string, String string2, String string3, String string4, boolean bl) {
        this.pb = new ProcessBuilder(new String[0]);
        this.pb.directory(new File(string2));
        this.pb.redirectErrorStream(true);
        this.tessDir = string;
        this.inputDataDir = string2;
        this.lang = string3;
        this.bootstrapLang = string4;
        this.rtl = bl;
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.pcs.addPropertyChangeListener(propertyChangeListener);
    }

    public void generate(TrainingMode trainingMode) throws Exception {
        switch (trainingMode) {
            case Make_Box_File_Only: {
                this.makeBox();
                break;
            }
            case Train_with_Existing_Box: {
                this.generateTraineddata(true);
                break;
            }
            case Shape_Clustering: {
                this.runShapeClustering();
                break;
            }
            case Dictionary: {
                this.runDictionary();
                break;
            }
            case Train_from_Scratch: {
                this.generateTraineddata(false);
                break;
            }
        }
    }

    void makeBox() throws Exception {
        List<String> list = this.getCommand(cmdmake_box);
        if (this.bootstrapLang.length() == 0) {
            list.remove(4);
            list.remove(3);
        } else {
            list.set(4, this.bootstrapLang);
        }
        String[] stringArray = this.getImageFiles();
        if (stringArray.length == 0) {
            throw new RuntimeException("There are no training images.");
        }
        logger.info("Make Box Files");
        this.writeMessage("** Make Box Files **");
        for (String string : stringArray) {
            list.set(1, string);
            list.set(2, TextUtilities.stripExtension(string));
            this.runCommand(list);
        }
    }

    void generateTraineddata(boolean bl) throws Exception {
        String[] stringArray;
        if (!bl) {
            this.makeBox();
        }
        if ((stringArray = this.getImageFilesWithBox()).length == 0) {
            throw new RuntimeException("There are no training image/box pairs.");
        }
        logger.info("Run Tesseract for Training");
        this.writeMessage("** Run Tesseract for Training **");
        List<String> list = this.getCommand(cmdtess_train);
        for (String string : stringArray) {
            list.set(1, string);
            list.set(2, TextUtilities.stripExtension(string));
            this.runCommand(list);
        }
        logger.info("Compute the Character Set");
        this.writeMessage("** Compute the Character Set **");
        list = this.getCommand(cmdunicharset_extractor);
        stringArray = new File(this.inputDataDir).list(new FilenameFilter(){

            @Override
            public boolean accept(File file, String string) {
                return string.endsWith(".box");
            }
        });
        list.addAll(Arrays.asList(stringArray));
        this.runCommand(list);
        if (this.rtl) {
            logger.info("Fixed unicharset's Unicode character directionality.");
            this.writeMessage("Fixed unicharset's Unicode character directionality.\n");
            this.fixUniCharDirectionality();
        }
        this.runShapeClustering();
    }

    void runShapeClustering() throws Exception {
        String[] stringArray = new File(this.inputDataDir).list(new FilenameFilter(){

            @Override
            public boolean accept(File file, String string) {
                return string.endsWith(".tr");
            }
        });
        if (stringArray.length == 0) {
            throw new RuntimeException("There are no .tr files. Need to train Tesseract first.");
        }
        logger.info("Shape Clustering");
        this.writeMessage("** Shape Clustering **");
        List<String> list = this.getCommand(String.format(cmdshapeclustering, this.lang));
        list.addAll(Arrays.asList(stringArray));
        this.runCommand(list);
        logger.info("MF Training");
        this.writeMessage("** MF Training **");
        list = this.getCommand(String.format(cmdmftraining, this.lang));
        list.addAll(Arrays.asList(stringArray));
        this.runCommand(list);
        logger.info("CN Training");
        this.writeMessage("** CN Training **");
        list = this.getCommand(cmdcntraining);
        list.addAll(Arrays.asList(stringArray));
        this.runCommand(list);
        logger.info("Rename files");
        this.renameFile("inttemp");
        this.renameFile("pffmtable");
        this.renameFile("normproto");
        this.renameFile("shapetable");
        this.runDictionary();
    }

    void runDictionary() throws Exception {
        if (!new File(this.inputDataDir, this.lang + ".unicharset").exists()) {
            String string = String.format("There is no %1$s.unicharset. Need to train Tesseract first.", this.lang);
            throw new RuntimeException(string);
        }
        logger.info("Dictionary Data");
        this.writeMessage("** Dictionary Data **");
        List<String> list = this.getCommand(String.format(cmdwordlist2dawg, this.lang, this.rtl ? "-r 1" : ""));
        this.runCommand(list);
        list = this.getCommand(String.format(cmdwordlist2dawg2, this.lang, this.rtl ? "-r 1" : ""));
        this.runCommand(list);
        logger.info("Combine Data Files");
        this.writeMessage("** Combine Data Files **");
        list = this.getCommand(String.format(cmdcombine_tessdata, this.lang));
        this.runCommand(list);
        String string = this.lang + ".traineddata";
        logger.info("Moving generated traineddata file to tessdata folder");
        this.writeMessage("** Moving generated traineddata file to tessdata folder **");
        File file = new File(this.inputDataDir, "tessdata");
        if (!file.exists()) {
            file.mkdir();
        }
        boolean bl = new File(this.inputDataDir, string).renameTo(new File(file, string));
        logger.info("Training Completed");
        this.writeMessage("** Training Completed **");
    }

    void fixUniCharDirectionality() throws IOException {
        Path path = FileSystems.getDefault().getPath(this.inputDataDir, "unicharset");
        List<String> list = Files.readAllLines(path, StandardCharsets.UTF_8);
        for (int i = 0; i < list.size(); ++i) {
            String[] stringArray = list.get(i).split(" ");
            if (stringArray.length < 8) continue;
            boolean bl = false;
            int n = stringArray[0].codePointAt(0);
            String string = Character.UnicodeScript.of(n).toString();
            if (stringArray[3].equals("NULL")) {
                stringArray[3] = Utils.capitalize(string);
                bl = true;
            }
            byte by = Character.getDirectionality(n);
            String string2 = String.valueOf(by = this.customRuleOverride(by));
            if (!stringArray[5].equals(string2)) {
                stringArray[5] = string2;
                bl = true;
            }
            if (!bl) continue;
            list.set(i, Utils.join(Arrays.asList(stringArray), " "));
        }
        Files.write(path, list, StandardCharsets.UTF_8, StandardOpenOption.TRUNCATE_EXISTING);
    }

    byte customRuleOverride(byte by) {
        switch (by) {
            case 2: 
            case 16: 
            case 17: {
                by = 1;
            }
        }
        return by;
    }

    String[] getImageFiles() {
        String[] stringArray = new File(this.inputDataDir).list(new FilenameFilter(){

            @Override
            public boolean accept(File file, String string) {
                return string.toLowerCase().matches(".*\\.(tif|tiff|jpg|jpeg|png|bmp)$");
            }
        });
        return stringArray;
    }

    String[] getImageFilesWithBox() {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String string : this.getImageFiles()) {
            String string2 = TextUtilities.stripExtension(string);
            if (!new File(this.inputDataDir, string2 + ".box").exists()) continue;
            arrayList.add(string);
        }
        return arrayList.toArray(new String[0]);
    }

    void renameFile(String string) {
        File file = new File(this.inputDataDir, string);
        if (file.exists()) {
            File file2 = new File(this.inputDataDir, this.lang + "." + string);
            file2.delete();
            boolean bl = file.renameTo(file2);
            String string2 = (bl ? "Successful" : "Unsuccessful") + " rename of " + string;
            this.writeMessage(string2);
        }
    }

    List<String> getCommand(String string) {
        LinkedList<String> linkedList = new LinkedList<String>(Arrays.asList(string.split("\\s+")));
        linkedList.set(0, this.tessDir + "/" + (String)linkedList.get(0));
        return linkedList;
    }

    void runCommand(List<String> list) throws Exception {
        logger.log(Level.INFO, "Command: {0}", list.toString());
        this.writeMessage(list.toString());
        this.pb.command(list);
        Process process = this.pb.start();
        StreamGobbler streamGobbler = new StreamGobbler(process.getInputStream());
        streamGobbler.start();
        int n = process.waitFor();
        logger.log(Level.INFO, "Exit value = {0}", n);
        this.writeMessage(streamGobbler.getMessage());
        if (n != 0) {
            String string = list.get(0).contains("shapeclustering") ? "An error has occurred. font_properties could be missing a font entry." : streamGobbler.getMessage();
            throw new RuntimeException(string);
        }
    }

    void writeMessage(String string) {
        this.pcs.firePropertyChange("value", null, string + "\n");
    }
}

