/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.vietpad.components;

import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.ListModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import net.sourceforge.vietpad.utilities.LimitedLengthDocument;

public class OpenList
extends JPanel
implements ListSelectionListener,
ActionListener {
    protected JLabel m_title;
    protected JTextField m_text;
    protected JList m_list;
    protected JScrollPane m_scroll;

    public OpenList(String[] stringArray, String string, int n) {
        this(stringArray, string);
        this.m_text.setDocument(new LimitedLengthDocument(n));
        this.m_text.setColumns(n);
    }

    public OpenList(Object[] objectArray, String string) {
        this.setLayout(new BoxLayout(this, 1));
        this.m_title = new JLabel(string);
        this.m_title.setLabelFor(this.m_list);
        this.add(this.m_title);
        this.m_text = new JTextField();
        this.m_text.setAlignmentX(0.0f);
        this.m_text.addActionListener(this);
        this.add(this.m_text);
        this.m_list = new JList<Object>(objectArray);
        this.m_list.setVisibleRowCount(4);
        this.m_list.setSelectionMode(0);
        this.m_list.addListSelectionListener(this);
        this.m_list.setFont(this.m_text.getFont());
        this.m_scroll = new JScrollPane(this.m_list);
        this.m_scroll.setAlignmentX(0.0f);
        this.add(this.m_scroll);
    }

    public void setSelected(String string) {
        this.m_list.setSelectedValue(string, true);
        this.m_text.setText(string);
    }

    public String getSelected() {
        return this.m_text.getText();
    }

    public int getSelectedIndex() {
        return this.m_list.getSelectedIndex();
    }

    public void setSelectedInt(int n) {
        this.setSelected(Integer.toString(n));
    }

    public int getSelectedInt() {
        try {
            return Integer.parseInt(this.getSelected());
        }
        catch (NumberFormatException numberFormatException) {
            return -1;
        }
    }

    @Override
    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        if (listSelectionEvent.getValueIsAdjusting()) {
            return;
        }
        Object e = this.m_list.getSelectedValue();
        if (e != null) {
            this.m_text.setText(e.toString());
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        ListModel listModel = this.m_list.getModel();
        String string = this.m_text.getText().toLowerCase();
        for (int i = 0; i < listModel.getSize(); ++i) {
            String string2 = (String)listModel.getElementAt(i);
            if (!string2.toLowerCase().startsWith(string)) continue;
            this.m_list.setSelectedValue(string2, true);
            string = null;
            break;
        }
        if (string != null) {
            this.m_list.clearSelection();
        }
    }

    public void addListSelectionListener(ListSelectionListener listSelectionListener) {
        this.m_list.addListSelectionListener(listSelectionListener);
    }

    public void addActionListener(ActionListener actionListener) {
        this.m_text.addActionListener(actionListener);
    }

    public Dimension getPreferredSizeList() {
        return this.m_scroll.getPreferredSize();
    }

    public void setPreferredSizeList(Dimension dimension) {
        this.m_scroll.setPreferredSize(new Dimension(this.m_scroll.getPreferredSize().width, dimension.height));
    }
}

