/*
 * Decompiled with CFR 0.152.
 */
package org.armedbear.lisp;

import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.armedbear.lisp.AbstractString;
import org.armedbear.lisp.Bignum;
import org.armedbear.lisp.BuiltInClass;
import org.armedbear.lisp.Cons;
import org.armedbear.lisp.ControlTransfer;
import org.armedbear.lisp.Debug;
import org.armedbear.lisp.DoubleFloat;
import org.armedbear.lisp.Fixnum;
import org.armedbear.lisp.Function;
import org.armedbear.lisp.Java;
import org.armedbear.lisp.JavaException;
import org.armedbear.lisp.Lisp;
import org.armedbear.lisp.LispCharacter;
import org.armedbear.lisp.LispClass;
import org.armedbear.lisp.LispError;
import org.armedbear.lisp.LispInteger;
import org.armedbear.lisp.LispObject;
import org.armedbear.lisp.LispThread;
import org.armedbear.lisp.Primitive;
import org.armedbear.lisp.SimpleString;
import org.armedbear.lisp.SimpleVector;
import org.armedbear.lisp.SingleFloat;
import org.armedbear.lisp.Stream;
import org.armedbear.lisp.Symbol;
import org.armedbear.lisp.TypeError;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class JavaObject
extends LispObject {
    final Object obj;
    private final Class<?> intendedClass;
    public static final Symbol JAVA_CLASS_JCLASS = Lisp.PACKAGE_JAVA.intern("JAVA-CLASS-JCLASS");
    public static final Symbol JAVA_CLASS = Lisp.PACKAGE_JAVA.intern("JAVA-CLASS");
    public static final Symbol ENSURE_JAVA_CLASS = Lisp.PACKAGE_JAVA.intern("ENSURE-JAVA-CLASS");
    public static LispObject JAVA_OBJECT_TO_STRING_LENGTH = LispInteger.getInstance(32);
    public static final Symbol _JAVA_OBJECT_TO_STRING_LENGTH = Lisp.exportSpecial("*JAVA-OBJECT-TO-STRING-LENGTH*", Lisp.PACKAGE_JAVA, JAVA_OBJECT_TO_STRING_LENGTH);
    private static final Primitive DESCRIBE_JAVA_OBJECT;
    private static final Map<Class<?>, LispObject> javaClassMap;
    private static final Primitive _FIND_JAVA_CLASS;
    private static final Primitive _REGISTER_JAVA_CLASS;
    public static final Symbol NULL;
    public static final Symbol TRUE;
    public static final Symbol FALSE;

    public JavaObject(Object obj) {
        this.obj = obj;
        this.intendedClass = obj != null ? Java.maybeBoxClass(obj.getClass()) : null;
    }

    public JavaObject(Object obj, Class<?> intendedClass) {
        if (obj != null && intendedClass == null) {
            intendedClass = obj.getClass();
        }
        if (intendedClass != null && !(intendedClass = Java.maybeBoxClass(intendedClass)).isInstance(obj)) {
            if (intendedClass.equals(Byte.class) && obj instanceof Number) {
                this.obj = ((Number)obj).byteValue();
                this.intendedClass = intendedClass;
                return;
            }
            throw new ClassCastException(obj + " can not be cast to " + intendedClass);
        }
        this.obj = obj;
        this.intendedClass = intendedClass;
    }

    @Override
    public LispObject typeOf() {
        return Symbol.JAVA_OBJECT;
    }

    @Override
    public LispObject classOf() {
        if (this.obj == null) {
            return BuiltInClass.JAVA_OBJECT;
        }
        return ENSURE_JAVA_CLASS.execute(new JavaObject(this.obj.getClass()));
    }

    @Override
    public LispObject typep(LispObject type) {
        if (type == Symbol.JAVA_OBJECT) {
            return Lisp.T;
        }
        if (type == BuiltInClass.JAVA_OBJECT) {
            return Lisp.T;
        }
        LispObject cls = Lisp.NIL;
        if (type instanceof Symbol) {
            cls = LispClass.findClass(type, false);
        }
        if (cls == Lisp.NIL) {
            cls = type;
        }
        if (((LispObject)cls).typep(LispClass.findClass(JAVA_CLASS, false)) != Lisp.NIL) {
            if (this.obj != null) {
                Class c = (Class)JAVA_CLASS_JCLASS.execute(cls).javaInstance();
                return c.isAssignableFrom(this.obj.getClass()) ? Lisp.T : Lisp.NIL;
            }
            return Lisp.T;
        }
        if (cls == BuiltInClass.SEQUENCE && (List.class.isInstance(this.obj) || Set.class.isInstance(this.obj))) {
            return Lisp.T;
        }
        return super.typep(type);
    }

    @Override
    public LispObject STRING() {
        return new SimpleString(this.obj != null ? this.obj.toString() : "null");
    }

    public final Object getObject() {
        return this.obj;
    }

    public static final LispObject getInstance(Object obj) {
        if (obj == null) {
            return new JavaObject(null);
        }
        if (obj instanceof LispObject) {
            return (LispObject)obj;
        }
        return new JavaObject(obj);
    }

    public static final LispObject getInstance(Object obj, Class<?> intendedClass) {
        if (obj == null) {
            return new JavaObject(null);
        }
        if (obj instanceof LispObject) {
            return (LispObject)obj;
        }
        return new JavaObject(obj, intendedClass);
    }

    public static final LispObject getInstance(Object obj, boolean translated) {
        return JavaObject.getInstance(obj, translated, obj != null ? obj.getClass() : null);
    }

    public static final LispObject getInstance(Object obj, boolean translated, Class<?> intendedClass) {
        if (!translated) {
            return JavaObject.getInstance(obj, intendedClass);
        }
        if (obj == null) {
            return Lisp.NIL;
        }
        if (obj instanceof LispObject) {
            return (LispObject)obj;
        }
        if (obj instanceof String) {
            return new SimpleString((String)obj);
        }
        if (obj instanceof Number) {
            if (obj instanceof Integer) {
                return Fixnum.getInstance((Integer)obj);
            }
            if (obj instanceof Float) {
                return new SingleFloat(((Float)obj).floatValue());
            }
            if (obj instanceof Double) {
                return new DoubleFloat((Double)obj);
            }
            if (obj instanceof Long) {
                return LispInteger.getInstance((Long)obj);
            }
            if (obj instanceof BigInteger) {
                return Bignum.getInstance((BigInteger)obj);
            }
            if (obj instanceof Short) {
                return Fixnum.getInstance(((Short)obj).shortValue());
            }
            if (obj instanceof Byte) {
                return Fixnum.getInstance(((Byte)obj).byteValue());
            }
        }
        if (obj instanceof Boolean) {
            return (Boolean)obj != false ? Lisp.T : Lisp.NIL;
        }
        if (obj instanceof Character) {
            return LispCharacter.getInstance(((Character)obj).charValue());
        }
        if (obj instanceof Object[]) {
            Object[] array = (Object[])obj;
            SimpleVector v = new SimpleVector(array.length);
            int i = array.length;
            while (i-- > 0) {
                v.aset(i, JavaObject.getInstance(array[i], translated));
            }
            return v;
        }
        return new JavaObject(obj, intendedClass);
    }

    @Override
    public Object javaInstance() {
        return this.obj;
    }

    @Override
    public Object javaInstance(Class<?> c) {
        if (this.obj == null) {
            if (c.isPrimitive()) {
                throw new NullPointerException("Cannot assign null to " + c);
            }
            return this.obj;
        }
        if ((c = Java.maybeBoxClass(c)).isAssignableFrom(this.intendedClass) || c.isInstance(this.obj)) {
            return this.obj;
        }
        return Lisp.error(new TypeError(this.intendedClass.getName() + " is not assignable to " + c.getName()));
    }

    @Override
    public Object lockableInstance() {
        return this.obj;
    }

    public Class<?> getIntendedClass() {
        return this.intendedClass;
    }

    public static final Object getObject(LispObject o) {
        if (o instanceof JavaObject) {
            return ((JavaObject)o).obj;
        }
        return Lisp.type_error(o, Symbol.JAVA_OBJECT);
    }

    @Override
    public final boolean equal(LispObject other) {
        if (this == other) {
            return true;
        }
        if (other instanceof JavaObject) {
            return this.obj == ((JavaObject)other).obj;
        }
        return false;
    }

    @Override
    public final boolean equalp(LispObject other) {
        return this.equal(other);
    }

    @Override
    public int sxhash() {
        return this.obj == null ? 0 : this.obj.hashCode() & 0x7FFFFFF;
    }

    @Override
    public String printObject() {
        String s;
        if (this.obj instanceof ControlTransfer) {
            return this.obj.toString();
        }
        if (this.obj != null) {
            Class<?> c = this.obj.getClass();
            StringBuilder sb = new StringBuilder(c.isArray() ? "jarray" : c.getName());
            sb.append(' ');
            try {
                String ts = this.obj.toString();
                int length = -1;
                LispObject stringLength = _JAVA_OBJECT_TO_STRING_LENGTH.symbolValueNoThrow();
                if (stringLength instanceof Fixnum) {
                    length = Fixnum.getValue(stringLength);
                }
                if (length < 0) {
                    sb.append(ts);
                } else if (ts.length() > length) {
                    sb.append(ts.substring(0, length)).append("....");
                } else {
                    sb.append(ts);
                }
                s = sb.toString();
            }
            catch (Exception e) {
                return Lisp.serror(new JavaException(e));
            }
        } else {
            s = "null";
        }
        return this.unreadableString(s);
    }

    @Override
    public LispObject getDescription() {
        return new SimpleString(JavaObject.describeJavaObject(this));
    }

    @Override
    public LispObject getParts() {
        if (this.obj != null) {
            LispObject parts = Lisp.NIL;
            parts = parts.push(new Cons("Java class", (LispObject)new JavaObject(this.obj.getClass())));
            if (this.intendedClass != null) {
                parts = parts.push(new Cons("intendedClass", (LispObject)new SimpleString(this.intendedClass.getCanonicalName())));
            }
            if (this.obj.getClass().isArray()) {
                int length = Array.getLength(this.obj);
                for (int i = 0; i < length; ++i) {
                    parts = parts.push(new Cons(new SimpleString(i), JavaObject.getInstance(Array.get(this.obj, i))));
                }
            } else {
                parts = Symbol.NCONC.execute(parts, this.getInspectedFields());
            }
            if (this.obj instanceof Class) {
                int i;
                Class o = (Class)this.obj;
                try {
                    Class<?>[] classes = o.getClasses();
                    LispObject classesList = Lisp.NIL;
                    for (i = 0; i < classes.length; ++i) {
                        classesList = classesList.push(JavaObject.getInstance(classes[i]));
                    }
                    if (!classesList.equals(Lisp.NIL)) {
                        parts = parts.push(new Cons("Member classes", classesList.nreverse()));
                    }
                }
                catch (SecurityException e) {
                    Debug.trace(e);
                }
                Class<?>[] interfaces = o.getInterfaces();
                LispObject interfacesList = Lisp.NIL;
                for (i = 0; i < interfaces.length; ++i) {
                    interfacesList = interfacesList.push(JavaObject.getInstance(interfaces[i]));
                }
                if (!interfacesList.equals(Lisp.NIL)) {
                    parts = parts.push(new Cons("Interfaces", interfacesList.nreverse()));
                }
                LispObject superclassList = Lisp.NIL;
                for (Class superclass = o.getSuperclass(); superclass != null; superclass = superclass.getSuperclass()) {
                    superclassList = superclassList.push(JavaObject.getInstance(superclass));
                }
                if (!superclassList.equals(Lisp.NIL)) {
                    parts = parts.push(new Cons("Superclasses", superclassList.nreverse()));
                }
            }
            return parts.nreverse();
        }
        return Lisp.NIL;
    }

    private LispObject getInspectedFields() {
        final LispObject[] acc = new LispObject[]{Lisp.NIL};
        JavaObject.doClassHierarchy(this.obj.getClass(), new Function(){

            public LispObject execute(LispObject arg) {
                Class c = (Class)arg.javaInstance();
                for (Field f : c.getDeclaredFields()) {
                    LispObject value = Lisp.NIL;
                    try {
                        if (!f.isAccessible()) {
                            f.setAccessible(true);
                        }
                        value = JavaObject.getInstance(f.get(JavaObject.this.obj));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    acc[0] = acc[0].push(new Cons(f.getName(), value));
                }
                return acc[0];
            }
        });
        return acc[0].nreverse();
    }

    private static void doClassHierarchy(Collection<Class<?>> classes, LispObject callback, Set<Class<?>> visited) {
        LinkedList newClasses = new LinkedList();
        for (Class<?> clss : classes) {
            if (clss == null) continue;
            if (!visited.contains(clss)) {
                callback.execute(JavaObject.getInstance(clss, true));
                visited.add(clss);
            }
            if (!visited.contains(clss.getSuperclass())) {
                newClasses.add(clss.getSuperclass());
            }
            for (Class<?> iface : clss.getInterfaces()) {
                if (visited.contains(iface)) continue;
                newClasses.add(iface);
            }
        }
        if (!newClasses.isEmpty()) {
            JavaObject.doClassHierarchy(newClasses, callback, visited);
        }
    }

    public static void doClassHierarchy(Class<?> clss, LispObject callback) {
        if (clss != null) {
            HashSet visited = new HashSet();
            ArrayList classes = new ArrayList(1);
            classes.add(clss);
            JavaObject.doClassHierarchy(classes, callback, visited);
        }
    }

    public static LispObject mapcarClassHierarchy(Class<?> clss, final LispObject fn) {
        final LispObject[] acc = new LispObject[]{Lisp.NIL};
        JavaObject.doClassHierarchy(clss, new Function(){

            public LispObject execute(LispObject arg) {
                acc[0] = acc[0].push(fn.execute(arg));
                return acc[0];
            }
        });
        return acc[0].nreverse();
    }

    public static String describeJavaObject(JavaObject javaObject) {
        Object obj = javaObject.getObject();
        StringBuilder sb = new StringBuilder(javaObject.princToString());
        sb.append(" is an object of type ");
        sb.append(Symbol.JAVA_OBJECT.princToString());
        sb.append(".");
        sb.append(System.getProperty("line.separator"));
        sb.append("The wrapped Java object is ");
        if (obj == null) {
            sb.append("null.");
        } else {
            sb.append("an ");
            Class<?> c = obj.getClass();
            String className = c.getName();
            if (c.isArray()) {
                sb.append("array of ");
                if (className.startsWith("[L") && className.endsWith(";")) {
                    className = className.substring(1, className.length() - 1);
                    sb.append(className);
                    sb.append(" objects");
                } else if (className.startsWith("[") && className.length() > 1) {
                    String type;
                    char descriptor = className.charAt(1);
                    switch (descriptor) {
                        case 'B': {
                            type = "bytes";
                            break;
                        }
                        case 'C': {
                            type = "chars";
                            break;
                        }
                        case 'D': {
                            type = "doubles";
                            break;
                        }
                        case 'F': {
                            type = "floats";
                            break;
                        }
                        case 'I': {
                            type = "ints";
                            break;
                        }
                        case 'J': {
                            type = "longs";
                            break;
                        }
                        case 'S': {
                            type = "shorts";
                            break;
                        }
                        case 'Z': {
                            type = "booleans";
                            break;
                        }
                        default: {
                            type = "unknown type";
                        }
                    }
                    sb.append(type);
                }
                sb.append(" with ");
                int length = Array.getLength(obj);
                sb.append(length);
                sb.append(" element");
                if (length != 1) {
                    sb.append('s');
                }
                sb.append('.');
            } else {
                sb.append("instance of ");
                sb.append(className);
                sb.append(':');
                sb.append(System.getProperty("line.separator"));
                sb.append("  \"");
                sb.append(obj.toString());
                sb.append('\"');
            }
        }
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static LispObject registerJavaClass(Class<?> javaClass, LispObject classMetaObject) {
        Map<Class<?>, LispObject> map = javaClassMap;
        synchronized (map) {
            javaClassMap.put(javaClass, classMetaObject);
            return classMetaObject;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static LispObject findJavaClass(Class<?> javaClass) {
        Map<Class<?>, LispObject> map = javaClassMap;
        synchronized (map) {
            LispObject c = javaClassMap.get(javaClass);
            if (c != null) {
                return c;
            }
            return Lisp.NIL;
        }
    }

    static {
        String doc = "Length to truncate toString() PRINT-OBJECT output for an otherwise unspecialized JAVA-OBJECT.  Can be set to NIL to indicate no limit.";
        _JAVA_OBJECT_TO_STRING_LENGTH.setDocumentation(Symbol.VARIABLE, new SimpleString(doc));
        DESCRIBE_JAVA_OBJECT = new Primitive("describe-java-object", Lisp.PACKAGE_JAVA, true){

            public LispObject execute(LispObject first, LispObject second) {
                if (!(first instanceof JavaObject)) {
                    return Lisp.type_error(first, Symbol.JAVA_OBJECT);
                }
                Stream stream = Lisp.checkStream(second);
                JavaObject javaObject = (JavaObject)first;
                stream._writeString(JavaObject.describeJavaObject(javaObject));
                return LispThread.currentThread().nothing();
            }
        };
        javaClassMap = new HashMap();
        _FIND_JAVA_CLASS = new Primitive("%find-java-class", Lisp.PACKAGE_JAVA, false, "class-name-or-class"){

            public LispObject execute(LispObject arg) {
                try {
                    if (arg instanceof AbstractString) {
                        return JavaObject.findJavaClass(Class.forName(arg.getStringValue()));
                    }
                    return JavaObject.findJavaClass((Class)arg.javaInstance());
                }
                catch (ClassNotFoundException e) {
                    return Lisp.error(new LispError("Cannot find Java class " + arg.getStringValue()));
                }
            }
        };
        _REGISTER_JAVA_CLASS = new Primitive("%register-java-class", Lisp.PACKAGE_JAVA, false, "jclass class-metaobject"){

            public LispObject execute(LispObject jclass, LispObject classMetaObject) {
                return JavaObject.registerJavaClass((Class)jclass.javaInstance(), classMetaObject);
            }
        };
        NULL = Lisp.exportConstant("+NULL+", Lisp.PACKAGE_JAVA, new JavaObject(null));
        doc = "The JVM null object reference.";
        NULL.setDocumentation(Symbol.VARIABLE, new SimpleString(doc));
        TRUE = Lisp.exportConstant("+TRUE+", Lisp.PACKAGE_JAVA, new JavaObject(true));
        doc = "The JVM primitive value for boolean true.";
        TRUE.setDocumentation(Symbol.VARIABLE, new SimpleString(doc));
        FALSE = Lisp.exportConstant("+FALSE+", Lisp.PACKAGE_JAVA, new JavaObject(false));
        doc = "The JVM primitive value for boolean false.";
        FALSE.setDocumentation(Symbol.VARIABLE, new SimpleString(doc));
    }
}

