/*
 * Decompiled with CFR 0.152.
 */
package org.armedbear.lisp;

import java.util.Collections;
import java.util.Map;
import java.util.WeakHashMap;
import org.armedbear.lisp.Cons;
import org.armedbear.lisp.Lisp;
import org.armedbear.lisp.LispObject;
import org.armedbear.lisp.LispThread;
import org.armedbear.lisp.Primitive;
import org.armedbear.lisp.Symbol;

public final class function_info {
    static final Map<LispObject, LispObject> symbolToFunctionMap = Collections.synchronizedMap(new WeakHashMap());
    private static final Primitive FUNCTION_INFO = new Primitive("function-info", Lisp.PACKAGE_SYS, false){

        public LispObject execute(LispObject arg) {
            LispObject info = symbolToFunctionMap.get(arg);
            return info != null ? info : Lisp.NIL;
        }
    };
    private static final Primitive _SET_FUNCTION_INFO = new Primitive("%set-function-info", Lisp.PACKAGE_SYS, false){

        public LispObject execute(LispObject name, LispObject info) {
            if (info == Lisp.NIL) {
                symbolToFunctionMap.remove(name);
            } else {
                symbolToFunctionMap.put(name, info);
            }
            return info;
        }
    };
    private static final Primitive GET_FUNCTION_INFO_VALUE = new Primitive("get-function-info-value", Lisp.PACKAGE_SYS, true, "name indicator"){

        public LispObject execute(LispObject name, LispObject indicator) {
            LispObject info = symbolToFunctionMap.get(name);
            if (info != null) {
                while (info != Lisp.NIL) {
                    LispObject cons = info.car();
                    if (cons instanceof Cons) {
                        if (cons.car().eql(indicator)) {
                            return LispThread.currentThread().setValues(cons.cdr(), Lisp.T);
                        }
                    } else if (cons != Lisp.NIL) {
                        Lisp.type_error(cons, Symbol.LIST);
                    }
                    info = info.cdr();
                }
            }
            return LispThread.currentThread().setValues(Lisp.NIL, Lisp.NIL);
        }
    };
    private static final Primitive SET_FUNCTION_INFO_VALUE = new Primitive("set-function-info-value", Lisp.PACKAGE_SYS, true, "name indicator value"){

        public LispObject execute(LispObject name, LispObject indicator, LispObject value) {
            LispObject info = symbolToFunctionMap.get(name);
            if (info == null) {
                info = Lisp.NIL;
            }
            for (LispObject alist = info; alist != Lisp.NIL; alist = alist.cdr()) {
                LispObject cons = alist.car();
                if (cons instanceof Cons) {
                    if (!cons.car().eql(indicator)) continue;
                    cons.setCdr(value);
                    return value;
                }
                if (cons == Lisp.NIL) continue;
                Lisp.type_error(cons, Symbol.LIST);
            }
            symbolToFunctionMap.put(name, info.push(new Cons(indicator, value)));
            return value;
        }
    };
}

