/*
 * Decompiled with CFR 0.152.
 */
package org.armedbear.lisp;

import java.math.BigInteger;
import org.armedbear.lisp.Bignum;
import org.armedbear.lisp.Fixnum;
import org.armedbear.lisp.Lisp;
import org.armedbear.lisp.LispObject;
import org.armedbear.lisp.Primitive;
import org.armedbear.lisp.Symbol;

public final class logeqv
extends Primitive {
    private static final Primitive LOGEQV = new logeqv();

    private logeqv() {
        super("logeqv", "&rest integers");
    }

    public LispObject execute() {
        return Fixnum.MINUS_ONE;
    }

    public LispObject execute(LispObject arg) {
        if (arg instanceof Fixnum) {
            return arg;
        }
        if (arg instanceof Bignum) {
            return arg;
        }
        return Lisp.type_error(arg, Symbol.INTEGER);
    }

    public LispObject execute(LispObject[] args) {
        BigInteger result = null;
        for (int i = 0; i < args.length; ++i) {
            BigInteger n;
            LispObject arg = args[i];
            if (arg instanceof Fixnum) {
                n = ((Fixnum)arg).getBigInteger();
            } else if (arg instanceof Bignum) {
                n = ((Bignum)arg).value;
            } else {
                return Lisp.type_error(arg, Symbol.INTEGER);
            }
            result = result == null ? n : result.xor(n).not();
        }
        return Lisp.number(result);
    }
}

