/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.util.concurrent.atomic.AtomicBoolean;
import net.sourceforge.plantuml.Log;
import net.sourceforge.plantuml.core.Diagram;
import net.sourceforge.plantuml.cucadiagram.dot.GraphvizUtils;

public class OptionFlags {
    public static boolean GRAPHVIZCACHE = false;
    public static final boolean TRACE_DOT = false;
    public static final boolean HORIZONTAL_LINE_BETWEEN_DIFFERENT_PACKAGE_ALLOWED = false;
    public static boolean ALLOW_INCLUDE = true;
    public static final boolean USE_HECTOR = false;
    public static final boolean USE_4747 = true;
    public static final boolean USE_CREOLE = true;
    public static final boolean USE_CREOLE2 = true;
    public static boolean ADD_NICE_FOR_DOT = false;
    public static final boolean CRASH_SPRITE = false;
    public static final boolean STRICT_SELFMESSAGE_POSITION = true;
    public static final boolean TEOZ = false;
    private static final OptionFlags singleton = new OptionFlags();
    private boolean keepTmpFiles;
    private boolean verbose;
    private boolean metadata;
    private boolean word;
    private boolean systemExit;
    private String dotExecutable;
    private boolean gui;
    private boolean quiet;
    private boolean checkDotError;
    private boolean printFonts;
    private boolean useSuggestEngine;
    private boolean encodesprite;
    private boolean overwrite;
    private File logData;
    private final AtomicBoolean logDataInitized = new AtomicBoolean(false);

    void reset() {
        this.reset(false);
    }

    private void reset(boolean bl) {
        this.keepTmpFiles = false;
        this.verbose = false;
        this.metadata = false;
        this.word = false;
        this.systemExit = bl;
        this.dotExecutable = null;
        this.gui = false;
        this.quiet = false;
        this.checkDotError = false;
        this.printFonts = false;
        this.useSuggestEngine = true;
        this.encodesprite = false;
    }

    public boolean useJavaInsteadOfDot() {
        return false;
    }

    private OptionFlags() {
        this.reset(true);
    }

    public static OptionFlags getInstance() {
        return singleton;
    }

    public final synchronized boolean isKeepTmpFiles() {
        return this.keepTmpFiles;
    }

    public final synchronized void setKeepTmpFiles(boolean bl) {
        this.keepTmpFiles = bl;
    }

    public final boolean isVerbose() {
        return this.verbose;
    }

    public final void setVerbose(boolean bl) {
        this.verbose = bl;
    }

    public final boolean isMetadata() {
        return this.metadata;
    }

    public final void setMetadata(boolean bl) {
        this.metadata = bl;
    }

    public final boolean isWord() {
        return this.word;
    }

    public final void setWord(boolean bl) {
        this.word = bl;
    }

    public final boolean isSystemExit() {
        return this.systemExit;
    }

    public final void setSystemExit(boolean bl) {
        this.systemExit = bl;
    }

    public final String getDotExecutable() {
        return this.dotExecutable;
    }

    public final void setDotExecutable(String string) {
        this.dotExecutable = string;
    }

    public final boolean isGui() {
        return this.gui;
    }

    public final void setGui(boolean bl) {
        this.gui = bl;
    }

    public final boolean isQuiet() {
        return this.quiet;
    }

    public final void setQuiet(boolean bl) {
        this.quiet = bl;
    }

    public final boolean isCheckDotError() {
        return this.checkDotError;
    }

    public final void setCheckDotError(boolean bl) {
        this.checkDotError = bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void logData(File file, Diagram diagram) {
        String string = diagram.getWarningOrError();
        if (string == null) {
            return;
        }
        AtomicBoolean atomicBoolean = this.logDataInitized;
        synchronized (atomicBoolean) {
            Object object;
            if (this.logData == null && !this.logDataInitized.get()) {
                object = GraphvizUtils.getenvLogData();
                if (object != null) {
                    this.setLogData(new File((String)object));
                }
                this.logDataInitized.set(true);
            }
            if (this.logData == null) {
                return;
            }
            object = null;
            try {
                object = new PrintStream(new FileOutputStream(this.logData, true));
                ((PrintStream)object).println("Start of " + file.getName());
                ((PrintStream)object).println(string);
                ((PrintStream)object).println("End of " + file.getName());
                ((PrintStream)object).println();
            }
            catch (FileNotFoundException fileNotFoundException) {
                Log.error("Cannot open " + this.logData);
                fileNotFoundException.printStackTrace();
            }
            finally {
                if (object != null) {
                    ((PrintStream)object).close();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setLogData(File file) {
        this.logData = file;
        file.delete();
        PrintStream printStream = null;
        try {
            printStream = new PrintStream(new FileOutputStream(file));
            printStream.println();
        }
        catch (FileNotFoundException fileNotFoundException) {
            Log.error("Cannot open " + file);
            fileNotFoundException.printStackTrace();
        }
        finally {
            if (printStream != null) {
                printStream.close();
            }
        }
    }

    public final boolean isPrintFonts() {
        return this.printFonts;
    }

    public final void setPrintFonts(boolean bl) {
        this.printFonts = bl;
    }

    public final boolean isUseSuggestEngine() {
        return this.useSuggestEngine;
    }

    public final void setUseSuggestEngine(boolean bl) {
        this.useSuggestEngine = bl;
    }

    public final boolean isEncodesprite() {
        return this.encodesprite;
    }

    public final void setEncodesprite(boolean bl) {
        this.encodesprite = bl;
    }

    public final boolean isOverwrite() {
        return this.overwrite;
    }

    public final void setOverwrite(boolean bl) {
        this.overwrite = bl;
    }
}

