/*
 * Decompiled with CFR 0.152.
 */
package org.armedbear.lisp;

import org.armedbear.lisp.AbstractArray;
import org.armedbear.lisp.AbstractVector;
import org.armedbear.lisp.Cons;
import org.armedbear.lisp.Fixnum;
import org.armedbear.lisp.Lisp;
import org.armedbear.lisp.LispError;
import org.armedbear.lisp.LispObject;
import org.armedbear.lisp.Primitive;
import org.armedbear.lisp.WrongNumberOfArgumentsException;

public final class adjust_array
extends Primitive {
    private static final Primitive _ADJUST_ARRAY = new adjust_array();

    public adjust_array() {
        super("%adjust-array", Lisp.PACKAGE_SYS, false);
    }

    public LispObject execute(LispObject[] args) {
        if (args.length != 10) {
            return Lisp.error(new WrongNumberOfArgumentsException(this, 10));
        }
        AbstractArray array = Lisp.checkArray(args[0]);
        LispObject dimensions = args[1];
        LispObject elementType = args[2];
        boolean initialElementProvided = args[4] != Lisp.NIL;
        boolean initialContentsProvided = args[6] != Lisp.NIL;
        LispObject initialElement = initialElementProvided ? args[3] : null;
        LispObject initialContents = initialContentsProvided ? args[5] : null;
        LispObject fillPointer = args[7];
        LispObject displacedTo = args[8];
        LispObject displacedIndexOffset = args[9];
        if (initialElementProvided && initialContentsProvided) {
            return Lisp.error(new LispError("ADJUST-ARRAY: cannot specify both initial element and initial contents."));
        }
        if (elementType != array.getElementType() && Lisp.getUpgradedArrayElementType(elementType) != array.getElementType()) {
            return Lisp.error(new LispError("ADJUST-ARRAY: incompatible element type."));
        }
        if (array.getRank() == 0) {
            return array.adjustArray(new int[0], initialElement, initialContents);
        }
        if (!initialElementProvided && array.getElementType() == Lisp.T) {
            initialElement = Fixnum.ZERO;
        }
        if (array.getRank() == 1) {
            int newSize = dimensions instanceof Cons && dimensions.length() == 1 ? Fixnum.getValue(dimensions.car()) : Fixnum.getValue(dimensions);
            if (array instanceof AbstractVector) {
                AbstractArray v2;
                AbstractVector v = (AbstractVector)array;
                if (displacedTo != Lisp.NIL) {
                    int displacement = displacedIndexOffset == Lisp.NIL ? 0 : Fixnum.getValue(displacedIndexOffset);
                    v2 = v.adjustArray(newSize, Lisp.checkArray(displacedTo), displacement);
                } else {
                    v2 = v.adjustArray(newSize, initialElement, initialContents);
                }
                if (fillPointer != Lisp.NIL) {
                    v2.setFillPointer(fillPointer);
                }
                return v2;
            }
        }
        int rank = dimensions.listp() ? dimensions.length() : 1;
        int[] dimv = new int[rank];
        if (dimensions.listp()) {
            for (int i = 0; i < rank; ++i) {
                LispObject dim = dimensions.car();
                dimv[i] = Fixnum.getValue(dim);
                dimensions = dimensions.cdr();
            }
        } else {
            dimv[0] = Fixnum.getValue(dimensions);
        }
        if (displacedTo != Lisp.NIL) {
            int displacement = displacedIndexOffset == Lisp.NIL ? 0 : Fixnum.getValue(displacedIndexOffset);
            return array.adjustArray(dimv, Lisp.checkArray(displacedTo), displacement);
        }
        return array.adjustArray(dimv, initialElement, initialContents);
    }
}

