/*
 * Decompiled with CFR 0.152.
 */
package org.armedbear.lisp;

import org.armedbear.lisp.AbstractString;
import org.armedbear.lisp.JavaObject;
import org.armedbear.lisp.Lisp;
import org.armedbear.lisp.LispObject;
import org.armedbear.lisp.LispThread;
import org.armedbear.lisp.Primitive;
import org.armedbear.lisp.SimpleString;
import org.armedbear.lisp.Symbol;

public final class jclass_of
extends Primitive {
    private static final Primitive JCLASS_OF = new jclass_of();

    private jclass_of() {
        super(Symbol.JCLASS_OF, "object &optional name", "Returns the name of the Java class of OBJECT. If the NAME argument is\n  supplied, verifies that OBJECT is an instance of the named class. The name\n  of the class or nil is always returned as a second value.");
    }

    public LispObject execute(LispObject arg) {
        String className = arg instanceof AbstractString ? "java.lang.String" : (arg instanceof JavaObject ? ((JavaObject)arg).getObject().getClass().getName() : null);
        LispObject value = className != null ? new SimpleString(className) : Lisp.NIL;
        return LispThread.currentThread().setValues(value, value);
    }

    public LispObject execute(LispObject first, LispObject second) {
        String className = first instanceof AbstractString ? "java.lang.String" : (first instanceof JavaObject ? ((JavaObject)first).getObject().getClass().getName() : null);
        String name = Lisp.javaString(second);
        return LispThread.currentThread().setValues(name.equals(className) ? Lisp.T : Lisp.NIL, new SimpleString(className));
    }
}

