/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.runtime.marshal;

import java.io.IOException;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Map;
import org.jruby.RubySymbol;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.marshal.MarshalStream;

public class MarshalCache {
    private final Map<IRubyObject, Integer> linkCache = new IdentityHashMap<IRubyObject, Integer>();
    private final Map<String, Integer> symbolCache = new HashMap<String, Integer>();

    public boolean isRegistered(IRubyObject value2) {
        if (value2 instanceof RubySymbol) {
            return this.isSymbolRegistered(((RubySymbol)value2).asJavaString());
        }
        return this.linkCache.containsKey(value2);
    }

    public boolean isSymbolRegistered(String sym) {
        return this.symbolCache.containsKey(sym);
    }

    public void register(IRubyObject value2) {
        if (value2 instanceof RubySymbol) {
            this.registerSymbol(value2.asJavaString());
        } else {
            this.linkCache.put(value2, this.linkCache.size());
        }
    }

    public void registerSymbol(String sym) {
        this.symbolCache.put(sym, this.symbolCache.size());
    }

    public void writeLink(MarshalStream output, IRubyObject value2) throws IOException {
        if (value2 instanceof RubySymbol) {
            this.writeSymbolLink(output, ((RubySymbol)value2).asJavaString());
        } else {
            output.write(64);
            output.writeInt(this.registeredIndex(value2));
        }
    }

    public void writeSymbolLink(MarshalStream output, String sym) throws IOException {
        output.write(59);
        output.writeInt(this.registeredSymbolIndex(sym));
    }

    private int registeredIndex(IRubyObject value2) {
        if (value2 instanceof RubySymbol) {
            return this.registeredSymbolIndex(value2.asJavaString());
        }
        return this.linkCache.get(value2);
    }

    private int registeredSymbolIndex(String sym) {
        return this.symbolCache.get(sym);
    }
}

