/*
 * Decompiled with CFR 0.152.
 */
package com.orbus.mahalo.dns;

import com.orbus.mahalo.dns.DNSEntry;
import com.orbus.mahalo.dns.DNSRecord;
import java.io.IOException;
import java.nio.ByteBuffer;

public final class DNSQuestion {
    DNSEntry _Entry;

    public boolean wantsUnicastResponce() {
        return this._Entry.getUnique();
    }

    public void setWantsUnicastResponce(boolean abYes) {
        this._Entry.setUnique(abYes);
    }

    public String getName() {
        return this._Entry.getName();
    }

    public DNSEntry.EntryType getType() {
        return this._Entry.getType();
    }

    public DNSEntry.EntryClass getDNSClass() {
        return this._Entry.getDNSClass();
    }

    DNSQuestion() {
    }

    public DNSQuestion(String asName, DNSEntry.EntryType aeType, DNSEntry.EntryClass aeClass, boolean abUnicastResponce) {
        this._Entry = new DNSEntry(asName, aeType, aeClass, abUnicastResponce);
    }

    public boolean answeredBy(DNSRecord rec) {
        return this._Entry._eClass == rec._Entry._eClass && (this._Entry._eType == rec._Entry._eType || this._Entry._eType == DNSEntry.EntryType.ANY) && this._Entry._sName.equals(rec._Entry._sName);
    }

    public void write(ByteBuffer aBuffer) {
        this._Entry.write(aBuffer);
    }

    public String toString() {
        return "question" + this._Entry.toString();
    }

    public static DNSQuestion Parse(ByteBuffer buffer) throws IOException {
        DNSQuestion retQuestion = new DNSQuestion();
        retQuestion._Entry = DNSEntry.Parse(buffer);
        return retQuestion;
    }
}

