/*
 * Decompiled with CFR 0.152.
 */
package com.github.rjeschke.txtmark;

import com.github.rjeschke.txtmark.BlockType;
import com.github.rjeschke.txtmark.Line;

class Block {
    public BlockType type = BlockType.NONE;
    public Line lines = null;
    public Line lineTail = null;
    public Block blocks = null;
    public Block blockTail = null;
    public Block next = null;
    public int hlDepth = 0;
    public String id = null;

    public boolean hasLines() {
        return this.lines != null;
    }

    public void removeSurroundingEmptyLines() {
        if (this.lines != null) {
            this.removeTrailingEmptyLines();
            this.removeLeadingEmptyLines();
        }
    }

    public void transfromHeadline() {
        int n;
        if (this.hlDepth > 0) {
            return;
        }
        int n2 = 0;
        Line line = this.lines;
        if (line.isEmpty) {
            return;
        }
        for (n = line.leading; n < line.value.length() && line.value.charAt(n) == '#'; ++n) {
            ++n2;
        }
        while (n < line.value.length() && line.value.charAt(n) == ' ') {
            ++n;
        }
        if (n >= line.value.length()) {
            line.setEmpty();
        } else {
            int n3 = line.value.length() - line.trailing - 1;
            while (line.value.charAt(n3) == '#') {
                --n3;
            }
            while (line.value.charAt(n3) == ' ') {
                --n3;
            }
            line.value = line.value.substring(n, n3 + 1);
            line.trailing = 0;
            line.leading = 0;
        }
        this.hlDepth = Math.min(n2, 6);
    }

    public void removeListIndent() {
        Line line = this.lines;
        while (line != null) {
            if (!line.isEmpty) {
                switch (line.getLineType()) {
                    case ULIST: {
                        line.value = line.value.substring(line.leading + 2);
                        break;
                    }
                    case OLIST: {
                        line.value = line.value.substring(line.value.indexOf(46) + 2);
                        break;
                    }
                    default: {
                        line.value = line.value.substring(Math.min(line.leading, 4));
                    }
                }
                line.initLeading();
            }
            line = line.next;
        }
    }

    public void removeBlockQuotePrefix() {
        Line line = this.lines;
        while (line != null) {
            if (!line.isEmpty && line.value.charAt(line.leading) == '>') {
                int n = line.leading + 1;
                if (line.leading + 1 < line.value.length() && line.value.charAt(line.leading + 1) == ' ') {
                    ++n;
                }
                line.value = line.value.substring(n);
                line.initLeading();
            }
            line = line.next;
        }
    }

    public boolean removeLeadingEmptyLines() {
        boolean bl = false;
        Line line = this.lines;
        while (line != null && line.isEmpty) {
            this.removeLine(line);
            line = this.lines;
            bl = true;
        }
        return bl;
    }

    public void removeTrailingEmptyLines() {
        Line line = this.lineTail;
        while (line != null && line.isEmpty) {
            this.removeLine(line);
            line = this.lineTail;
        }
    }

    public Block split(Line line) {
        Block block = new Block();
        block.lines = this.lines;
        block.lineTail = line;
        this.lines = line.next;
        line.next = null;
        if (this.lines == null) {
            this.lineTail = null;
        } else {
            this.lines.previous = null;
        }
        if (this.blocks == null) {
            this.blocks = this.blockTail = block;
        } else {
            this.blockTail.next = block;
            this.blockTail = block;
        }
        return block;
    }

    public void removeLine(Line line) {
        if (line.previous == null) {
            this.lines = line.next;
        } else {
            line.previous.next = line.next;
        }
        if (line.next == null) {
            this.lineTail = line.previous;
        } else {
            line.next.previous = line.previous;
        }
        line.next = null;
        line.previous = null;
    }

    public void appendLine(Line line) {
        if (this.lineTail == null) {
            this.lines = this.lineTail = line;
        } else {
            this.lineTail.nextEmpty = line.isEmpty;
            line.prevEmpty = this.lineTail.isEmpty;
            line.previous = this.lineTail;
            this.lineTail.next = line;
            this.lineTail = line;
        }
    }

    public void expandListParagraphs() {
        Block block;
        if (this.type != BlockType.ORDERED_LIST && this.type != BlockType.UNORDERED_LIST) {
            return;
        }
        Block block2 = this.blocks;
        boolean bl = false;
        while (block2 != null && !bl) {
            if (block2.type == BlockType.LIST_ITEM) {
                block = block2.blocks;
                while (block != null && !bl) {
                    if (block.type == BlockType.PARAGRAPH) {
                        bl = true;
                    }
                    block = block.next;
                }
            }
            block2 = block2.next;
        }
        if (bl) {
            block2 = this.blocks;
            while (block2 != null) {
                if (block2.type == BlockType.LIST_ITEM) {
                    block = block2.blocks;
                    while (block != null) {
                        if (block.type == BlockType.NONE) {
                            block.type = BlockType.PARAGRAPH;
                        }
                        block = block.next;
                    }
                }
                block2 = block2.next;
            }
        }
    }
}

