/*
 * Decompiled with CFR 0.152.
 */
package au.id.jericho.lib.html;

import au.id.jericho.lib.html.CharacterEntityReference;
import au.id.jericho.lib.html.NumericCharacterReference;
import au.id.jericho.lib.html.Segment;
import au.id.jericho.lib.html.Source;

public abstract class CharacterReference
extends Segment {
    int codePoint;
    static final int MAX_CODE_POINT = 0x10FFFF;
    public static final int INVALID_CODE_POINT = -1;

    CharacterReference(Source source, int begin, int end, int codePoint) {
        super(source, begin, end);
        this.codePoint = codePoint;
    }

    public int getCodePoint() {
        return this.codePoint;
    }

    public char getChar() {
        return (char)this.codePoint;
    }

    public static String encode(String unencodedString) {
        if (unencodedString == null) {
            return null;
        }
        StringBuffer sb = new StringBuffer(unencodedString.length() * 2);
        int i = 0;
        while (i < unencodedString.length()) {
            char ch = unencodedString.charAt(i);
            String characterEntityReferenceName = CharacterEntityReference.getName(ch);
            if (characterEntityReferenceName != null) {
                if (ch == '\'') {
                    sb.append("&#39;");
                } else {
                    CharacterEntityReference.appendCharacterReferenceString(sb, characterEntityReferenceName);
                }
            } else if (ch > '\u007f') {
                CharacterReference.appendDecimalCharacterReferenceString(sb, ch);
            } else {
                sb.append(ch);
            }
            ++i;
        }
        return sb.toString();
    }

    public static String decode(String encodedString) {
        CharacterReference characterReference;
        if (encodedString == null) {
            return null;
        }
        int pos = encodedString.indexOf(38);
        if (pos == -1) {
            return encodedString;
        }
        int lastEnd = 0;
        Source source = new Source(encodedString);
        StringBuffer sb = new StringBuffer();
        while ((characterReference = CharacterReference.findPreviousOrNext(source, pos, false)) != null) {
            if (lastEnd != characterReference.getBegin()) {
                sb.append(encodedString.substring(lastEnd, characterReference.getBegin()));
            }
            sb.append((char)characterReference.codePoint);
            pos = lastEnd = characterReference.getEnd();
        }
        if (lastEnd != encodedString.length()) {
            sb.append(encodedString.substring(lastEnd));
        }
        return sb.toString();
    }

    static CharacterReference findPreviousOrNext(Source source, int pos, boolean previous) {
        String lsource = source.getParseTextLowerCase();
        pos = previous ? lsource.lastIndexOf(38, pos) : lsource.indexOf(38, pos);
        while (pos != -1) {
            CharacterReference characterReference = CharacterReference.construct(source, pos);
            if (characterReference != null) {
                return characterReference;
            }
            int n = pos = previous ? lsource.lastIndexOf(38, pos - 1) : lsource.indexOf(38, pos + 1);
        }
        return null;
    }

    public abstract String getCharacterReferenceString();

    public static String getCharacterReferenceString(int codePoint) {
        String characterReferenceString = CharacterEntityReference.getCharacterReferenceString(codePoint);
        if (characterReferenceString == null) {
            characterReferenceString = NumericCharacterReference.getCharacterReferenceString(codePoint);
        }
        return characterReferenceString;
    }

    public String getDecimalCharacterReferenceString() {
        return CharacterReference.getDecimalCharacterReferenceString(this.codePoint);
    }

    public static String getDecimalCharacterReferenceString(int codePoint) {
        return CharacterReference.appendDecimalCharacterReferenceString(new StringBuffer(), codePoint).toString();
    }

    public String getHexadecimalCharacterReferenceString() {
        return CharacterReference.getHexadecimalCharacterReferenceString(this.codePoint);
    }

    public static String getHexadecimalCharacterReferenceString(int codePoint) {
        return CharacterReference.appendHexadecimalCharacterReferenceString(new StringBuffer(), codePoint).toString();
    }

    public String getUnicodeText() {
        return CharacterReference.getUnicodeText(this.codePoint);
    }

    public static String getUnicodeText(int codePoint) {
        return CharacterReference.appendUnicodeText(new StringBuffer(), codePoint).toString();
    }

    static final StringBuffer appendUnicodeText(StringBuffer sb, int codePoint) {
        sb.append("U+");
        String hex = Integer.toString(codePoint, 16).toUpperCase();
        int i = 4 - hex.length();
        while (i > 0) {
            sb.append('0');
            --i;
        }
        sb.append(hex);
        return sb;
    }

    public static CharacterReference parse(String characterReferenceString) {
        return CharacterReference.construct(new Source(characterReferenceString), 0);
    }

    public static int getCodePointFromCharacterReferenceString(String characterReferenceString) {
        CharacterReference characterReference = CharacterReference.parse(characterReferenceString);
        return characterReference != null ? characterReference.getCodePoint() : -1;
    }

    public static final boolean requiresEncoding(char ch) {
        return ch > '\u007f' || CharacterEntityReference.getName(ch) != null;
    }

    static final StringBuffer appendHexadecimalCharacterReferenceString(StringBuffer sb, int codePoint) {
        return sb.append("&#x").append(Integer.toString(codePoint, 16)).append(';');
    }

    static final StringBuffer appendDecimalCharacterReferenceString(StringBuffer sb, int codePoint) {
        return sb.append("&#").append(codePoint).append(';');
    }

    static CharacterReference construct(Source source, int begin) {
        try {
            if (source.getParseTextLowerCase().charAt(begin) != '&') {
                return null;
            }
            return source.getParseTextLowerCase().charAt(begin + 1) == '#' ? NumericCharacterReference.construct(source, begin) : CharacterEntityReference.construct(source, begin);
        }
        catch (IndexOutOfBoundsException ex) {
            return null;
        }
    }
}

