/*
 * Decompiled with CFR 0.152.
 */
package au.id.jericho.lib.html;

import au.id.jericho.lib.html.Attribute;
import au.id.jericho.lib.html.Attributes;
import au.id.jericho.lib.html.Element;
import au.id.jericho.lib.html.FormControlType;
import au.id.jericho.lib.html.FormField;
import au.id.jericho.lib.html.Segment;
import au.id.jericho.lib.html.StartTag;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;

public final class FormFields {
    private HashMap map = new HashMap();
    private ArrayList list = new ArrayList();

    private FormFields() {
    }

    static FormFields construct(Segment segment) {
        FormFields formFields = new FormFields();
        formFields.loadInputControls(segment);
        formFields.loadTextAreaControls(segment);
        formFields.loadButtonControls(segment);
        formFields.loadSelectControls(segment);
        Collections.sort(formFields.list, FormField.COMPARATOR);
        return formFields;
    }

    public int getCount() {
        return this.list.size();
    }

    public int size() {
        return this.getCount();
    }

    public FormField get(String name) {
        return (FormField)this.map.get(name.toLowerCase());
    }

    public Iterator iterator() {
        return ((AbstractList)this.list).iterator();
    }

    public void merge(FormFields formFields) {
        Iterator i = formFields.iterator();
        while (i.hasNext()) {
            FormField formField = (FormField)i.next();
            String name = formField.getName();
            FormField existingFormField = this.get(name);
            if (existingFormField == null) {
                this.add(formField);
                continue;
            }
            existingFormField.merge(formField);
        }
        Collections.sort(this.list, FormField.COMPARATOR);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        Iterator i = this.iterator();
        while (i.hasNext()) {
            sb.append(i.next());
        }
        return sb.toString();
    }

    private void add(FormField formField) {
        this.map.put(formField.getName().toLowerCase(), formField);
        this.list.add(formField);
    }

    private void loadInputControls(Segment segment) {
        Iterator i = segment.findAllStartTags("input").iterator();
        while (i.hasNext()) {
            Attribute valueAttribute;
            FormControlType formControlType;
            StartTag startTag = (StartTag)i.next();
            Attributes attributes = startTag.getAttributes();
            Attribute nameAttribute = attributes.get("name");
            if (nameAttribute == null || (formControlType = startTag.getFormControlType()) == null) continue;
            String predefinedValue = null;
            if (formControlType.isPredefinedValue() && (valueAttribute = attributes.get("value")) != null) {
                predefinedValue = valueAttribute.getValue();
            }
            String name = nameAttribute.getValue();
            this.registerField(name, startTag.begin, predefinedValue, formControlType);
            String[] additionalSubmitNames = formControlType.getAdditionalSubmitNames(name);
            if (additionalSubmitNames == null) continue;
            int j = 0;
            while (j < additionalSubmitNames.length) {
                this.registerUserValueField(additionalSubmitNames[j], startTag.begin);
                ++j;
            }
        }
    }

    private void loadTextAreaControls(Segment segment) {
        Iterator i = segment.findAllStartTags("textarea").iterator();
        while (i.hasNext()) {
            StartTag startTag = (StartTag)i.next();
            Attributes attributes = startTag.getAttributes();
            Attribute nameAttribute = attributes.get("name");
            if (nameAttribute == null) continue;
            String name = nameAttribute.getValue();
            this.registerUserValueField(name, startTag.begin);
        }
    }

    private void loadButtonControls(Segment segment) {
        Iterator i = segment.findAllStartTags("button").iterator();
        while (i.hasNext()) {
            Attributes attributes;
            Attribute nameAttribute;
            StartTag startTag = (StartTag)i.next();
            FormControlType formControlType = startTag.getFormControlType();
            if (formControlType == null || (nameAttribute = (attributes = startTag.getAttributes()).get("name")) == null) continue;
            String name = nameAttribute.getValue();
            String predefinedValue = null;
            Attribute valueAttribute = attributes.get("value");
            if (valueAttribute != null) {
                predefinedValue = valueAttribute.getValue();
            }
            this.registerField(name, startTag.begin, predefinedValue, formControlType);
        }
    }

    private void loadSelectControls(Segment segment) {
        List selectElements = segment.findAllElements("select");
        if (selectElements.isEmpty()) {
            return;
        }
        List optionTags = segment.findAllStartTags("option");
        if (optionTags.isEmpty()) {
            return;
        }
        Iterator selectIterator = selectElements.iterator();
        Element selectElement = (Element)selectIterator.next();
        Element lastSelectElement = null;
        String name = null;
        FormControlType formControlType = null;
        Iterator optionIterator = optionTags.iterator();
        while (optionIterator.hasNext()) {
            String value;
            StartTag optionTag = (StartTag)optionIterator.next();
            while (optionTag.begin > selectElement.end) {
                if (!selectIterator.hasNext()) {
                    return;
                }
                selectElement = (Element)selectIterator.next();
            }
            if (selectElement != lastSelectElement) {
                if (optionTag.begin < selectElement.begin) continue;
                StartTag selectTag = selectElement.getStartTag();
                formControlType = selectTag.getFormControlType();
                if (formControlType == null) {
                    throw new RuntimeException("Internal Error: FormControlType not recognised for select tag " + selectTag);
                }
                Attribute nameAttribute = selectTag.getAttributes().get("name");
                if (nameAttribute == null) {
                    if (!selectIterator.hasNext()) {
                        return;
                    }
                    selectElement = (Element)selectIterator.next();
                    lastSelectElement = null;
                    continue;
                }
                name = nameAttribute.getValue();
                if (name == null) continue;
            }
            lastSelectElement = selectElement;
            Attribute valueAttribute = optionTag.getAttributes().get("value");
            if (valueAttribute != null) {
                value = valueAttribute.getValue();
            } else {
                Segment valueSegment = optionTag.getFollowingTextSegment();
                value = valueSegment.getSourceTextNoWhitespace();
                if (value.length() == 0) continue;
            }
            this.registerPredefinedValueField(name, selectElement.begin, value, formControlType);
        }
    }

    private void registerField(String name, int position, String predefinedValue, FormControlType formControlType) {
        if (predefinedValue == null) {
            this.registerUserValueField(name, position);
        } else {
            this.registerPredefinedValueField(name, position, predefinedValue, formControlType);
        }
    }

    private void registerUserValueField(String name, int position) {
        FormField formField = this.get(name);
        if (formField == null) {
            formField = new FormField(name, position, null);
            this.add(formField);
        } else {
            formField.setMultipleValues();
            formField.setLowerPosition(position);
        }
        formField.incrementUserValueCount();
    }

    private void registerPredefinedValueField(String name, int position, String predefinedValue, FormControlType formControlType) {
        FormField formField = this.get(name);
        if (formField == null) {
            formField = new FormField(name, position, formControlType);
            this.add(formField);
        } else {
            formField.setMultipleValues(formControlType);
            formField.setLowerPosition(position);
        }
        formField.addPredefinedValue(predefinedValue);
    }
}

