/*
 * Decompiled with CFR 0.152.
 */
package org.stathissideris.ascii2image.core;

import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import javax.imageio.ImageIO;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.cli.PosixParser;
import org.stathissideris.ascii2image.core.ConversionOptions;
import org.stathissideris.ascii2image.core.FileUtils;
import org.stathissideris.ascii2image.core.HTMLConverter;
import org.stathissideris.ascii2image.graphics.BitmapRenderer;
import org.stathissideris.ascii2image.graphics.Diagram;
import org.stathissideris.ascii2image.text.TextGrid;

public class CommandLineConverter {
    private static String notice = "DiTAA version 0.8, Copyright (C) 2004--2009  Efstathios Sideris";
    private static String[] markupModeAllowedValues = new String[]{"use", "ignore", "render"};

    public static void main(String[] args) {
        Option[] opts;
        long startTime = System.currentTimeMillis();
        System.out.println("\n" + notice + "\n");
        Options cmdLnOptions = new Options();
        OptionBuilder.withLongOpt("help");
        OptionBuilder.withDescription("Prints usage help.");
        cmdLnOptions.addOption(OptionBuilder.create());
        cmdLnOptions.addOption("v", "verbose", false, "Makes ditaa more verbose.");
        cmdLnOptions.addOption("o", "overwrite", false, "If the filename of the destination image already exists, an alternative name is chosen. If the overwrite option is selected, the image file is instead overwriten.");
        cmdLnOptions.addOption("S", "no-shadows", false, "Turns off the drop-shadow effect.");
        cmdLnOptions.addOption("A", "no-antialias", false, "Turns anti-aliasing off.");
        cmdLnOptions.addOption("d", "debug", false, "Renders the debug grid over the resulting image.");
        cmdLnOptions.addOption("r", "round-corners", false, "Causes all corners to be rendered as round corners.");
        cmdLnOptions.addOption("E", "no-separation", false, "Prevents the separation of common edges of shapes.");
        cmdLnOptions.addOption("h", "html", false, "In this case the input is an HTML file. The contents of the <pre class=\"textdiagram\"> tags are rendered as diagrams and saved in the images directory and a new HTML file is produced with the appropriate <img> tags.");
        OptionBuilder.withLongOpt("encoding");
        OptionBuilder.withDescription("The encoding of the input file.");
        OptionBuilder.hasArg();
        OptionBuilder.withArgName("ENCODING");
        cmdLnOptions.addOption(OptionBuilder.create('e'));
        OptionBuilder.withLongOpt("scale");
        OptionBuilder.withDescription("A natural number that determines the size of the rendered image. The units are fractions of the default size (2.5 renders 1.5 times bigger than the default).");
        OptionBuilder.hasArg();
        OptionBuilder.withArgName("SCALE");
        cmdLnOptions.addOption(OptionBuilder.create('s'));
        OptionBuilder.withLongOpt("tabs");
        OptionBuilder.withDescription("Tabs are normally interpreted as 8 spaces but it is possible to change that using this option. It is not advisable to use tabs in your diagrams.");
        OptionBuilder.hasArg();
        OptionBuilder.withArgName("TABS");
        cmdLnOptions.addOption(OptionBuilder.create('t'));
        CommandLine cmdLine = null;
        try {
            PosixParser parser = new PosixParser();
            cmdLine = parser.parse(cmdLnOptions, args);
            if (cmdLine.hasOption("block-size")) {
                System.out.println(cmdLine.getOptionValue("block-size"));
            }
        }
        catch (ParseException e) {
            System.err.println(e.getMessage());
            new HelpFormatter().printHelp("java -jar ditaa.jar <inpfile> [outfile]", cmdLnOptions, true);
            System.exit(2);
        }
        if (cmdLine.hasOption("help") || args.length == 0) {
            new HelpFormatter().printHelp("java -jar ditaa.jar <inpfile> [outfile]", cmdLnOptions, true);
            System.exit(0);
        }
        ConversionOptions options = null;
        try {
            options = new ConversionOptions(cmdLine);
        }
        catch (UnsupportedEncodingException e2) {
            System.err.println("Error: " + e2.getMessage());
            System.exit(2);
        }
        args = cmdLine.getArgs();
        if (args.length == 0) {
            System.err.println("Error: Please provide the input file filename");
            new HelpFormatter().printHelp("java -jar ditaa.jar <inpfile> [outfile]", cmdLnOptions, true);
            System.exit(2);
        }
        System.out.println("Running with options:");
        Option[] optionArray = opts = cmdLine.getOptions();
        int n = opts.length;
        int n2 = 0;
        while (n2 < n) {
            Option option = optionArray[n2];
            if (option.hasArgs()) {
                String[] stringArray = option.getValues();
                int n3 = stringArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    String value = stringArray[n4];
                    System.out.println(String.valueOf(option.getLongOpt()) + " = " + value);
                    ++n4;
                }
            } else if (option.hasArg()) {
                System.out.println(String.valueOf(option.getLongOpt()) + " = " + option.getValue());
            } else {
                System.out.println(option.getLongOpt());
            }
            ++n2;
        }
        if (cmdLine.hasOption("html")) {
            String filename = args[0];
            boolean overwrite = false;
            if (options.processingOptions.overwriteFiles()) {
                overwrite = true;
            }
            String toFilename = args.length == 1 ? FileUtils.makeTargetPathname(filename, "html", "_processed", true) : args[1];
            File target = new File(toFilename);
            if (!overwrite && target.exists()) {
                System.out.println("Error: File " + toFilename + " exists. If you would like to overwrite it, please use the --overwrite option.");
                System.exit(0);
            }
            new HTMLConverter().convertHTMLFile(filename, toFilename, "ditaa_diagram", "images", options);
            System.exit(0);
        } else {
            TextGrid grid = new TextGrid();
            if (options.processingOptions.getCustomShapes() != null) {
                grid.addToMarkupTags(options.processingOptions.getCustomShapes().keySet());
            }
            String filename = args[0];
            System.out.println("Reading file: " + filename);
            try {
                if (!grid.loadFrom(filename, options.processingOptions)) {
                    System.err.println("Cannot open file " + filename + " for reading");
                }
            }
            catch (UnsupportedEncodingException e1) {
                System.err.println("Error: " + e1.getMessage());
                System.exit(1);
            }
            catch (FileNotFoundException e1) {
                System.err.println("Error: File " + filename + " does not exist");
                System.exit(1);
            }
            catch (IOException e1) {
                System.err.println("Error: Cannot open file " + filename + " for reading");
                System.exit(1);
            }
            if (options.processingOptions.printDebugOutput()) {
                System.out.println("Using grid:");
                grid.printDebug();
            }
            boolean overwrite = false;
            if (options.processingOptions.overwriteFiles()) {
                overwrite = true;
            }
            String toFilename = args.length == 1 ? FileUtils.makeTargetPathname(filename, "png", overwrite) : args[1];
            Diagram diagram = new Diagram(grid, options);
            System.out.println("Rendering to file: " + toFilename);
            RenderedImage image = new BitmapRenderer().renderToImage(diagram, options.renderingOptions);
            try {
                File file = new File(toFilename);
                ImageIO.write(image, "png", file);
            }
            catch (IOException e) {
                System.err.println("Error: Cannot write to file " + filename);
                System.exit(1);
            }
            long endTime = System.currentTimeMillis();
            long totalTime = (endTime - startTime) / 1000L;
            System.out.println("Done in " + totalTime + "sec");
        }
    }
}

