/*
 * Decompiled with CFR 0.152.
 */
package org.stathissideris.ascii2image.graphics;

import java.awt.Color;
import java.awt.Rectangle;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import org.stathissideris.ascii2image.graphics.CustomShapeDefinition;
import org.stathissideris.ascii2image.graphics.Diagram;
import org.stathissideris.ascii2image.graphics.DiagramComponent;
import org.stathissideris.ascii2image.graphics.ShapeEdge;
import org.stathissideris.ascii2image.graphics.ShapePoint;
import org.stathissideris.ascii2image.text.TextGrid;

public class DiagramShape
extends DiagramComponent {
    private static final boolean DEBUG = false;
    public static final int TYPE_SIMPLE = 0;
    public static final int TYPE_ARROWHEAD = 1;
    public static final int TYPE_POINT_MARKER = 2;
    public static final int TYPE_DOCUMENT = 3;
    public static final int TYPE_STORAGE = 4;
    public static final int TYPE_IO = 5;
    public static final int TYPE_CUSTOM = 9999;
    protected int type = 0;
    private Color fillColor = null;
    private Color strokeColor = Color.black;
    private boolean isClosed = false;
    private boolean isStrokeDashed = false;
    protected ArrayList points = new ArrayList();
    CustomShapeDefinition definition = null;

    public static void main(String[] args) {
    }

    public static DiagramShape createArrowhead(TextGrid grid, TextGrid.Cell cell, int cellXSize, int cellYSize) {
        if (!grid.isArrowhead(cell)) {
            return null;
        }
        if (grid.isNorthArrowhead(cell)) {
            return DiagramShape.createNorthArrowhead(grid, cell, cellXSize, cellYSize);
        }
        if (grid.isSouthArrowhead(cell)) {
            return DiagramShape.createSouthArrowhead(grid, cell, cellXSize, cellYSize);
        }
        if (grid.isWestArrowhead(cell)) {
            return DiagramShape.createWestArrowhead(grid, cell, cellXSize, cellYSize);
        }
        if (grid.isEastArrowhead(cell)) {
            return DiagramShape.createEastArrowhead(grid, cell, cellXSize, cellYSize);
        }
        return null;
    }

    private static DiagramShape createNorthArrowhead(TextGrid grid, TextGrid.Cell cell, int cellXSize, int cellYSize) {
        if (!grid.isNorthArrowhead(cell)) {
            return null;
        }
        DiagramShape shape = new DiagramShape();
        shape.addToPoints(new ShapePoint(Diagram.getCellMidX(cell, cellXSize), Diagram.getCellMinY(cell, cellYSize)));
        shape.addToPoints(new ShapePoint(Diagram.getCellMinX(cell, cellXSize), Diagram.getCellMaxY(cell, cellYSize)));
        shape.addToPoints(new ShapePoint(Diagram.getCellMaxX(cell, cellXSize), Diagram.getCellMaxY(cell, cellYSize)));
        shape.setClosed(true);
        shape.setFillColor(Color.black);
        shape.setStrokeColor(Color.black);
        shape.setType(1);
        return shape;
    }

    private static DiagramShape createSouthArrowhead(TextGrid grid, TextGrid.Cell cell, int cellXSize, int cellYSize) {
        if (!grid.isSouthArrowhead(cell)) {
            return null;
        }
        DiagramShape shape = new DiagramShape();
        shape.addToPoints(new ShapePoint(Diagram.getCellMinX(cell, cellXSize), Diagram.getCellMinY(cell, cellYSize)));
        shape.addToPoints(new ShapePoint(Diagram.getCellMidX(cell, cellXSize), Diagram.getCellMaxY(cell, cellYSize)));
        shape.addToPoints(new ShapePoint(Diagram.getCellMaxX(cell, cellXSize), Diagram.getCellMinY(cell, cellYSize)));
        shape.setClosed(true);
        shape.setFillColor(Color.black);
        shape.setStrokeColor(Color.black);
        shape.setType(1);
        return shape;
    }

    private static DiagramShape createWestArrowhead(TextGrid grid, TextGrid.Cell cell, int cellXSize, int cellYSize) {
        if (!grid.isWestArrowhead(cell)) {
            return null;
        }
        DiagramShape shape = new DiagramShape();
        shape.addToPoints(new ShapePoint(Diagram.getCellMaxX(cell, cellXSize), Diagram.getCellMinY(cell, cellYSize)));
        shape.addToPoints(new ShapePoint(Diagram.getCellMinX(cell, cellXSize), Diagram.getCellMidY(cell, cellYSize)));
        shape.addToPoints(new ShapePoint(Diagram.getCellMaxX(cell, cellXSize), Diagram.getCellMaxY(cell, cellYSize)));
        shape.setClosed(true);
        shape.setFillColor(Color.black);
        shape.setStrokeColor(Color.black);
        shape.setType(1);
        return shape;
    }

    private static DiagramShape createEastArrowhead(TextGrid grid, TextGrid.Cell cell, int cellXSize, int cellYSize) {
        if (!grid.isEastArrowhead(cell)) {
            return null;
        }
        DiagramShape shape = new DiagramShape();
        shape.addToPoints(new ShapePoint(Diagram.getCellMinX(cell, cellXSize), Diagram.getCellMinY(cell, cellYSize)));
        shape.addToPoints(new ShapePoint(Diagram.getCellMaxX(cell, cellXSize), Diagram.getCellMidY(cell, cellYSize)));
        shape.addToPoints(new ShapePoint(Diagram.getCellMinX(cell, cellXSize), Diagram.getCellMaxY(cell, cellYSize)));
        shape.setClosed(true);
        shape.setFillColor(Color.black);
        shape.setStrokeColor(Color.black);
        shape.setType(1);
        return shape;
    }

    public static DiagramShape createSmallLine(TextGrid grid, TextGrid.Cell cell, int cellXSize, int cellYSize) {
        if (grid.isLine(cell)) {
            DiagramShape shape = new DiagramShape();
            if (grid.isHorizontalLine(cell)) {
                shape.addToPoints(new ShapePoint(cell.x * cellXSize, cell.y * cellYSize + cellYSize / 2));
                shape.addToPoints(new ShapePoint(cell.x * cellXSize + cellXSize - 1, cell.y * cellYSize + cellYSize / 2));
            } else if (grid.isVerticalLine(cell)) {
                shape.addToPoints(new ShapePoint(cell.x * cellXSize + cellXSize / 2, cell.y * cellYSize));
                shape.addToPoints(new ShapePoint(cell.x * cellXSize + cellXSize / 2, cell.y * cellYSize + cellYSize - 1));
            }
            return shape;
        }
        return null;
    }

    public void addToPoints(ShapePoint point) {
        this.points.add(point);
    }

    public Iterator getPointsIterator() {
        return this.points.iterator();
    }

    public void scale(float factor) {
        Iterator it = this.getPointsIterator();
        while (it.hasNext()) {
            ShapePoint point = (ShapePoint)it.next();
            point.x *= factor;
            point.y *= factor;
        }
    }

    public boolean isEmpty() {
        return this.points.isEmpty();
    }

    public boolean isFilled() {
        return this.fillColor != null;
    }

    public void setIsNotFilled() {
        this.fillColor = null;
    }

    public boolean isPointLinesEnd(ShapePoint point) {
        if (this.isClosed()) {
            return false;
        }
        if (point == this.points.get(0)) {
            return true;
        }
        return point == this.points.get(this.points.size() - 1);
    }

    public boolean isRectangle() {
        if (this.points.size() != 4) {
            return false;
        }
        ShapePoint p1 = (ShapePoint)this.points.get(0);
        ShapePoint p2 = (ShapePoint)this.points.get(1);
        ShapePoint p3 = (ShapePoint)this.points.get(2);
        ShapePoint p4 = (ShapePoint)this.points.get(3);
        return p1.isInLineWith(p2) && p2.isInLineWith(p3) && p3.isInLineWith(p4) && p4.isInLineWith(p1);
    }

    public boolean isSmallerThan(DiagramShape other) {
        Rectangle bounds = this.getBounds();
        Rectangle otherBounds = other.getBounds();
        int area = bounds.height * bounds.width;
        int otherArea = otherBounds.height * otherBounds.width;
        return area < otherArea;
    }

    public Color getFillColor() {
        return this.fillColor;
    }

    public Color getStrokeColor() {
        return this.strokeColor;
    }

    public void setFillColor(Color color) {
        this.fillColor = color;
    }

    public void setStrokeColor(Color color) {
        this.strokeColor = color;
    }

    public boolean isClosed() {
        return this.isClosed;
    }

    public void setClosed(boolean b) {
        this.isClosed = b;
    }

    public void printDebug() {
        System.out.print("DiagramShape: ");
        System.out.println(String.valueOf(this.points.size()) + " points");
    }

    public ArrayList getPoints() {
        return this.points;
    }

    public ShapePoint getPoint(int i) {
        return (ShapePoint)this.points.get(i);
    }

    public void setPoint(int i, ShapePoint point) {
        this.points.set(i, point);
    }

    public boolean equals(Object object) {
        DiagramShape shape = null;
        if (!(object instanceof DiagramShape)) {
            return false;
        }
        shape = (DiagramShape)object;
        if (this.getPoints().size() != shape.getPoints().size()) {
            return false;
        }
        HashMap points1 = new HashMap();
        Iterator it = this.getPointsIterator();
        while (it.hasNext()) {
            ShapePoint point = (ShapePoint)it.next();
            points1.put((int)point.x + "," + (int)point.y, null);
        }
        HashMap points2 = new HashMap();
        it = shape.getPointsIterator();
        while (it.hasNext()) {
            ShapePoint point = (ShapePoint)it.next();
            points2.put((int)point.x + "," + (int)point.y, null);
        }
        for (String key : points1.keySet()) {
            if (points2.containsKey(key)) continue;
            return false;
        }
        return true;
    }

    public GeneralPath makeIntoPath() {
        int size = this.getPoints().size();
        if (size < 2) {
            return null;
        }
        GeneralPath path = new GeneralPath();
        ShapePoint point = (ShapePoint)this.getPoints().get(0);
        path.moveTo((int)point.x, (int)point.y);
        int i = 1;
        while (i < size) {
            point = (ShapePoint)this.getPoints().get(i);
            path.lineTo((int)point.x, (int)point.y);
            ++i;
        }
        if (this.isClosed() && size > 2) {
            path.closePath();
        }
        return path;
    }

    public GeneralPath makeMarkerPath(Diagram diagram) {
        if (this.points.size() != 1) {
            return null;
        }
        ShapePoint center = this.getPoint(0);
        float diameter = 0.7f * (float)Math.min(diagram.getCellWidth(), diagram.getCellHeight());
        return new GeneralPath(new Ellipse2D.Float(center.x - diameter / 2.0f, center.y - diameter / 2.0f, diameter, diameter));
    }

    public Rectangle getBounds() {
        Rectangle bounds = this.makeIntoPath().getBounds();
        return bounds;
    }

    public GeneralPath makeIntoRenderPath(Diagram diagram) {
        ShapePoint exitPoint;
        ShapePoint entryPoint;
        int size = this.getPoints().size();
        if (this.getType() == 2) {
            return this.makeMarkerPath(diagram);
        }
        if (this.getType() == 3 && this.points.size() == 4) {
            return this.makeDocumentPath(diagram);
        }
        if (this.getType() == 4 && this.points.size() == 4) {
            return this.makeStoragePath(diagram);
        }
        if (this.getType() == 5 && this.points.size() == 4) {
            return this.makeIOPath(diagram);
        }
        if (size < 2) {
            return null;
        }
        GeneralPath path = new GeneralPath();
        ShapePoint point = (ShapePoint)this.getPoints().get(0);
        TextGrid.Cell cell = diagram.getCellFor(point);
        ShapePoint previous = (ShapePoint)this.getPoints().get(size - 1);
        ShapePoint next = (ShapePoint)this.getPoints().get(1);
        if (point.getType() == 0) {
            path.moveTo((int)point.x, (int)point.y);
        } else if (point.getType() == 1) {
            entryPoint = this.getCellEdgePointBetween(point, previous, diagram);
            exitPoint = this.getCellEdgePointBetween(point, next, diagram);
            path.moveTo(entryPoint.x, entryPoint.y);
            path.quadTo(point.x, point.y, exitPoint.x, exitPoint.y);
        }
        int i = 1;
        while (i < size) {
            previous = point;
            point = (ShapePoint)this.getPoints().get(i);
            next = i < size - 1 ? (ShapePoint)this.getPoints().get(i + 1) : (ShapePoint)this.getPoints().get(0);
            cell = diagram.getCellFor(point);
            if (point.getType() == 0) {
                path.lineTo((int)point.x, (int)point.y);
            } else if (point.getType() == 1) {
                entryPoint = this.getCellEdgePointBetween(point, previous, diagram);
                exitPoint = this.getCellEdgePointBetween(point, next, diagram);
                path.lineTo(entryPoint.x, entryPoint.y);
                path.quadTo(point.x, point.y, exitPoint.x, exitPoint.y);
                if (next.getType() == 0) {
                    path.lineTo(next.x, next.y);
                } else if (next.getType() == 1) {
                    entryPoint = this.getCellEdgePointBetween(next, point, diagram);
                    path.lineTo(entryPoint.x, entryPoint.y);
                }
            }
            ++i;
        }
        if (this.isClosed() && size > 2) {
            path.closePath();
        }
        return path;
    }

    public ArrayList getEdges() {
        ArrayList<ShapeEdge> edges = new ArrayList<ShapeEdge>();
        if (this.points.size() == 1) {
            return edges;
        }
        int noOfPoints = this.points.size();
        int i = 0;
        while (i < noOfPoints - 1) {
            ShapePoint startPoint = (ShapePoint)this.points.get(i);
            ShapePoint endPoint = (ShapePoint)this.points.get(i + 1);
            ShapeEdge edge = new ShapeEdge(startPoint, endPoint, this);
            edges.add(edge);
            ++i;
        }
        if (this.isClosed()) {
            ShapePoint firstPoint = (ShapePoint)this.points.get(0);
            ShapePoint lastPoint = (ShapePoint)this.points.get(this.points.size() - 1);
            ShapeEdge edge = new ShapeEdge(lastPoint, firstPoint, this);
            edges.add(edge);
        }
        return edges;
    }

    public ShapePoint getCellEdgePointBetween(ShapePoint pointInCell, ShapePoint otherPoint, Diagram diagram) {
        if (pointInCell == null || otherPoint == null || diagram == null) {
            throw new IllegalArgumentException("None of the parameters can be null");
        }
        if (pointInCell.equals(otherPoint)) {
            throw new IllegalArgumentException("The two points cannot be the same");
        }
        ShapePoint result = null;
        TextGrid.Cell cell = diagram.getCellFor(pointInCell);
        if (cell == null) {
            throw new RuntimeException("Upexpected error, cannot find cell corresponding to point " + pointInCell + " for diagram " + diagram);
        }
        if (otherPoint.isNorthOf(pointInCell)) {
            result = new ShapePoint(pointInCell.x, diagram.getCellMinY(cell));
        } else if (otherPoint.isSouthOf(pointInCell)) {
            result = new ShapePoint(pointInCell.x, diagram.getCellMaxY(cell));
        } else if (otherPoint.isWestOf(pointInCell)) {
            result = new ShapePoint(diagram.getCellMinX(cell), pointInCell.y);
        } else if (otherPoint.isEastOf(pointInCell)) {
            result = new ShapePoint(diagram.getCellMaxX(cell), pointInCell.y);
        }
        if (result == null) {
            throw new RuntimeException("Upexpected error, cannot find cell edge point for points " + pointInCell + " and " + otherPoint + " for diagram " + diagram);
        }
        return result;
    }

    public ShapePoint getCellEdgeProjectionPointBetween(ShapePoint pointInCell, ShapePoint otherPoint, Diagram diagram) {
        if (pointInCell == null || otherPoint == null || diagram == null) {
            throw new IllegalArgumentException("None of the parameters can be null");
        }
        if (pointInCell.equals(otherPoint)) {
            throw new IllegalArgumentException("The two points cannot be the same: " + pointInCell + " and " + otherPoint + " passed");
        }
        ShapePoint result = null;
        TextGrid.Cell cell = diagram.getCellFor(pointInCell);
        if (cell == null) {
            throw new RuntimeException("Upexpected error, cannot find cell corresponding to point " + pointInCell + " for diagram " + diagram);
        }
        if (otherPoint.isNorthOf(pointInCell)) {
            result = new ShapePoint(pointInCell.x, diagram.getCellMaxY(cell));
        } else if (otherPoint.isSouthOf(pointInCell)) {
            result = new ShapePoint(pointInCell.x, diagram.getCellMinY(cell));
        } else if (otherPoint.isWestOf(pointInCell)) {
            result = new ShapePoint(diagram.getCellMaxX(cell), pointInCell.y);
        } else if (otherPoint.isEastOf(pointInCell)) {
            result = new ShapePoint(diagram.getCellMinX(cell), pointInCell.y);
        }
        if (result == null) {
            throw new RuntimeException("Upexpected error, cannot find cell edge point for points " + pointInCell + " and " + otherPoint + " for diagram " + diagram);
        }
        return result;
    }

    public boolean contains(ShapePoint point) {
        GeneralPath path = this.makeIntoPath();
        if (path != null) {
            return path.contains(point);
        }
        return false;
    }

    public boolean contains(Rectangle2D rect) {
        GeneralPath path = this.makeIntoPath();
        if (path != null) {
            return path.contains(rect);
        }
        return false;
    }

    public boolean intersects(Rectangle2D rect) {
        GeneralPath path = this.makeIntoPath();
        if (path != null) {
            return path.intersects(rect);
        }
        return false;
    }

    public boolean dropsShadow() {
        return this.isClosed() && this.getType() != 1 && this.getType() != 2 && !this.isStrokeDashed();
    }

    public int getType() {
        return this.type;
    }

    public void setType(int i) {
        this.type = i;
    }

    public void moveEndsToCellEdges(TextGrid grid, Diagram diagram) {
        if (this.isClosed()) {
            return;
        }
        ShapePoint linesEnd = (ShapePoint)this.points.get(0);
        ShapePoint nextPoint = (ShapePoint)this.points.get(1);
        ShapePoint projectionPoint = this.getCellEdgeProjectionPointBetween(linesEnd, nextPoint, diagram);
        linesEnd.moveTo(projectionPoint);
        linesEnd = (ShapePoint)this.points.get(this.points.size() - 1);
        nextPoint = (ShapePoint)this.points.get(this.points.size() - 2);
        projectionPoint = this.getCellEdgeProjectionPointBetween(linesEnd, nextPoint, diagram);
        linesEnd.moveTo(projectionPoint);
    }

    public void connectEndsToAnchors(TextGrid grid, Diagram diagram) {
        if (this.isClosed()) {
            return;
        }
        ShapePoint linesEnd = (ShapePoint)this.points.get(0);
        ShapePoint nextPoint = (ShapePoint)this.points.get(1);
        this.connectEndToAnchors(grid, diagram, nextPoint, linesEnd);
        linesEnd = (ShapePoint)this.points.get(this.points.size() - 1);
        nextPoint = (ShapePoint)this.points.get(this.points.size() - 2);
        this.connectEndToAnchors(grid, diagram, nextPoint, linesEnd);
    }

    private void connectEndToAnchors(TextGrid grid, Diagram diagram, ShapePoint nextPoint, ShapePoint linesEnd) {
        if (this.isClosed()) {
            return;
        }
        TextGrid.Cell anchorCell = DiagramShape.getPossibleAnchorCell(linesEnd, nextPoint, diagram);
        if (grid.isArrowhead(anchorCell)) {
            linesEnd.x = diagram.getCellMidX(anchorCell);
            linesEnd.y = diagram.getCellMidY(anchorCell);
            linesEnd.setLocked(true);
        } else if (grid.isCorner(anchorCell) || grid.isIntersection(anchorCell)) {
            linesEnd.x = diagram.getCellMidX(anchorCell);
            linesEnd.y = diagram.getCellMidY(anchorCell);
            linesEnd.setLocked(true);
        }
    }

    private static TextGrid.Cell getPossibleAnchorCell(ShapePoint linesEnd, ShapePoint nextPoint, Diagram diagram) {
        ShapePoint cellPoint = null;
        if (nextPoint.isNorthOf(linesEnd)) {
            cellPoint = new ShapePoint(linesEnd.x, linesEnd.y + (float)diagram.getCellHeight());
        }
        if (nextPoint.isSouthOf(linesEnd)) {
            cellPoint = new ShapePoint(linesEnd.x, linesEnd.y - (float)diagram.getCellHeight());
        }
        if (nextPoint.isWestOf(linesEnd)) {
            cellPoint = new ShapePoint(linesEnd.x + (float)diagram.getCellWidth(), linesEnd.y);
        }
        if (nextPoint.isEastOf(linesEnd)) {
            cellPoint = new ShapePoint(linesEnd.x - (float)diagram.getCellWidth(), linesEnd.y);
        }
        return diagram.getCellFor(cellPoint);
    }

    public String toString() {
        String s = "DiagramShape, " + this.points.size() + " points: ";
        Iterator it = this.getPointsIterator();
        while (it.hasNext()) {
            ShapePoint point = (ShapePoint)it.next();
            s = String.valueOf(s) + point;
            if (!it.hasNext()) continue;
            s = String.valueOf(s) + " ";
        }
        return s;
    }

    public boolean isStrokeDashed() {
        return this.isStrokeDashed;
    }

    public void setStrokeDashed(boolean b) {
        this.isStrokeDashed = b;
    }

    private GeneralPath makeStoragePath(Diagram diagram) {
        if (this.points.size() != 4) {
            return null;
        }
        Rectangle bounds = this.makeIntoPath().getBounds();
        ShapePoint point1 = new ShapePoint((float)bounds.getMinX(), (float)bounds.getMinY());
        ShapePoint point2 = new ShapePoint((float)bounds.getMaxX(), (float)bounds.getMinY());
        ShapePoint point3 = new ShapePoint((float)bounds.getMaxX(), (float)bounds.getMaxY());
        ShapePoint point4 = new ShapePoint((float)bounds.getMinX(), (float)bounds.getMaxY());
        ShapePoint pointMidTop = new ShapePoint((float)bounds.getCenterX(), (float)bounds.getMinY());
        ShapePoint pointMidBottom = new ShapePoint((float)bounds.getCenterX(), (float)bounds.getMaxY());
        float diameterX = bounds.width;
        float diameterY = 0.75f * (float)diagram.getCellHeight();
        float cpOffsetX = bounds.width / 6;
        float cpOffsetYTop = diagram.getCellHeight() / 2;
        float cpOffsetYBottom = 10 * diagram.getCellHeight() / 14;
        GeneralPath path = new GeneralPath();
        path.moveTo(point1.x, point1.y);
        path.curveTo(point1.x + cpOffsetX, point1.y + cpOffsetYTop, point2.x - cpOffsetX, point2.y + cpOffsetYTop, point2.x, point2.y);
        path.curveTo(point2.x - cpOffsetX, point2.y - cpOffsetYTop, point1.x + cpOffsetX, point1.y - cpOffsetYTop, point1.x, point1.y);
        path.moveTo(point1.x, point1.y);
        path.lineTo(point4.x, point4.y);
        path.curveTo(point4.x + cpOffsetX, point4.y + cpOffsetYBottom, point3.x - cpOffsetX, point3.y + cpOffsetYBottom, point3.x, point3.y);
        path.lineTo(point2.x, point2.y);
        return path;
    }

    private GeneralPath makeDocumentPath(Diagram diagram) {
        if (this.points.size() != 4) {
            return null;
        }
        Rectangle bounds = this.makeIntoPath().getBounds();
        ShapePoint point1 = new ShapePoint((float)bounds.getMinX(), (float)bounds.getMinY());
        ShapePoint point2 = new ShapePoint((float)bounds.getMaxX(), (float)bounds.getMinY());
        ShapePoint point3 = new ShapePoint((float)bounds.getMaxX(), (float)bounds.getMaxY());
        ShapePoint point4 = new ShapePoint((float)bounds.getMinX(), (float)bounds.getMaxY());
        ShapePoint pointMid = new ShapePoint((float)bounds.getCenterX(), (float)bounds.getMaxY());
        GeneralPath path = new GeneralPath();
        path.moveTo(point1.x, point1.y);
        path.lineTo(point2.x, point2.y);
        path.lineTo(point3.x, point3.y);
        int controlDX = bounds.width / 6;
        int controlDY = bounds.height / 8;
        path.quadTo(pointMid.x + (float)controlDX, pointMid.y - (float)controlDY, pointMid.x, pointMid.y);
        path.quadTo(pointMid.x - (float)controlDX, pointMid.y + (float)controlDY, point4.x, point4.y);
        path.closePath();
        return path;
    }

    private GeneralPath makeIOPath(Diagram diagram) {
        if (this.points.size() != 4) {
            return null;
        }
        Rectangle bounds = this.makeIntoPath().getBounds();
        ShapePoint point1 = new ShapePoint((float)bounds.getMinX(), (float)bounds.getMinY());
        ShapePoint point2 = new ShapePoint((float)bounds.getMaxX(), (float)bounds.getMinY());
        ShapePoint point3 = new ShapePoint((float)bounds.getMaxX(), (float)bounds.getMaxY());
        ShapePoint point4 = new ShapePoint((float)bounds.getMinX(), (float)bounds.getMaxY());
        float offset = diagram.getCellWidth() / 2;
        GeneralPath path = new GeneralPath();
        path.moveTo(point1.x + offset, point1.y);
        path.lineTo(point2.x + offset, point2.y);
        path.lineTo(point3.x - offset, point3.y);
        path.lineTo(point4.x - offset, point4.y);
        path.closePath();
        return path;
    }

    public CustomShapeDefinition getDefinition() {
        return this.definition;
    }

    public void setDefinition(CustomShapeDefinition definition) {
        this.definition = definition;
    }
}

