/*
 * Decompiled with CFR 0.152.
 */
package org.stathissideris.ascii2image.graphics;

import java.awt.Color;
import java.awt.Font;
import java.awt.geom.Rectangle2D;
import org.stathissideris.ascii2image.graphics.DiagramComponent;
import org.stathissideris.ascii2image.graphics.FontMeasurer;

public class DiagramText
extends DiagramComponent {
    private String text;
    private Font font;
    private int xPos;
    private int yPos;
    private Color color = Color.black;
    private boolean isTextOnLine = false;

    public DiagramText(int x, int y, String text, Font font) {
        if (text == null) {
            throw new IllegalArgumentException("DiagramText cannot be initialised with a null string");
        }
        if (text == null) {
            throw new IllegalArgumentException("DiagramText cannot be initialised with a null font");
        }
        this.xPos = x;
        this.yPos = y;
        this.text = text;
        this.font = font;
    }

    public void centerInBounds(Rectangle2D bounds) {
        this.centerHorizontallyBetween((int)bounds.getMinX(), (int)bounds.getMaxX());
        this.centerVerticallyBetween((int)bounds.getMinY(), (int)bounds.getMaxY());
    }

    public void centerHorizontallyBetween(int minX, int maxX) {
        int width = FontMeasurer.instance().getWidthFor(this.text, this.font);
        int center = Math.abs(maxX - minX) / 2;
        this.xPos += Math.abs(center - width / 2);
    }

    public void centerVerticallyBetween(int minY, int maxY) {
        int zHeight = FontMeasurer.instance().getZHeight(this.font);
        int center = Math.abs(maxY - minY) / 2;
        this.yPos -= Math.abs(center - zHeight / 2);
    }

    public void alignRightEdgeTo(int x) {
        int width = FontMeasurer.instance().getWidthFor(this.text, this.font);
        this.xPos = x - width;
    }

    public Color getColor() {
        return this.color;
    }

    public Font getFont() {
        return this.font;
    }

    public String getText() {
        return this.text;
    }

    public int getXPos() {
        return this.xPos;
    }

    public int getYPos() {
        return this.yPos;
    }

    public void setColor(Color color) {
        this.color = color;
    }

    public void setFont(Font font) {
        this.font = font;
    }

    public void setText(String string) {
        this.text = string;
    }

    public void setXPos(int i) {
        this.xPos = i;
    }

    public void setYPos(int i) {
        this.yPos = i;
    }

    public Rectangle2D getBounds() {
        Rectangle2D bounds = FontMeasurer.instance().getBoundsFor(this.text, this.font);
        bounds.setRect(bounds.getMinX() + (double)this.xPos, bounds.getMinY() + (double)this.yPos, bounds.getWidth(), bounds.getHeight());
        return bounds;
    }

    public String toString() {
        return "DiagramText, at (" + this.xPos + ", " + this.yPos + "), within " + this.getBounds() + " '" + this.text + "', " + this.color + " " + this.font;
    }

    public boolean isTextOnLine() {
        return this.isTextOnLine;
    }

    public void setTextOnLine(boolean b) {
        this.isTextOnLine = b;
    }
}

