/*
 * Decompiled with CFR 0.152.
 */
package org.stathissideris.ascii2image.core;

import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.stathissideris.ascii2image.core.ConfigurationParser;
import org.stathissideris.ascii2image.core.ProcessingOptions;
import org.stathissideris.ascii2image.core.RenderingOptions;
import org.stathissideris.ascii2image.graphics.CustomShapeDefinition;
import org.xml.sax.SAXException;

public class ConversionOptions {
    public ProcessingOptions processingOptions = new ProcessingOptions();
    public RenderingOptions renderingOptions = new RenderingOptions();

    public void setDebug(boolean value) {
        this.processingOptions.setPrintDebugOutput(value);
        this.renderingOptions.setRenderDebugLines(value);
    }

    public ConversionOptions() {
    }

    public ConversionOptions(CommandLine cmdLine) throws UnsupportedEncodingException {
        String encoding;
        this.processingOptions.setVerbose(cmdLine.hasOption("verbose"));
        this.renderingOptions.setDropShadows(!cmdLine.hasOption("no-shadows"));
        this.setDebug(cmdLine.hasOption("debug"));
        this.processingOptions.setOverwriteFiles(cmdLine.hasOption("overwrite"));
        if (cmdLine.hasOption("scale")) {
            Float scale = Float.valueOf(Float.parseFloat(cmdLine.getOptionValue("scale")));
            this.renderingOptions.setScale(scale.floatValue());
        }
        this.processingOptions.setAllCornersAreRound(cmdLine.hasOption("round-corners"));
        this.processingOptions.setPerformSeparationOfCommonEdges(!cmdLine.hasOption("no-separation"));
        this.renderingOptions.setAntialias(!cmdLine.hasOption("no-antialias"));
        if (cmdLine.hasOption("tabs")) {
            Integer tabSize = Integer.parseInt(cmdLine.getOptionValue("tabs"));
            int tabSizeValue = tabSize;
            if (tabSizeValue < 0) {
                tabSizeValue = 0;
            }
            this.processingOptions.setTabSize(tabSizeValue);
        }
        if ((encoding = cmdLine.getOptionValue("encoding")) != null) {
            new String(new byte[2], encoding);
            this.processingOptions.setCharacterEncoding(encoding);
        }
        ConfigurationParser configParser = new ConfigurationParser();
        try {
            Option[] optionArray = cmdLine.getOptions();
            int n = optionArray.length;
            int n2 = 0;
            while (n2 < n) {
                Option curOption = optionArray[n2];
                if (curOption.getLongOpt().equals("config")) {
                    String configFilename = curOption.getValue();
                    System.out.println("Parsing configuration file " + configFilename);
                    File file = new File(configFilename);
                    if (file.exists()) {
                        configParser.parseFile(file);
                        HashMap<String, CustomShapeDefinition> shapes = configParser.getShapeDefinitionsHash();
                        this.processingOptions.putAllInCustomShapes(shapes);
                    } else {
                        System.err.println("File " + file + " does not exist, skipping");
                    }
                }
                ++n2;
            }
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
        }
        catch (SAXException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

