/*
 * Decompiled with CFR 0.152.
 */
package au.id.jericho.lib.html;

import au.id.jericho.lib.html.IOutputSegment;
import au.id.jericho.lib.html.Source;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;

public final class OutputDocument {
    private String sourceText;
    private ArrayList outputSegments = new ArrayList();

    public OutputDocument(String sourceText) {
        if (sourceText == null) {
            throw new IllegalArgumentException();
        }
        this.sourceText = sourceText;
    }

    public OutputDocument(Source source) {
        this(source.getSourceText());
    }

    public String getSourceText() {
        return this.sourceText;
    }

    public void add(IOutputSegment outputSegment) {
        this.outputSegments.add(outputSegment);
    }

    public void output(Writer out) throws IOException {
        if (this.outputSegments.isEmpty()) {
            out.write(this.sourceText);
            return;
        }
        int pos = 0;
        Collections.sort(this.outputSegments, IOutputSegment.COMPARATOR);
        Iterator i = ((AbstractList)this.outputSegments).iterator();
        while (i.hasNext()) {
            IOutputSegment outputSegment = (IOutputSegment)i.next();
            if (outputSegment.getBegin() > pos) {
                out.write(this.sourceText.substring(pos, outputSegment.getBegin()));
            }
            outputSegment.output(out);
            pos = outputSegment.getEnd();
        }
        if (pos < this.sourceText.length()) {
            out.write(this.sourceText.substring(pos));
        }
        out.close();
    }

    public String toString() {
        StringWriter out = new StringWriter((int)((double)this.sourceText.length() * 1.5));
        try {
            this.output(out);
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
        return out.toString();
    }
}

