/*
 * Decompiled with CFR 0.152.
 */
package au.id.jericho.lib.html;

import au.id.jericho.lib.html.CharacterReference;
import au.id.jericho.lib.html.Source;

public class NumericCharacterReference
extends CharacterReference {
    private boolean hex;

    private NumericCharacterReference(Source source, int begin, int end, int codePoint, boolean hex) {
        super(source, begin, end, codePoint);
        this.hex = hex;
    }

    public boolean isDecimal() {
        return !this.hex;
    }

    public boolean isHexadecimal() {
        return this.hex;
    }

    public static String encode(String unencodedString) {
        if (unencodedString == null) {
            return null;
        }
        StringBuffer sb = new StringBuffer(unencodedString.length() * 2);
        int i = 0;
        while (i < unencodedString.length()) {
            char ch = unencodedString.charAt(i);
            if (CharacterReference.requiresEncoding(ch)) {
                CharacterReference.appendDecimalCharacterReferenceString(sb, ch);
            } else {
                sb.append(ch);
            }
            ++i;
        }
        return sb.toString();
    }

    public static String encodeDecimal(String unencodedString) {
        return NumericCharacterReference.encode(unencodedString);
    }

    public static String encodeHexadecimal(String unencodedString) {
        if (unencodedString == null) {
            return null;
        }
        StringBuffer sb = new StringBuffer(unencodedString.length() * 2);
        int i = 0;
        while (i < unencodedString.length()) {
            char ch = unencodedString.charAt(i);
            if (CharacterReference.requiresEncoding(ch)) {
                CharacterReference.appendHexadecimalCharacterReferenceString(sb, ch);
            } else {
                sb.append(ch);
            }
            ++i;
        }
        return sb.toString();
    }

    public String getCharacterReferenceString() {
        return this.hex ? CharacterReference.getHexadecimalCharacterReferenceString(this.codePoint) : CharacterReference.getDecimalCharacterReferenceString(this.codePoint);
    }

    public static String getCharacterReferenceString(int codePoint) {
        return CharacterReference.getDecimalCharacterReferenceString(codePoint);
    }

    static CharacterReference construct(Source source, int begin) {
        String codePointString;
        int end;
        int codePointStringBegin;
        String lsource = source.getParseTextLowerCase();
        boolean hex = lsource.charAt(codePointStringBegin = begin + 2) == 'x';
        if (hex) {
            ++codePointStringBegin;
        }
        int maxSourcePos = lsource.length() - 1;
        int x = codePointStringBegin;
        boolean invalidTermination = false;
        while (true) {
            char ch;
            if ((ch = lsource.charAt(x)) == ';') {
                end = x + 1;
                codePointString = lsource.substring(codePointStringBegin, x);
                break;
            }
            if (!(ch >= '0' && ch <= '9' || hex && ch >= 'a' && ch <= 'f')) {
                invalidTermination = true;
            } else if (x == maxSourcePos) {
                invalidTermination = true;
                ++x;
            }
            if (invalidTermination) {
                if (hex) {
                    return null;
                }
                end = x;
                codePointString = lsource.substring(codePointStringBegin, x);
                break;
            }
            ++x;
        }
        if (codePointString.length() == 0) {
            return null;
        }
        int codePoint = -1;
        try {
            codePoint = Integer.parseInt(codePointString, hex ? 16 : 10);
            if (codePoint > 0x10FFFF) {
                codePoint = -1;
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return new NumericCharacterReference(source, begin, end, codePoint, hex);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append('\"');
        if (this.hex) {
            CharacterReference.appendHexadecimalCharacterReferenceString(sb, this.codePoint);
        } else {
            CharacterReference.appendDecimalCharacterReferenceString(sb, this.codePoint);
        }
        sb.append("\" ");
        CharacterReference.appendUnicodeText(sb, this.codePoint);
        sb.append(' ').append(super.toString());
        return sb.toString();
    }
}

