/*
 * Decompiled with CFR 0.152.
 */
package au.id.jericho.lib.html;

import au.id.jericho.lib.html.Segment;
import au.id.jericho.lib.html.Source;
import au.id.jericho.lib.html.StartTag;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Set;

public class Tag
extends Segment {
    String name = null;
    public static final String PROCESSING_INSTRUCTION = "?";
    public static final String XML_DECLARATION = "?xml";
    public static final String DOCTYPE_DECLARATION = "!doctype";
    public static final String SERVER_PHP = "?php";
    public static final String SERVER_COMMON = new String("%");
    public static final String SERVER_MASON_NAMED_BLOCK = new String("%");
    public static final String SERVER_MASON_COMPONENT_CALL = "&";
    public static final String SERVER_MASON_COMPONENT_CALLED_WITH_CONTENT = "&|";
    public static final String A = "a";
    public static final String ABBR = "abbr";
    public static final String ACRONYM = "acronym";
    public static final String ADDRESS = "address";
    public static final String APPLET = "applet";
    public static final String AREA = "area";
    public static final String B = "b";
    public static final String BASE = "base";
    public static final String BASEFONT = "basefont";
    public static final String BDO = "bdo";
    public static final String BIG = "big";
    public static final String BLOCKQUOTE = "blockquote";
    public static final String BODY = "body";
    public static final String BR = "br";
    public static final String BUTTON = "button";
    public static final String CAPTION = "caption";
    public static final String CENTER = "center";
    public static final String CITE = "cite";
    public static final String CODE = "code";
    public static final String COL = "col";
    public static final String COLGROUP = "colgroup";
    public static final String DD = "dd";
    public static final String DEL = "del";
    public static final String DFN = "dfn";
    public static final String DIR = "dir";
    public static final String DIV = "div";
    public static final String DL = "dl";
    public static final String DT = "dt";
    public static final String EM = "em";
    public static final String FIELDSET = "fieldset";
    public static final String FONT = "font";
    public static final String FORM = "form";
    public static final String FRAME = "frame";
    public static final String FRAMESET = "frameset";
    public static final String H1 = "h1";
    public static final String H2 = "h2";
    public static final String H3 = "h3";
    public static final String H4 = "h4";
    public static final String H5 = "h5";
    public static final String H6 = "h6";
    public static final String HEAD = "head";
    public static final String HR = "hr";
    public static final String HTML = "html";
    public static final String I = "i";
    public static final String IFRAME = "iframe";
    public static final String IMG = "img";
    public static final String INPUT = "input";
    public static final String INS = "ins";
    public static final String ISINDEX = "isindex";
    public static final String KBD = "kbd";
    public static final String LABEL = "label";
    public static final String LEGEND = "legend";
    public static final String LI = "li";
    public static final String LINK = "link";
    public static final String MAP = "map";
    public static final String MENU = "menu";
    public static final String META = "meta";
    public static final String NOFRAMES = "noframes";
    public static final String NOSCRIPT = "noscript";
    public static final String OBJECT = "object";
    public static final String OL = "ol";
    public static final String OPTGROUP = "optgroup";
    public static final String OPTION = "option";
    public static final String P = "p";
    public static final String PARAM = "param";
    public static final String PRE = "pre";
    public static final String Q = "q";
    public static final String S = "s";
    public static final String SAMP = "samp";
    public static final String SCRIPT = "script";
    public static final String SELECT = "select";
    public static final String SMALL = "small";
    public static final String SPAN = "span";
    public static final String STRIKE = "strike";
    public static final String STRONG = "strong";
    public static final String STYLE = "style";
    public static final String SUB = "sub";
    public static final String SUP = "sup";
    public static final String TABLE = "table";
    public static final String TBODY = "tbody";
    public static final String TD = "td";
    public static final String TEXTAREA = "textarea";
    public static final String TFOOT = "tfoot";
    public static final String TH = "th";
    public static final String THEAD = "thead";
    public static final String TITLE = "title";
    public static final String TR = "tr";
    public static final String TT = "tt";
    public static final String U = "u";
    public static final String UL = "ul";
    public static final String VAR = "var";
    private static final TagSet END_TAG_FORBIDDEN_SET = new TagSet(new String[]{"area", "base", "basefont", "br", "col", "frame", "hr", "img", "input", "isindex", "link", "meta", "param"});
    private static final TagSet BLOCK_SET = new TagSet(new String[]{"p", "h1", "h2", "h3", "h4", "h5", "h6", "ul", "ol", "dir", "menu", "pre", "dl", "div", "center", "noscript", "noframes", "blockquote", "form", "isindex", "hr", "table", "fieldset", "address"});
    private static final TagSet INLINE_SET = new TagSet(new String[]{"tt", "i", "b", "u", "s", "strike", "big", "small", "em", "strong", "dfn", "code", "samp", "kbd", "var", "cite", "abbr", "acronym", "a", "img", "applet", "object", "font", "basefont", "br", "script", "map", "q", "sub", "sup", "span", "bdo", "iframe", "input", "select", "textarea", "label", "button", "ins", "del"});
    private static final TagSet _HTML = new TagSet().union("html");
    private static final TagSet _TABLE = new TagSet().union("table");
    private static final TagSet _DL = new TagSet().union("dl");
    private static final TagSet _LI = new TagSet().union("li");
    private static final TagSet _UL_OL = new TagSet().union("ul").union("ol");
    private static final TagSet _DD_DT = new TagSet().union("dd").union("dt");
    private static final TagSet _BODY_FRAMESET = new TagSet().union("body").union("frameset");
    private static final TagSet _THEAD_TBODY_TFOOT_TR = new TagSet().union("thead").union("tbody").union("tfoot").union("tr");
    private static final TagSet _THEAD_TBODY_TFOOT_TR_COLGROUP = new TagSet().union(_THEAD_TBODY_TFOOT_TR).union("colgroup");
    private static final TagSet _THEAD_TBODY_TFOOT_TR_TD_TH = new TagSet().union(_THEAD_TBODY_TFOOT_TR).union("td").union("th");
    private static final TagSet _THEAD_TBODY_TFOOT_TR_TABLE = new TagSet().union(_THEAD_TBODY_TFOOT_TR).union("table");
    private static final TagSet _THEAD_TBODY_TFOOT_TABLE = new TagSet().union(_THEAD_TBODY_TFOOT_TR_TABLE).minus("tr");
    private static final TagSet _OPTION_OPTGROUP = new TagSet().union("option").union("optgroup");
    private static final TagSet _SELECT = new TagSet().union("select");
    private static final TagSet _TBODY_TFOOT = new TagSet().union("tbody").union("tfoot");
    private static final TagSet _TBODY_THEAD = new TagSet().union("tbody").union("thead");
    private static final TagSet _BLOCKSET_DL_DD_DT_TABLE_TH_TD_LI = new TagSet().union(BLOCK_SET).union("dl").union(_DD_DT).union("table").union("th").union("td").union("li");
    private static final TagSet _BLOCKSET_DL_DD_DT_TABLE_BODY_HTML_THEAD_TBODY_TFOOT_TR_TD_TH_CAPTION_LEGEND = new TagSet().union(BLOCK_SET).union("dl").union(_DD_DT).union("table").union("body").union("html").union(_THEAD_TBODY_TFOOT_TR_TD_TH).union("caption").union("legend");
    private static final TerminatorSets DEFINITION_TERMINATOR_SETS = new TerminatorSets(_DD_DT, _DL, _DL);
    private static final TerminatorSets TABLE_CELL_TERMINATOR_SETS = new TerminatorSets(_THEAD_TBODY_TFOOT_TR_TD_TH, _THEAD_TBODY_TFOOT_TR_TABLE, _TABLE);
    private static final TerminatorSets TABLE_SECTION_TERMINATOR_SETS = new TerminatorSets(_TBODY_THEAD, _TABLE, _TABLE);
    private static final HashMap OPTIONAL_END_TAG_TERMINATOR_SETS_MAP = Tag.buildOptionalEndTagTerminatorSetsMap();
    static final Tag CACHED_NULL = new Tag();

    public String getName() {
        return this.name;
    }

    Tag(Source source, int begin, int end, String name) {
        super(source, begin, end);
        this.name = name.toLowerCase();
    }

    Tag() {
    }

    TerminatorSets getOptionalEndTagTerminatorSets() {
        return (TerminatorSets)OPTIONAL_END_TAG_TERMINATOR_SETS_MAP.get(this.name);
    }

    static boolean isEndTagForbidden(String name) {
        return END_TAG_FORBIDDEN_SET.contains(name.toLowerCase());
    }

    static boolean isEndTagOptional(String name) {
        return OPTIONAL_END_TAG_TERMINATOR_SETS_MAP.containsKey(name.toLowerCase());
    }

    static boolean isEndTagRequired(String name) {
        return !Tag.isEndTagForbidden(name) && !Tag.isEndTagOptional(name);
    }

    static boolean isBlock(String name) {
        return BLOCK_SET.contains(name.toLowerCase());
    }

    static boolean isInline(String name) {
        return INLINE_SET.contains(name.toLowerCase());
    }

    static Iterator getNextTagIterator(Source source, int pos) {
        return new NextTagIterator(source, pos);
    }

    private static HashMap buildOptionalEndTagTerminatorSetsMap() {
        HashMap<String, TerminatorSets> map = new HashMap<String, TerminatorSets>();
        map.put(BODY, new TerminatorSets(null, _HTML, _HTML));
        map.put(COLGROUP, new TerminatorSets(_THEAD_TBODY_TFOOT_TR_COLGROUP, _TABLE, _TABLE));
        map.put(DD, DEFINITION_TERMINATOR_SETS);
        map.put(DT, DEFINITION_TERMINATOR_SETS);
        map.put(HEAD, new TerminatorSets(_BODY_FRAMESET, _HTML, null));
        map.put(HTML, new TerminatorSets(null, null, _HTML));
        map.put(LI, new TerminatorSets(_LI, _UL_OL, _UL_OL));
        map.put(OPTION, new TerminatorSets(_OPTION_OPTGROUP, _SELECT, null));
        map.put(P, new TerminatorSets(_BLOCKSET_DL_DD_DT_TABLE_TH_TD_LI, _BLOCKSET_DL_DD_DT_TABLE_BODY_HTML_THEAD_TBODY_TFOOT_TR_TD_TH_CAPTION_LEGEND, null));
        map.put(TBODY, new TerminatorSets(_TBODY_TFOOT, _TABLE, _TABLE));
        map.put(TD, TABLE_CELL_TERMINATOR_SETS);
        map.put(TFOOT, TABLE_SECTION_TERMINATOR_SETS);
        map.put(TH, TABLE_CELL_TERMINATOR_SETS);
        map.put(THEAD, TABLE_SECTION_TERMINATOR_SETS);
        map.put(TR, new TerminatorSets(_THEAD_TBODY_TFOOT_TR, _THEAD_TBODY_TFOOT_TABLE, _TABLE));
        return map;
    }

    private static class NextTagIterator
    implements Iterator {
        private Source source;
        private Tag nextTag = null;
        private Tag cachedTagAfterNext;
        private boolean cachedTagAfterNextIsStartTag = false;

        public NextTagIterator(Source source, int pos) {
            this.source = source;
            Segment enclosingComment = source.findEnclosingComment(pos);
            if (enclosingComment != null) {
                pos = enclosingComment.end;
            }
            this.cachedTagAfterNext = source.findNextEndTag(pos);
            this.loadNextTag(pos);
        }

        public boolean hasNext() {
            return this.nextTag != null;
        }

        public Object next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            Tag result = this.nextTag;
            this.loadNextTag(result.end);
            return result;
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }

        private void loadNextTag(int pos) {
            Tag tag = this.nextTag = this.cachedTagAfterNextIsStartTag ? this.source.findNextEndTag(pos) : this.source.findNextStartTag(pos);
            if (this.cachedTagAfterNext == null) {
                return;
            }
            if (this.nextTag != null && this.nextTag.begin < this.cachedTagAfterNext.begin) {
                if (!this.cachedTagAfterNextIsStartTag && ((StartTag)this.nextTag).isComment() && this.cachedTagAfterNext.begin < this.nextTag.end) {
                    this.cachedTagAfterNext = this.source.findNextEndTag(this.nextTag.end);
                }
                return;
            }
            Tag newNextTag = this.cachedTagAfterNext;
            this.cachedTagAfterNext = this.nextTag;
            this.nextTag = newNextTag;
            this.cachedTagAfterNextIsStartTag = !this.cachedTagAfterNextIsStartTag;
        }
    }

    static final class TerminatorSets {
        private Set startTagTerminatorSet;
        private Set endTagTerminatorSet;
        private Set ignoredNestedElementSet;

        public TerminatorSets(TagSet startTagTerminatorSet, TagSet endTagTerminatorSet, TagSet ignoredNestedElementSet) {
            this.startTagTerminatorSet = startTagTerminatorSet;
            this.endTagTerminatorSet = endTagTerminatorSet;
            this.ignoredNestedElementSet = ignoredNestedElementSet;
        }

        public Set getStartTagTerminatorSet() {
            return this.startTagTerminatorSet;
        }

        public Set getEndTagTerminatorSet() {
            return this.endTagTerminatorSet;
        }

        public Set getIgnoredNestedElementSet() {
            return this.ignoredNestedElementSet;
        }
    }

    private static final class TagSet
    extends HashSet {
        public TagSet() {
        }

        public TagSet(String[] items) {
            int i = 0;
            while (i < items.length) {
                this.add(items[i]);
                ++i;
            }
        }

        public TagSet union(String item) {
            this.add(item);
            return this;
        }

        public TagSet union(Collection collection) {
            Iterator i = collection.iterator();
            while (i.hasNext()) {
                this.add(i.next());
            }
            return this;
        }

        public TagSet minus(String item) {
            this.remove(item);
            return this;
        }
    }
}

