/*
 * Decompiled with CFR 0.152.
 */
package org.stathissideris.ascii2image.core;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;

public class FileUtils {
    public static String makeTargetPathname(String sourcePathname, String extension, boolean overwrite) {
        return FileUtils.makeTargetPathname(sourcePathname, extension, "", overwrite);
    }

    public static String makeTargetPathname(String sourcePathname, String extension, String postfix, boolean overwrite) {
        File sourceFile = new File(sourcePathname);
        String path = "";
        if (sourceFile.getParentFile() != null && !(path = sourceFile.getParentFile().getAbsolutePath()).endsWith(File.separator)) {
            path = String.valueOf(path) + File.separator;
        }
        String baseName = FileUtils.getBaseName(sourceFile.getName());
        String targetName = String.valueOf(path) + baseName + postfix + "." + extension;
        if (new File(targetName).exists() && !overwrite) {
            targetName = FileUtils.makeAlternativePathname(targetName);
        }
        return targetName;
    }

    public static String makeAlternativePathname(String pathName) {
        int limit = 100;
        int i = 2;
        while (i <= limit) {
            String alternative = String.valueOf(FileUtils.getBaseName(pathName)) + "_" + i;
            String extension = FileUtils.getExtension(pathName);
            if (extension != null) {
                alternative = String.valueOf(alternative) + "." + extension;
            }
            if (!new File(alternative).exists()) {
                return alternative;
            }
            ++i;
        }
        return null;
    }

    public static String getExtension(String pathName) {
        if (pathName.lastIndexOf(46) == -1) {
            return null;
        }
        return pathName.substring(pathName.lastIndexOf(46) + 1);
    }

    public static String getBaseName(String pathName) {
        if (pathName.lastIndexOf(46) == -1) {
            return pathName;
        }
        return pathName.substring(0, pathName.lastIndexOf(46));
    }

    public static String readFile(File file) throws IOException {
        return FileUtils.readFile(file, null);
    }

    public static String readFile(File file, String encoding) throws IOException {
        FileInputStream is = new FileInputStream(file);
        long length = file.length();
        byte[] bytes = new byte[(int)length];
        int offset = 0;
        int numRead = 0;
        while (offset < bytes.length && (numRead = ((InputStream)is).read(bytes, offset, bytes.length - offset)) >= 0) {
            offset += numRead;
        }
        if (offset < bytes.length) {
            throw new IOException("Could not completely read file " + file.getName());
        }
        ((InputStream)is).close();
        if (encoding == null) {
            return new String(bytes);
        }
        return new String(bytes, encoding);
    }

    public static void main(String[] args) {
        System.out.println(FileUtils.makeTargetPathname("C:\\Files\\papar.txt", "jpg", false));
        System.out.println(FileUtils.makeTargetPathname("C:\\Files\\papar", "jpg", false));
        System.out.println(FileUtils.makeTargetPathname("papar.txt", "jpg", false));
        System.out.println(FileUtils.makeTargetPathname("/home/sideris/tsourekia/papar.txt", "jpg", false));
        System.out.println(FileUtils.makeTargetPathname("D:\\diagram.max", "jpg", false));
        System.out.println(FileUtils.makeAlternativePathname("C:\\Files\\papar.txt"));
        System.out.println(FileUtils.makeAlternativePathname("C:\\Files\\papar"));
        System.out.println(FileUtils.getExtension("pipi.jpeg"));
        System.out.println(FileUtils.getExtension("pipi"));
    }
}

