/*
 * Decompiled with CFR 0.152.
 */
package org.stathissideris.ascii2image.core;

import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.imageio.ImageIO;
import org.stathissideris.ascii2image.core.ConversionOptions;
import org.stathissideris.ascii2image.graphics.BitmapRenderer;
import org.stathissideris.ascii2image.graphics.Diagram;
import org.stathissideris.ascii2image.text.TextGrid;

public class VisualTester {
    private static final String HTMLReportName = "test_suite";

    public static void main(String[] stringArray) {
        VisualTester visualTester = new VisualTester();
        String string = "tests/text";
        String string2 = "tests/images";
        File file = new File(string);
        ArrayList<File> arrayList = new ArrayList<File>(Arrays.asList(file.listFiles()));
        HashSet<String> hashSet = new HashSet<String>();
        hashSet.addAll(Arrays.asList("dak_orgstruktur_vs_be.ditaa.OutOfMemoryError.txt", "dak_orgstruktur_vs_be.ditaa.OutOfMemoryError.2.txt", "dak_orgstruktur_vs_be.ditaa.OutOfMemoryError.3.txt", "dak_orgstruktur_vs_be.ditaa.OutOfMemoryError.4.txt", "dak_orgstruktur_vs_be.ditaa.OutOfMemoryError.edit.txt", "dak_orgstruktur_vs_be.ditaa.txt"));
        Iterator<File> iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            String string3 = iterator.next().toString();
            if (string3.matches(".+\\.txt$") && !VisualTester.isInExcluded(string3, hashSet)) continue;
            iterator.remove();
        }
        visualTester.createHTMLTestReport(arrayList, string2, HTMLReportName);
        System.out.println("Tests completed");
    }

    private static boolean isInExcluded(String string, Set<String> set) {
        for (String string2 : set) {
            if (!string.endsWith(string2)) continue;
            return true;
        }
        return false;
    }

    public boolean createHTMLTestReport(ArrayList<File> arrayList, String string, String string2) {
        Object object;
        ConversionOptions conversionOptions = new ConversionOptions();
        String string3 = string + "/" + string2 + ".html";
        if (!new File(string).exists()) {
            object = new File(string);
            ((File)object).mkdir();
        }
        object = null;
        try {
            object = new PrintWriter(new FileWriter(string3));
        }
        catch (IOException iOException) {
            System.err.println("Cannot open file " + string3 + " for writing:");
            iOException.printStackTrace();
            return false;
        }
        ((PrintWriter)object).println("<html><body>");
        ((PrintWriter)object).println("<h1>ditaa test suite</h1>");
        ((PrintWriter)object).println("<h2>generated on: " + Calendar.getInstance().getTime() + "</h2>");
        for (File file : arrayList) {
            long l;
            TextGrid textGrid = new TextGrid();
            File file2 = new File(string + File.separator + file.getName() + ".png");
            long l2 = System.nanoTime();
            try {
                System.out.println("Rendering " + file + " to " + file2);
                textGrid.loadFrom(file.toString());
                Diagram diagram = new Diagram(textGrid, conversionOptions);
                RenderedImage renderedImage = new BitmapRenderer().renderToImage(diagram, conversionOptions.renderingOptions);
                l = System.nanoTime();
                System.out.println("Done in " + Math.round((double)(l - l2) / 1.0E7) + "msec");
                try {
                    File file3 = new File(file2.getAbsolutePath());
                    ImageIO.write(renderedImage, "png", file3);
                }
                catch (IOException iOException) {
                    System.err.println("Error: Cannot write to file " + file2);
                    System.exit(1);
                }
            }
            catch (Exception exception) {
                ((PrintWriter)object).println("<b>!!! Failed to render: " + file + " !!!</b>");
                ((PrintWriter)object).println("<pre>\n" + textGrid.getDebugString() + "\n</pre>");
                ((PrintWriter)object).println(exception.getMessage());
                ((PrintWriter)object).println("<hr />");
                ((PrintWriter)object).flush();
                System.err.println("!!! Failed to render: " + file + " !!!");
                exception.printStackTrace(System.err);
                continue;
            }
            ((PrintWriter)object).println(this.makeReportTable(file.getName(), textGrid, file2.getName(), l - l2));
            ((PrintWriter)object).println("<hr />");
            ((PrintWriter)object).flush();
        }
        ((PrintWriter)object).println("</body></html>");
        ((PrintWriter)object).flush();
        ((PrintWriter)object).close();
        System.out.println("Wrote HTML report to " + new File(string3).getAbsolutePath());
        return true;
    }

    private String makeReportTable(String string, TextGrid textGrid, String string2, long l) {
        StringBuffer stringBuffer = new StringBuffer("<center><table border=\"0\">");
        stringBuffer.append("<th colspan=\"2\"><h3>" + string + " (" + Math.round((double)l / 1.0E7) + "msec)</h3></th>");
        stringBuffer.append("<tr><td><pre>\n" + textGrid.getDebugString() + "\n</pre></td>");
        stringBuffer.append("<td><img border=\"0\" src=\"" + string2 + "\"</td></tr>");
        stringBuffer.append("</table></center>");
        return stringBuffer.toString();
    }
}

