/*
 * Decompiled with CFR 0.152.
 */
package org.stathissideris.ascii2image.text;

import java.util.ArrayList;
import java.util.Iterator;
import org.stathissideris.ascii2image.text.GridPatternGroup;
import org.stathissideris.ascii2image.text.TextGrid;

public class GridPattern
extends TextGrid {
    private ArrayList regExps = new ArrayList();
    private boolean regExpsAreValid = false;
    private static final boolean DEBUG = false;
    private boolean usesStandardSyntax = false;

    public GridPattern() {
        super(3, 3);
    }

    public GridPattern(String row1, String row2, String row3) {
        super(Math.max(Math.max(row1.length(), row2.length()), row3.length()), 3);
        this.setTo(row1, row2, row3);
        this.regExpsAreValid = false;
    }

    public boolean usesStandardSyntax() {
        return this.usesStandardSyntax;
    }

    public void setUsesStandardSyntax(boolean b) {
        this.usesStandardSyntax = b;
        this.regExpsAreValid = false;
    }

    public boolean isMatchedBy(TextGrid grid) {
        if (!this.regExpsAreValid) {
            this.prepareRegExps();
        }
        int i = 0;
        while (i < grid.getHeight()) {
            String regexp;
            String row = grid.getRow(i).toString();
            if (!row.matches(regexp = (String)this.regExps.get(i))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private void prepareRegExps() {
        this.regExpsAreValid = true;
        this.regExps.clear();
        if (!this.usesStandardSyntax) {
            Iterator<StringBuffer> it = this.getRows().iterator();
            while (it.hasNext()) {
                String row = it.next().toString();
                this.regExps.add(this.makeRegExp(row));
            }
        } else {
            Iterator<StringBuffer> it = this.getRows().iterator();
            while (it.hasNext()) {
                String row = it.next().toString();
                this.regExps.add(row);
            }
        }
    }

    private String makeRegExp(String pattern) {
        String result = "";
        int tokensHandled = 0;
        int i = 0;
        while (i < pattern.length() && tokensHandled < 3) {
            char c = pattern.charAt(i);
            if (c == '[') {
                result = String.valueOf(result) + "[^|:]";
            } else if (c == '|') {
                result = String.valueOf(result) + "[|:]";
            } else if (c == '-') {
                result = String.valueOf(result) + "-";
            } else if (c == '!') {
                result = String.valueOf(result) + "[^-=\\/\\\\+|:]";
            } else if (c == 'b') {
                result = String.valueOf(result) + "[-=\\/\\\\+|:]";
            } else if (c == '^') {
                result = String.valueOf(result) + "[\\/\\\\+|:]";
            } else if (c == '(') {
                result = String.valueOf(result) + "[-=\\/\\\\+]";
            } else if (c == '~') {
                result = String.valueOf(result) + ".";
            } else if (c == '+') {
                result = String.valueOf(result) + "\\+";
            } else if (c == '\\') {
                result = String.valueOf(result) + "\\\\";
            } else if (c == 's') {
                result = String.valueOf(result) + "[-=+|:]";
            } else if (c == 'S') {
                result = String.valueOf(result) + "[\\/\\\\]";
            } else if (c == '*') {
                result = String.valueOf(result) + "\\*";
            } else if (c == '1') {
                result = String.valueOf(result) + "[\\\\]";
            } else if (c == '2') {
                result = String.valueOf(result) + "[|:+\\/\\\\]";
            } else if (c == '3') {
                result = String.valueOf(result) + "[\\/]";
            } else if (c == '4') {
                result = String.valueOf(result) + "[-=+\\/\\\\]";
            } else if (c == '5') {
                result = String.valueOf(result) + "[\\\\]";
            } else if (c == '6') {
                result = String.valueOf(result) + "[|:+\\/\\\\]";
            } else if (c == '7') {
                result = String.valueOf(result) + "[\\/]";
            } else if (c == '8') {
                result = String.valueOf(result) + "[-=+\\/\\\\]";
            } else if (c == '%') {
                if (i + 1 > pattern.length()) {
                    throw new RuntimeException("Invalid pattern, found % at the end");
                }
                if ((c = pattern.charAt(++i)) == '1') {
                    result = String.valueOf(result) + "[^\\\\]";
                } else if (c == '2') {
                    result = String.valueOf(result) + "[^|:+\\/\\\\]";
                } else if (c == '3') {
                    result = String.valueOf(result) + "[^\\/]";
                } else if (c == '4') {
                    result = String.valueOf(result) + "[^-=+\\/\\\\]";
                } else if (c == '5') {
                    result = String.valueOf(result) + "[^\\\\]";
                } else if (c == '6') {
                    result = String.valueOf(result) + "[^|:+\\/\\\\]";
                } else if (c == '7') {
                    result = String.valueOf(result) + "[^\\/]";
                } else if (c == '8') {
                    result = String.valueOf(result) + "[^-=+\\/\\\\]";
                }
            } else {
                result = String.valueOf(result) + String.valueOf(c);
            }
            ++tokensHandled;
            ++i;
        }
        return result;
    }

    public void setTo(String row1, String row2, String row3) {
        if (this.getHeight() != 3) {
            throw new RuntimeException("This method can only be called for GridPatternS with height 3");
        }
        this.regExpsAreValid = false;
        this.writeStringTo(0, 0, row1);
        this.writeStringTo(0, 1, row2);
        this.writeStringTo(0, 2, row3);
    }

    public static void main(String[] args) {
        TextGrid grid = new TextGrid(3, 3);
        grid.setRow(0, "---");
        grid.setRow(1, " / ");
        grid.setRow(2, "---");
        grid.printDebug();
        if (GridPatternGroup.loneDiagonalCriteria.isAnyMatchedBy(grid)) {
            System.out.println("Grid is lone diagonal");
        } else {
            System.out.println("Grid is not lone diagonal");
        }
        grid.setRow(0, "--/");
        grid.setRow(1, " / ");
        grid.setRow(2, "---");
        grid.printDebug();
        if (GridPatternGroup.loneDiagonalCriteria.isAnyMatchedBy(grid)) {
            System.out.println("Grid is lone diagonal");
        } else {
            System.out.println("Grid is not lone diagonal");
        }
        grid.setRow(0, "-- ");
        grid.setRow(1, " \\ ");
        grid.setRow(2, "---");
        grid.printDebug();
        if (GridPatternGroup.loneDiagonalCriteria.isAnyMatchedBy(grid)) {
            System.out.println("Grid is lone diagonal");
        } else {
            System.out.println("Grid is not lone diagonal");
        }
        grid.setRow(0, "-- ");
        grid.setRow(1, " \\ ");
        grid.setRow(2, "--\\");
        grid.printDebug();
        if (GridPatternGroup.loneDiagonalCriteria.isAnyMatchedBy(grid)) {
            System.out.println("Grid is lone diagonal");
        } else {
            System.out.println("Grid is not lone diagonal");
        }
        grid.setRow(0, "   ");
        grid.setRow(1, "-\\/");
        grid.setRow(2, " ||");
        grid.printDebug();
        if (GridPatternGroup.loneDiagonalCriteria.isAnyMatchedBy(grid)) {
            System.out.println("Grid is lone diagonal");
        } else {
            System.out.println("Grid is not lone diagonal");
        }
    }
}

