/*
 * Decompiled with CFR 0.152.
 */
package org.stathissideris.ascii2image.graphics;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.image.BufferedImage;
import java.awt.image.ConvolveOp;
import java.awt.image.Kernel;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import javax.imageio.ImageIO;
import org.stathissideris.ascii2image.core.ConversionOptions;
import org.stathissideris.ascii2image.core.RenderingOptions;
import org.stathissideris.ascii2image.core.Shape3DOrderingComparator;
import org.stathissideris.ascii2image.graphics.Diagram;
import org.stathissideris.ascii2image.graphics.DiagramShape;
import org.stathissideris.ascii2image.graphics.DiagramText;
import org.stathissideris.ascii2image.text.TextGrid;

public class BitmapRenderer {
    private static final boolean DEBUG = false;

    public static void main(String[] args) throws Exception {
        long startTime = System.currentTimeMillis();
        ConversionOptions options = new ConversionOptions();
        TextGrid grid = new TextGrid();
        grid.loadFrom("d:/devel/java/ascii2image/art5.txt");
        Diagram diagram = new Diagram(grid, options);
        BitmapRenderer.renderToPNG(diagram, "d:/devel/java/ascii2image/test.png", options.renderingOptions);
        long endTime = System.currentTimeMillis();
        long totalTime = (endTime - startTime) / 1000L;
        System.out.println("Done in " + totalTime + "sec");
    }

    private static boolean renderToPNG(Diagram diagram, String filename, RenderingOptions options) {
        RenderedImage image = BitmapRenderer.renderToImage(diagram, options);
        try {
            File file = new File(filename);
            ImageIO.write(image, "png", file);
        }
        catch (IOException e) {
            System.err.println("Error: Cannot write to file " + filename);
            return false;
        }
        return true;
    }

    public static RenderedImage renderToImage(Diagram diagram, RenderingOptions options) {
        BufferedImage image = new BufferedImage(diagram.getWidth(), diagram.getHeight(), 1);
        return BitmapRenderer.render(diagram, image, options);
    }

    public static RenderedImage render(Diagram diagram, BufferedImage image, RenderingOptions options) {
        DiagramShape shape;
        DiagramShape shape2;
        Iterator shapesIt;
        BufferedImage renderedImage = image;
        Graphics2D g2 = image.createGraphics();
        Object antialiasSetting = RenderingHints.VALUE_ANTIALIAS_OFF;
        if (options.performAntialias()) {
            antialiasSetting = RenderingHints.VALUE_ANTIALIAS_ON;
        }
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, antialiasSetting);
        g2.setColor(Color.white);
        g2.fillRect(0, 0, image.getWidth() + 10, image.getHeight() + 10);
        g2.setStroke(new BasicStroke(1.0f, 2, 1));
        ArrayList shapes = diagram.getAllDiagramShapes();
        if (options.dropShadows()) {
            shapesIt = ((AbstractList)shapes).iterator();
            while (shapesIt.hasNext()) {
                DiagramShape shape3 = (DiagramShape)shapesIt.next();
                if (shape3.getPoints().isEmpty()) continue;
                GeneralPath path = shape3.makeIntoRenderPath(diagram);
                float offset = diagram.getMinimumOfCellDimension() / 3.333f;
                if (path == null || !shape3.dropsShadow()) continue;
                GeneralPath shadow = new GeneralPath(path);
                AffineTransform translate = new AffineTransform();
                translate.setToTranslation(offset, offset);
                shadow.transform(translate);
                g2.setColor(new Color(150, 150, 150));
                g2.fill(shadow);
            }
            int blurRadius = 6;
            int blurRadius2 = blurRadius * blurRadius;
            float blurRadius2F = blurRadius2;
            float weight = 1.0f / blurRadius2F;
            float[] elements = new float[blurRadius2];
            int k = 0;
            while (k < blurRadius2) {
                elements[k] = weight;
                ++k;
            }
            Kernel myKernel = new Kernel(blurRadius, blurRadius, elements);
            ConvolveOp simpleBlur = new ConvolveOp(myKernel, 1, null);
            BufferedImage destination = new BufferedImage(image.getWidth(), image.getHeight(), image.getType());
            simpleBlur.filter(image, destination);
            g2 = destination.createGraphics();
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, antialiasSetting);
            renderedImage = destination;
        }
        float dashInterval = Math.min(diagram.getCellWidth(), diagram.getCellHeight()) / 2;
        float strokeWeight = diagram.getMinimumOfCellDimension() / 10.0f;
        BasicStroke normalStroke = new BasicStroke(strokeWeight, 1, 1);
        BasicStroke dashStroke = new BasicStroke(strokeWeight, 0, 1, 0.0f, new float[]{dashInterval}, 0.0f);
        ArrayList<DiagramShape> storageShapes = new ArrayList<DiagramShape>();
        shapesIt = ((AbstractList)shapes).iterator();
        while (shapesIt.hasNext()) {
            shape2 = (DiagramShape)shapesIt.next();
            if (shape2.getType() != 4) continue;
            storageShapes.add(shape2);
        }
        Collections.sort(storageShapes, new Shape3DOrderingComparator());
        g2.setStroke(normalStroke);
        shapesIt = ((AbstractList)storageShapes).iterator();
        while (shapesIt.hasNext()) {
            shape2 = (DiagramShape)shapesIt.next();
            GeneralPath path = shape2.makeIntoRenderPath(diagram);
            if (!shape2.isStrokeDashed()) {
                if (shape2.getFillColor() != null) {
                    g2.setColor(shape2.getFillColor());
                } else {
                    g2.setColor(Color.white);
                }
                g2.fill(path);
            }
            if (shape2.isStrokeDashed()) {
                g2.setStroke(dashStroke);
            } else {
                g2.setStroke(normalStroke);
            }
            g2.setColor(shape2.getStrokeColor());
            g2.draw(path);
        }
        ArrayList<DiagramShape> pointMarkers = new ArrayList<DiagramShape>();
        shapesIt = ((AbstractList)shapes).iterator();
        while (shapesIt.hasNext()) {
            shape = (DiagramShape)shapesIt.next();
            if (shape.getType() == 2) {
                pointMarkers.add(shape);
                continue;
            }
            if (shape.getType() == 4 || shape.getPoints().isEmpty()) continue;
            int size = shape.getPoints().size();
            GeneralPath path = shape.makeIntoRenderPath(diagram);
            if (path != null && shape.isClosed() && !shape.isStrokeDashed()) {
                if (shape.getFillColor() != null) {
                    g2.setColor(shape.getFillColor());
                } else {
                    g2.setColor(Color.white);
                }
                g2.fill(path);
            }
            if (shape.getType() == 1) continue;
            g2.setColor(shape.getStrokeColor());
            if (shape.isStrokeDashed()) {
                g2.setStroke(dashStroke);
            } else {
                g2.setStroke(normalStroke);
            }
            g2.draw(path);
        }
        g2.setStroke(normalStroke);
        shapesIt = ((AbstractList)pointMarkers).iterator();
        while (shapesIt.hasNext()) {
            shape = (DiagramShape)shapesIt.next();
            GeneralPath path = shape.makeIntoRenderPath(diagram);
            g2.setColor(Color.white);
            g2.fill(path);
            g2.setColor(shape.getStrokeColor());
            g2.draw(path);
        }
        Iterator textIt = ((AbstractList)diagram.getTextObjects()).iterator();
        while (textIt.hasNext()) {
            DiagramText text = (DiagramText)textIt.next();
            g2.setColor(text.getColor());
            g2.setFont(text.getFont());
            g2.drawString(text.getText(), text.getXPos(), text.getYPos());
        }
        if (options.renderDebugLines()) {
            BasicStroke debugStroke = new BasicStroke(1.0f, 1, 1);
            g2.setStroke(debugStroke);
            g2.setColor(new Color(170, 170, 170));
            g2.setXORMode(Color.white);
            int x = 0;
            while (x < diagram.getWidth()) {
                g2.drawLine(x, 0, x, diagram.getHeight());
                x += diagram.getCellWidth();
            }
            int y = 0;
            while (y < diagram.getHeight()) {
                g2.drawLine(0, y, diagram.getWidth(), y);
                y += diagram.getCellHeight();
            }
        }
        g2.dispose();
        return renderedImage;
    }

    public static boolean isColorDark(Color color) {
        int brightness = Math.max(color.getRed(), color.getGreen());
        brightness = Math.max(color.getBlue(), brightness);
        return brightness < 200;
    }
}

