/*
 * Decompiled with CFR 0.152.
 */
package au.id.jericho.lib.html;

import au.id.jericho.lib.html.Attributes;
import au.id.jericho.lib.html.BlankOutputSegment;
import au.id.jericho.lib.html.CharacterReference;
import au.id.jericho.lib.html.Element;
import au.id.jericho.lib.html.EndTag;
import au.id.jericho.lib.html.OutputDocument;
import au.id.jericho.lib.html.SearchCache;
import au.id.jericho.lib.html.Segment;
import au.id.jericho.lib.html.SpecialTag;
import au.id.jericho.lib.html.StartTag;
import au.id.jericho.lib.html.Tag;
import java.io.IOException;
import java.io.Writer;
import java.util.Collection;
import java.util.Iterator;

public class Source
extends Segment {
    String text;
    private String parseTextLowerCase = null;
    private OutputDocument parseTextLowerCaseOutputDocument = null;
    private Writer logWriter = null;
    private SearchCache searchCache = null;

    public Source(String text) {
        super(0, text.length());
        this.source = this;
        this.text = text;
    }

    public String getSourceText() {
        return this.text;
    }

    public String toString() {
        return this.text;
    }

    public String getSourceTextLowerCase() {
        return this.text.toLowerCase();
    }

    public StartTag findPreviousStartTag(int pos) {
        return this.findPreviousStartTag(pos, null);
    }

    public StartTag findPreviousStartTag(int pos, String name) {
        if (name != null) {
            name = name.toLowerCase();
        }
        return StartTag.findPreviousOrNext(this, pos, name, true);
    }

    public StartTag findNextStartTag(int pos) {
        return this.findNextStartTag(pos, null);
    }

    public StartTag findNextStartTag(int pos, String name) {
        if (name != null) {
            name = name.toLowerCase();
        }
        return StartTag.findPreviousOrNext(this, pos, name, false);
    }

    public StartTag findNextComment(int pos) {
        return this.findNextStartTag(pos, SpecialTag.COMMENT.getName());
    }

    public EndTag findPreviousEndTag(int pos, String name) {
        if (name == null) {
            throw new IllegalArgumentException();
        }
        return EndTag.findPreviousOrNext(this, pos, name.toLowerCase(), true);
    }

    public EndTag findNextEndTag(int pos) {
        return EndTag.findNext(this, pos);
    }

    public EndTag findNextEndTag(int pos, String name) {
        if (name == null) {
            throw new IllegalArgumentException();
        }
        return EndTag.findPreviousOrNext(this, pos, name.toLowerCase(), false);
    }

    public Iterator getNextTagIterator(int pos) {
        return Tag.getNextTagIterator(this, pos);
    }

    public Tag findNextTag(int pos) {
        Iterator i = this.getNextTagIterator(pos);
        return i.hasNext() ? (Tag)i.next() : null;
    }

    public StartTag findEnclosingStartTag(int pos) {
        return this.findEnclosingStartTag(pos, null);
    }

    public Segment findEnclosingComment(int pos) {
        return this.findEnclosingStartTag(pos, SpecialTag.COMMENT.getName());
    }

    public Element findEnclosingElement(int pos) {
        return this.findEnclosingElement(pos, null);
    }

    public Element findEnclosingElement(int pos, String name) {
        int startBefore = pos;
        if (name != null) {
            name = name.toLowerCase();
        }
        StartTag startTag;
        while ((startTag = this.findPreviousStartTag(startBefore, name)) != null) {
            Element element = startTag.getElement();
            if (pos < element.end) {
                return element;
            }
            startBefore = startTag.begin - 1;
        }
        return null;
    }

    public CharacterReference findPreviousCharacterReference(int pos) {
        return CharacterReference.findPreviousOrNext(this, pos, true);
    }

    public CharacterReference findNextCharacterReference(int pos) {
        return CharacterReference.findPreviousOrNext(this, pos, false);
    }

    public Attributes parseAttributes(int pos, int maxEnd) {
        return this.parseAttributes(pos, maxEnd, Attributes.getDefaultMaxErrorCount());
    }

    public Attributes parseAttributes(int pos, int maxEnd, int maxErrorCount) {
        return Attributes.construct(this, pos, maxEnd, maxErrorCount);
    }

    public void ignoreWhenParsing(int begin, int end) {
        if (this.parseTextLowerCaseOutputDocument == null) {
            this.parseTextLowerCaseOutputDocument = new OutputDocument(this.getParseTextLowerCase());
            this.parseTextLowerCase = null;
        }
        this.parseTextLowerCaseOutputDocument.add(new BlankOutputSegment(begin, end));
    }

    public void ignoreWhenParsing(Collection segments) {
        Iterator i = segments.iterator();
        while (i.hasNext()) {
            ((Segment)i.next()).ignoreWhenParsing();
        }
    }

    public void setLogWriter(Writer writer) {
        this.logWriter = writer;
    }

    final String getParseTextLowerCase() {
        if (this.parseTextLowerCase == null) {
            if (this.parseTextLowerCaseOutputDocument != null) {
                this.parseTextLowerCase = this.parseTextLowerCaseOutputDocument.toString();
                this.parseTextLowerCaseOutputDocument = null;
            } else {
                this.parseTextLowerCase = this.text.toLowerCase();
            }
        }
        return this.parseTextLowerCase;
    }

    final int getIdentifierEnd(int pos, boolean fromStart) {
        if (fromStart && !Segment.isIdentifierStart(this.text.charAt(pos++))) {
            return -1;
        }
        while (Segment.isIdentifierPart(this.text.charAt(pos))) {
            ++pos;
        }
        return pos;
    }

    public int findEnd(int pos, SpecialTag specialTag) {
        int delimiterBegin = this.text.indexOf(specialTag.getEndDelimiter(), pos);
        return delimiterBegin == -1 ? -1 : delimiterBegin + specialTag.getEndDelimiter().length();
    }

    private StartTag findEnclosingStartTag(int pos, String name) {
        StartTag startTag = this.findPreviousStartTag(pos, name);
        if (startTag == null || startTag.end <= pos) {
            return null;
        }
        return startTag;
    }

    private void logLine(String message) {
        try {
            this.logWriter.write(message);
            this.logWriter.write(10);
            this.logWriter.flush();
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    void log(int pos, String message) {
        if (this.logWriter == null) {
            return;
        }
        this.logLine(String.valueOf(pos) + ": " + message);
    }

    void log(String type, String name, int begin, String message, int pos) {
        if (this.logWriter == null) {
            return;
        }
        StringBuffer sb = new StringBuffer(type);
        if (name != null) {
            sb.append(' ').append(name);
        }
        sb.append(" at ").append(begin).append(' ').append(message);
        if (pos != -1) {
            sb.append(" at position ").append(pos);
        }
        this.logLine(sb.toString());
    }

    final SearchCache getSearchCache() {
        if (this.searchCache == null) {
            this.searchCache = new SearchCache();
        }
        return this.searchCache;
    }
}

