/*
 * Decompiled with CFR 0.152.
 */
package org.stathissideris.ascii2image.graphics;

import java.awt.Color;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import org.apache.batik.bridge.BridgeContext;
import org.apache.batik.bridge.GVTBuilder;
import org.apache.batik.bridge.UserAgent;
import org.apache.batik.bridge.UserAgentAdapter;
import org.apache.batik.dom.svg.SAXSVGDocumentFactory;
import org.apache.batik.gvt.GraphicsNode;
import org.apache.batik.gvt.renderer.ConcreteImageRendererFactory;
import org.apache.batik.gvt.renderer.ImageRenderer;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;
import org.w3c.dom.svg.SVGDocument;
import org.w3c.dom.svg.SVGElement;

public class OffScreenSVGRenderer {
    public BufferedImage renderXMLToImage(String xmlContent, int width, int height) throws IOException {
        return this.renderXMLToImage(xmlContent, width, height, false, null, null);
    }

    public BufferedImage renderXMLToImage(String xmlContent, int width, int height, boolean stretch, String idRegex, Color replacementColor) throws IOException {
        String uri = "file:/fake.svg";
        SAXSVGDocumentFactory df = new SAXSVGDocumentFactory("org.apache.xerces.parsers.SAXParser");
        SVGDocument document = df.createSVGDocument(uri, (Reader)new StringReader(xmlContent));
        if (idRegex != null && replacementColor != null) {
            this.replaceFill(document, idRegex, replacementColor);
        }
        return this.renderToImage(document, width, height, stretch);
    }

    public BufferedImage renderToImage(String uri, int width, int height) throws IOException {
        return this.renderToImage(uri, width, height, false, null, null);
    }

    public BufferedImage renderToImage(String uri, int width, int height, boolean stretch, String idRegex, Color replacementColor) throws IOException {
        SAXSVGDocumentFactory df = new SAXSVGDocumentFactory("org.apache.xerces.parsers.SAXParser");
        SVGDocument document = df.createSVGDocument(uri);
        if (idRegex != null && replacementColor != null) {
            this.replaceFill(document, idRegex, replacementColor);
        }
        return this.renderToImage(document, width, height, stretch);
    }

    public BufferedImage renderToImage(SVGDocument document, int width, int height) {
        return this.renderToImage(document, width, height, false);
    }

    public void replaceFill(SVGDocument document, String idRegex, Color color) {
        String colorCode = String.format("#%02x%02x%02x", color.getRed(), color.getGreen(), color.getBlue());
        System.out.println("color code: " + colorCode);
        NodeList children = document.getElementsByTagName("*");
        int i = 0;
        while (i < children.getLength()) {
            SVGElement element;
            if (children.item(i) instanceof SVGElement && (element = (SVGElement)children.item(i)).getId().matches(idRegex)) {
                System.out.println("child>>> " + element + ", " + element.getId());
                String style = element.getAttributeNS(null, "style");
                style = style.replaceFirst("fill:#[a-zA-z0-9]+", "fill:" + colorCode);
                System.out.println(style);
                element.setAttributeNS(null, "style", style);
            }
            ++i;
        }
    }

    public BufferedImage renderToImage(SVGDocument document, int width, int height, boolean stretch) {
        ConcreteImageRendererFactory rendererFactory = new ConcreteImageRendererFactory();
        ImageRenderer renderer = rendererFactory.createStaticImageRenderer();
        GVTBuilder builder = new GVTBuilder();
        BridgeContext ctx = new BridgeContext((UserAgent)new UserAgentAdapter());
        ctx.setDynamicState(0);
        GraphicsNode rootNode = builder.build(ctx, (Document)document);
        renderer.setTree(rootNode);
        float docWidth = (float)ctx.getDocumentSize().getWidth();
        float docHeight = (float)ctx.getDocumentSize().getHeight();
        float xscale = (float)width / docWidth;
        float yscale = (float)height / docHeight;
        if (!stretch) {
            float scale;
            xscale = scale = Math.min(xscale, yscale);
            yscale = scale;
        }
        AffineTransform px = AffineTransform.getScaleInstance(xscale, yscale);
        double tx = 0.0f + ((float)width / xscale - docWidth) / 2.0f;
        double ty = 0.0f + ((float)height / yscale - docHeight) / 2.0f;
        px.translate(tx, ty);
        renderer.updateOffScreen(width, height);
        renderer.setTree(rootNode);
        renderer.setTransform(px);
        renderer.repaint((Shape)new Rectangle(0, 0, width, height));
        return renderer.getOffScreen();
    }
}

