/*
 * Decompiled with CFR 0.152.
 */
package au.id.jericho.lib.html;

import au.id.jericho.lib.html.Attributes;
import au.id.jericho.lib.html.BlankOutputSegment;
import au.id.jericho.lib.html.CharacterReference;
import au.id.jericho.lib.html.Element;
import au.id.jericho.lib.html.EndTag;
import au.id.jericho.lib.html.OutputDocument;
import au.id.jericho.lib.html.SearchCache;
import au.id.jericho.lib.html.Segment;
import au.id.jericho.lib.html.SpecialTag;
import au.id.jericho.lib.html.StartTag;
import au.id.jericho.lib.html.Tag;
import java.io.IOException;
import java.io.Writer;
import java.util.Collection;
import java.util.Iterator;

public class Source
extends Segment {
    String text;
    private String parseTextLowerCase = null;
    private OutputDocument parseTextLowerCaseOutputDocument = null;
    private Writer logWriter = null;
    private SearchCache searchCache = null;

    public Source(String string) {
        super(0, string.length());
        this.source = this;
        this.text = string;
    }

    public String getSourceText() {
        return this.text;
    }

    public String toString() {
        return this.text;
    }

    public String getSourceTextLowerCase() {
        return this.text.toLowerCase();
    }

    public StartTag findPreviousStartTag(int n) {
        return this.findPreviousStartTag(n, null);
    }

    public StartTag findPreviousStartTag(int n, String string) {
        if (string != null) {
            string = string.toLowerCase();
        }
        return StartTag.findPreviousOrNext(this, n, string, true);
    }

    public StartTag findNextStartTag(int n) {
        return this.findNextStartTag(n, null);
    }

    public StartTag findNextStartTag(int n, String string) {
        if (string != null) {
            string = string.toLowerCase();
        }
        return StartTag.findPreviousOrNext(this, n, string, false);
    }

    public StartTag findNextComment(int n) {
        return this.findNextStartTag(n, SpecialTag.COMMENT.getName());
    }

    public EndTag findPreviousEndTag(int n, String string) {
        if (string == null) {
            throw new IllegalArgumentException();
        }
        return EndTag.findPreviousOrNext(this, n, string.toLowerCase(), true);
    }

    public EndTag findNextEndTag(int n) {
        return EndTag.findNext(this, n);
    }

    public EndTag findNextEndTag(int n, String string) {
        if (string == null) {
            throw new IllegalArgumentException();
        }
        return EndTag.findPreviousOrNext(this, n, string.toLowerCase(), false);
    }

    public Iterator getNextTagIterator(int n) {
        return Tag.getNextTagIterator(this, n);
    }

    public Tag findNextTag(int n) {
        Iterator iterator = this.getNextTagIterator(n);
        return iterator.hasNext() ? (Tag)iterator.next() : null;
    }

    public StartTag findEnclosingStartTag(int n) {
        return this.findEnclosingStartTag(n, null);
    }

    public Segment findEnclosingComment(int n) {
        return this.findEnclosingStartTag(n, SpecialTag.COMMENT.getName());
    }

    public Element findEnclosingElement(int n) {
        return this.findEnclosingElement(n, null);
    }

    public Element findEnclosingElement(int n, String string) {
        int n2 = n;
        if (string != null) {
            string = string.toLowerCase();
        }
        StartTag startTag;
        while ((startTag = this.findPreviousStartTag(n2, string)) != null) {
            Element element = startTag.getElement();
            if (n < element.end) {
                return element;
            }
            n2 = startTag.begin - 1;
        }
        return null;
    }

    public CharacterReference findPreviousCharacterReference(int n) {
        return CharacterReference.findPreviousOrNext(this, n, true);
    }

    public CharacterReference findNextCharacterReference(int n) {
        return CharacterReference.findPreviousOrNext(this, n, false);
    }

    public Attributes parseAttributes(int n, int n2) {
        return this.parseAttributes(n, n2, Attributes.getDefaultMaxErrorCount());
    }

    public Attributes parseAttributes(int n, int n2, int n3) {
        return Attributes.construct(this, n, n2, n3);
    }

    public void ignoreWhenParsing(int n, int n2) {
        if (this.parseTextLowerCaseOutputDocument == null) {
            this.parseTextLowerCaseOutputDocument = new OutputDocument(this.getParseTextLowerCase());
            this.parseTextLowerCase = null;
        }
        this.parseTextLowerCaseOutputDocument.add(new BlankOutputSegment(n, n2));
    }

    public void ignoreWhenParsing(Collection collection) {
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            ((Segment)iterator.next()).ignoreWhenParsing();
        }
    }

    public void setLogWriter(Writer writer) {
        this.logWriter = writer;
    }

    final String getParseTextLowerCase() {
        if (this.parseTextLowerCase == null) {
            if (this.parseTextLowerCaseOutputDocument != null) {
                this.parseTextLowerCase = this.parseTextLowerCaseOutputDocument.toString();
                this.parseTextLowerCaseOutputDocument = null;
            } else {
                this.parseTextLowerCase = this.text.toLowerCase();
            }
        }
        return this.parseTextLowerCase;
    }

    final int getIdentifierEnd(int n, boolean bl) {
        if (bl && !Source.isIdentifierStart(this.text.charAt(n++))) {
            return -1;
        }
        while (Source.isIdentifierPart(this.text.charAt(n))) {
            ++n;
        }
        return n;
    }

    public int findEnd(int n, SpecialTag specialTag) {
        int n2 = this.text.indexOf(specialTag.getEndDelimiter(), n);
        return n2 == -1 ? -1 : n2 + specialTag.getEndDelimiter().length();
    }

    private StartTag findEnclosingStartTag(int n, String string) {
        StartTag startTag = this.findPreviousStartTag(n, string);
        if (startTag == null || startTag.end <= n) {
            return null;
        }
        return startTag;
    }

    private void logLine(String string) {
        try {
            this.logWriter.write(string);
            this.logWriter.write(10);
            this.logWriter.flush();
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }

    void log(int n, String string) {
        if (this.logWriter == null) {
            return;
        }
        this.logLine(n + ": " + string);
    }

    void log(String string, String string2, int n, String string3, int n2) {
        if (this.logWriter == null) {
            return;
        }
        StringBuffer stringBuffer = new StringBuffer(string);
        if (string2 != null) {
            stringBuffer.append(' ').append(string2);
        }
        stringBuffer.append(" at ").append(n).append(' ').append(string3);
        if (n2 != -1) {
            stringBuffer.append(" at position ").append(n2);
        }
        this.logLine(stringBuffer.toString());
    }

    final SearchCache getSearchCache() {
        if (this.searchCache == null) {
            this.searchCache = new SearchCache();
        }
        return this.searchCache;
    }
}

